/*
 * Decompiled with CFR 0.152.
 */
package jenkins.security;

import hudson.ExtensionList;
import hudson.ExtensionPoint;
import hudson.security.SecurityRealm;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.Nonnull;
import org.acegisecurity.GrantedAuthority;
import org.acegisecurity.userdetails.UserDetails;

public abstract class SecurityListener
implements ExtensionPoint {
    private static final Logger LOGGER = Logger.getLogger(SecurityListener.class.getName());

    protected void authenticated(@Nonnull UserDetails details) {
    }

    protected void failedToAuthenticate(@Nonnull String username) {
    }

    protected void loggedIn(@Nonnull String username) {
    }

    protected void failedToLogIn(@Nonnull String username) {
    }

    protected void loggedOut(@Nonnull String username) {
    }

    public static void fireAuthenticated(@Nonnull UserDetails details) {
        if (LOGGER.isLoggable(Level.FINE)) {
            ArrayList<String> groups = new ArrayList<String>();
            for (GrantedAuthority auth : details.getAuthorities()) {
                if (auth.equals(SecurityRealm.AUTHENTICATED_AUTHORITY)) continue;
                groups.add(auth.getAuthority());
            }
            LOGGER.log(Level.FINE, "authenticated: {0} {1}", new Object[]{details.getUsername(), groups});
        }
        for (SecurityListener l : SecurityListener.all()) {
            l.authenticated(details);
        }
    }

    public static void fireFailedToAuthenticate(@Nonnull String username) {
        LOGGER.log(Level.FINE, "failed to authenticate: {0}", username);
        for (SecurityListener l : SecurityListener.all()) {
            l.failedToAuthenticate(username);
        }
    }

    public static void fireLoggedIn(@Nonnull String username) {
        LOGGER.log(Level.FINE, "logged in: {0}", username);
        for (SecurityListener l : SecurityListener.all()) {
            l.loggedIn(username);
        }
    }

    public static void fireFailedToLogIn(@Nonnull String username) {
        LOGGER.log(Level.FINE, "failed to log in: {0}", username);
        for (SecurityListener l : SecurityListener.all()) {
            l.failedToLogIn(username);
        }
    }

    public static void fireLoggedOut(@Nonnull String username) {
        LOGGER.log(Level.FINE, "logged out: {0}", username);
        for (SecurityListener l : SecurityListener.all()) {
            l.loggedOut(username);
        }
    }

    private static List<SecurityListener> all() {
        return ExtensionList.lookup(SecurityListener.class);
    }
}

