/*
 * Decompiled with CFR 0.152.
 */
package jenkins.security;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.util.concurrent.UncheckedExecutionException;
import hudson.Extension;
import hudson.ExtensionList;
import hudson.security.UserMayOrMayNotExistException;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import jenkins.model.Jenkins;
import jenkins.util.SystemProperties;
import org.acegisecurity.userdetails.UserDetails;
import org.acegisecurity.userdetails.UsernameNotFoundException;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.NoExternalUse;
import org.springframework.dao.DataAccessException;

@Extension
public final class UserDetailsCache {
    private static final String SYS_PROP_NAME = UserDetailsCache.class.getName() + ".EXPIRE_AFTER_WRITE_SEC";
    private static Integer EXPIRE_AFTER_WRITE_SEC = SystemProperties.getInteger(SYS_PROP_NAME, (int)TimeUnit.MINUTES.toSeconds(2L));
    private final Cache<String, UserDetails> detailsCache;
    private final Cache<String, Boolean> existenceCache;

    @Restricted(value={NoExternalUse.class})
    public UserDetailsCache() {
        if ((EXPIRE_AFTER_WRITE_SEC == null || EXPIRE_AFTER_WRITE_SEC <= 0) && (EXPIRE_AFTER_WRITE_SEC = SystemProperties.getInteger(SYS_PROP_NAME, (int)TimeUnit.MINUTES.toSeconds(2L))) <= 0) {
            EXPIRE_AFTER_WRITE_SEC = (int)TimeUnit.MINUTES.toSeconds(2L);
        }
        this.detailsCache = CacheBuilder.newBuilder().softValues().expireAfterWrite((long)EXPIRE_AFTER_WRITE_SEC.intValue(), TimeUnit.SECONDS).build();
        this.existenceCache = CacheBuilder.newBuilder().softValues().expireAfterWrite((long)EXPIRE_AFTER_WRITE_SEC.intValue(), TimeUnit.SECONDS).build();
    }

    public static UserDetailsCache get() {
        return ExtensionList.lookupSingleton(UserDetailsCache.class);
    }

    @CheckForNull
    public UserDetails getCached(String idOrFullName) throws UsernameNotFoundException {
        Boolean exists = (Boolean)this.existenceCache.getIfPresent((Object)idOrFullName);
        if (exists != null && !exists.booleanValue()) {
            throw new UserMayOrMayNotExistException(String.format("\"%s\" does not exist", idOrFullName));
        }
        return (UserDetails)this.detailsCache.getIfPresent((Object)idOrFullName);
    }

    @Nonnull
    public UserDetails loadUserByUsername(String idOrFullName) throws UsernameNotFoundException, DataAccessException, ExecutionException {
        Boolean exists = (Boolean)this.existenceCache.getIfPresent((Object)idOrFullName);
        if (exists != null && !exists.booleanValue()) {
            throw new UsernameNotFoundException(String.format("\"%s\" does not exist", idOrFullName));
        }
        try {
            return (UserDetails)this.detailsCache.get((Object)idOrFullName, (Callable)new Retriever(idOrFullName));
        }
        catch (UncheckedExecutionException | ExecutionException e) {
            if (e.getCause() instanceof UsernameNotFoundException) {
                throw (UsernameNotFoundException)e.getCause();
            }
            if (e.getCause() instanceof DataAccessException) {
                throw (DataAccessException)e.getCause();
            }
            throw e;
        }
    }

    public void invalidateAll() {
        this.existenceCache.invalidateAll();
        this.detailsCache.invalidateAll();
    }

    public void invalidate(String idOrFullName) {
        this.existenceCache.invalidate((Object)idOrFullName);
        this.detailsCache.invalidate((Object)idOrFullName);
    }

    private class Retriever
    implements Callable<UserDetails> {
        private final String idOrFullName;

        private Retriever(String idOrFullName) {
            this.idOrFullName = idOrFullName;
        }

        @Override
        public UserDetails call() throws Exception {
            try {
                Jenkins jenkins = Jenkins.getInstance();
                UserDetails userDetails = jenkins.getSecurityRealm().loadUserByUsername(this.idOrFullName);
                if (userDetails == null) {
                    UserDetailsCache.this.existenceCache.put((Object)this.idOrFullName, (Object)Boolean.FALSE);
                    throw new NullPointerException("hudson.security.SecurityRealm should never return null. " + jenkins.getSecurityRealm() + " returned null for idOrFullName='" + this.idOrFullName + "'");
                }
                UserDetailsCache.this.existenceCache.put((Object)this.idOrFullName, (Object)Boolean.TRUE);
                return userDetails;
            }
            catch (UsernameNotFoundException e) {
                UserDetailsCache.this.existenceCache.put((Object)this.idOrFullName, (Object)Boolean.FALSE);
                throw e;
            }
            catch (DataAccessException e) {
                UserDetailsCache.this.existenceCache.invalidate((Object)this.idOrFullName);
                throw e;
            }
        }
    }
}

