/*
 * Decompiled with CFR 0.152.
 */
package jenkins.security.s2m;

import hudson.Extension;
import hudson.FilePath;
import hudson.Functions;
import hudson.Util;
import hudson.util.HttpResponses;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import jenkins.model.Jenkins;
import jenkins.security.s2m.CallableRejectionConfig;
import jenkins.security.s2m.CallableWhitelistConfig;
import jenkins.security.s2m.FilePathRuleConfig;
import org.apache.commons.io.FileUtils;
import org.jenkinsci.remoting.Role;
import org.jenkinsci.remoting.RoleSensitive;
import org.kohsuke.stapler.HttpResponse;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.StaplerProxy;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.interceptor.RequirePOST;

@Extension
public class AdminWhitelistRule
implements StaplerProxy {
    public final CallableRejectionConfig rejected;
    public final CallableWhitelistConfig whitelisted;
    public final FilePathRuleConfig filePathRules;
    private final Jenkins jenkins = Jenkins.getInstance();
    private boolean masterKillSwitch;
    private static final Logger LOGGER = Logger.getLogger(AdminWhitelistRule.class.getName());

    public AdminWhitelistRule() throws IOException, InterruptedException {
        this.placeDefaultRule(new File(this.jenkins.getRootDir(), "secrets/whitelisted-callables.d/default.conf"), this.getClass().getResourceAsStream("callable.conf"));
        this.placeDefaultRule(new File(this.jenkins.getRootDir(), "secrets/filepath-filters.d/30-default.conf"), this.transformForWindows(this.getClass().getResourceAsStream("filepath-filter.conf")));
        this.whitelisted = new CallableWhitelistConfig(new File(this.jenkins.getRootDir(), "secrets/whitelisted-callables.d/gui.conf"));
        this.rejected = new CallableRejectionConfig(new File(this.jenkins.getRootDir(), "secrets/rejected-callables.txt"), this.whitelisted);
        this.filePathRules = new FilePathRuleConfig(new File(this.jenkins.getRootDir(), "secrets/filepath-filters.d/50-gui.conf"));
        this.masterKillSwitch = this.loadMasterKillSwitchFile();
    }

    private boolean loadMasterKillSwitchFile() {
        File f = this.getMasterKillSwitchFile();
        try {
            if (!f.exists()) {
                return true;
            }
            return Boolean.parseBoolean(FileUtils.readFileToString((File)f).trim());
        }
        catch (IOException e) {
            LOGGER.log(Level.WARNING, "Failed to read " + f, e);
            return false;
        }
    }

    private File getMasterKillSwitchFile() {
        return new File(this.jenkins.getRootDir(), "secrets/slave-to-master-security-kill-switch");
    }

    private InputStream transformForWindows(InputStream src) throws IOException {
        BufferedReader r = new BufferedReader(new InputStreamReader(src));
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        try (PrintStream p = new PrintStream(out);){
            String line;
            while ((line = r.readLine()) != null) {
                if (!line.startsWith("#") && Functions.isWindows()) {
                    line = line.replace("/", "\\\\");
                }
                p.println(line);
            }
        }
        return new ByteArrayInputStream(out.toByteArray());
    }

    private void placeDefaultRule(File f, InputStream src) throws IOException, InterruptedException {
        try {
            new FilePath(f).copyFrom(src);
        }
        catch (IOException e) {
            if (!f.canWrite()) {
                return;
            }
            LOGGER.log(Level.WARNING, "Failed to generate " + f, e);
        }
    }

    public boolean isWhitelisted(RoleSensitive subject, Collection<Role> expected, Object context) {
        if (this.masterKillSwitch) {
            return true;
        }
        String name = subject.getClass().getName();
        if (this.whitelisted.contains(name)) {
            return true;
        }
        this.rejected.report(subject.getClass());
        return false;
    }

    public boolean checkFileAccess(String op, File f) {
        if (this.masterKillSwitch) {
            return true;
        }
        return this.filePathRules.checkFileAccess(op, f);
    }

    @RequirePOST
    public HttpResponse doSubmit(StaplerRequest req) throws IOException {
        this.jenkins.checkPermission(Jenkins.RUN_SCRIPTS);
        String whitelist = Util.fixNull(req.getParameter("whitelist"));
        if (!whitelist.endsWith("\n")) {
            whitelist = whitelist + "\n";
        }
        Enumeration e = req.getParameterNames();
        while (e.hasMoreElements()) {
            String name = (String)e.nextElement();
            if (!name.startsWith("class:")) continue;
            whitelist = whitelist + name.substring(6) + "\n";
        }
        this.whitelisted.set(whitelist);
        String newRules = Util.fixNull(req.getParameter("filePathRules"));
        this.filePathRules.parseTest(newRules);
        this.filePathRules.set(newRules);
        return HttpResponses.redirectToDot();
    }

    @RequirePOST
    public HttpResponse doApproveAll() throws IOException {
        StringBuilder buf = new StringBuilder();
        for (Class c : (Set)this.rejected.get()) {
            buf.append(c.getName()).append('\n');
        }
        this.whitelisted.append(buf.toString());
        return HttpResponses.ok();
    }

    @RequirePOST
    public HttpResponse doApprove(@QueryParameter String value) throws IOException {
        this.whitelisted.append(value);
        return HttpResponses.ok();
    }

    public boolean getMasterKillSwitch() {
        return this.masterKillSwitch;
    }

    public void setMasterKillSwitch(boolean state) {
        try {
            this.jenkins.checkPermission(Jenkins.RUN_SCRIPTS);
            FileUtils.writeStringToFile((File)this.getMasterKillSwitchFile(), (String)Boolean.toString(state));
            this.masterKillSwitch = this.loadMasterKillSwitchFile();
        }
        catch (IOException e) {
            LOGGER.log(Level.WARNING, "Failed to write master kill switch", e);
        }
    }

    public Object getTarget() {
        this.jenkins.checkPermission(Jenkins.RUN_SCRIPTS);
        return this;
    }
}

