/*
 * Decompiled with CFR 0.152.
 */
package jenkins.security.s2m;

import hudson.util.TextFile;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.StringReader;
import java.util.Collection;
import jenkins.model.Jenkins;
import jenkins.util.io.LinesStream;

abstract class ConfigFile<T, COL extends Collection<T>>
extends TextFile {
    protected volatile COL parsed;

    public ConfigFile(File file) {
        super(file);
    }

    protected abstract COL create();

    protected abstract COL readOnly(COL var1);

    @Deprecated
    public void load() {
        try {
            this.load2();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public synchronized void load2() throws IOException {
        COL result = this.create();
        if (this.exists()) {
            try (LinesStream stream = this.linesStream();){
                for (String line : stream) {
                    T r;
                    if (line.startsWith("#") || (r = this.parse(line)) == null) continue;
                    result.add(r);
                }
            }
        }
        this.parsed = this.readOnly(result);
    }

    public void parseTest(String candidate) {
        try {
            String line;
            BufferedReader r = new BufferedReader(new StringReader(candidate));
            while ((line = r.readLine()) != null) {
                if (line.startsWith("#")) continue;
                this.parse(line);
            }
        }
        catch (IOException e) {
            throw new IllegalArgumentException(e);
        }
    }

    protected abstract T parse(String var1);

    public synchronized void set(String newContent) throws IOException {
        Jenkins.getInstance().checkPermission(Jenkins.ADMINISTER);
        this.write(newContent);
        this.load2();
    }

    public synchronized void append(String additional) throws IOException {
        String s = this.read();
        if (!s.endsWith("\n")) {
            s = s + "\n";
        }
        s = s + additional;
        this.set(s);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public COL get() {
        if (this.parsed == null) {
            ConfigFile configFile = this;
            synchronized (configFile) {
                if (this.parsed == null) {
                    this.load();
                }
            }
        }
        return this.parsed;
    }
}

