/*
 * Decompiled with CFR 0.152.
 */
package jenkins.slaves;

import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.Extension;
import hudson.Functions;
import hudson.TcpSlaveAgentListener;
import hudson.model.Computer;
import hudson.remoting.Channel;
import hudson.slaves.ComputerLauncher;
import hudson.slaves.ComputerLauncherFilter;
import hudson.slaves.DelegatingComputerLauncher;
import hudson.slaves.JNLPLauncher;
import hudson.slaves.SlaveComputer;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import jenkins.model.Jenkins;
import jenkins.security.ChannelConfigurator;
import jenkins.slaves.JnlpAgentReceiver;
import jenkins.slaves.JnlpSlaveAgentProtocol2;
import jenkins.util.SystemProperties;
import org.jenkinsci.remoting.engine.JnlpConnectionState;
import org.jenkinsci.remoting.protocol.impl.ConnectionRefusalException;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.NoExternalUse;

@Extension
public class DefaultJnlpSlaveReceiver
extends JnlpAgentReceiver {
    @Restricted(value={NoExternalUse.class})
    public static boolean disableStrictVerification = SystemProperties.getBoolean(DefaultJnlpSlaveReceiver.class.getName() + ".disableStrictVerification");
    private static final Logger LOGGER = Logger.getLogger(DefaultJnlpSlaveReceiver.class.getName());
    private static final String COOKIE_NAME = JnlpSlaveAgentProtocol2.class.getName() + ".cookie";

    @Override
    public boolean owns(String clientName) {
        Computer computer = Jenkins.getInstance().getComputer(clientName);
        return computer != null;
    }

    private static ComputerLauncher getDelegate(ComputerLauncher launcher) {
        try {
            Method getDelegate = launcher.getClass().getMethod("getDelegate", new Class[0]);
            if (ComputerLauncher.class.isAssignableFrom(getDelegate.getReturnType())) {
                return (ComputerLauncher)getDelegate.invoke((Object)launcher, new Object[0]);
            }
        }
        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException getDelegate) {
            // empty catch block
        }
        try {
            Method getLauncher = launcher.getClass().getMethod("getLauncher", new Class[0]);
            if (ComputerLauncher.class.isAssignableFrom(getLauncher.getReturnType())) {
                return (ComputerLauncher)getLauncher.invoke((Object)launcher, new Object[0]);
            }
        }
        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException reflectiveOperationException) {
            // empty catch block
        }
        return null;
    }

    @Override
    public void afterProperties(@NonNull JnlpConnectionState event) {
        Channel ch;
        String clientName = event.getProperty("Node-Name");
        SlaveComputer computer = (SlaveComputer)Jenkins.getInstance().getComputer(clientName);
        if (computer == null) {
            event.reject(new ConnectionRefusalException(String.format("%s is not a JNLP agent", clientName)));
            return;
        }
        ComputerLauncher launcher = computer.getLauncher();
        while (!(launcher instanceof JNLPLauncher)) {
            if (launcher instanceof DelegatingComputerLauncher) {
                launcher = ((DelegatingComputerLauncher)launcher).getLauncher();
                continue;
            }
            if (launcher instanceof ComputerLauncherFilter) {
                launcher = ((ComputerLauncherFilter)launcher).getCore();
                continue;
            }
            ComputerLauncher l = DefaultJnlpSlaveReceiver.getDelegate(launcher);
            if (null != l) {
                LOGGER.log(Level.INFO, "Connecting {0} as a JNLP agent where the launcher {1} does not mark itself correctly as being a JNLP agent", new Object[]{clientName, computer.getLauncher().getClass()});
                launcher = l;
                continue;
            }
            if (disableStrictVerification) {
                LOGGER.log(Level.WARNING, "Connecting {0} as a JNLP agent where the launcher {1} does not mark itself correctly as being a JNLP agent", new Object[]{clientName, computer.getLauncher().getClass()});
                break;
            }
            LOGGER.log(Level.WARNING, "Rejecting connection to {0} from {1} as a JNLP agent as the launcher {2} does not extend JNLPLauncher or does not implement DelegatingComputerLauncher with a delegation chain leading to a JNLPLauncher. Set system property jenkins.slaves.DefaultJnlpSlaveReceiver.disableStrictVerification=true to allowconnections until the plugin has been fixed.", new Object[]{clientName, event.getSocket().getRemoteSocketAddress(), computer.getLauncher().getClass()});
            event.reject(new ConnectionRefusalException(String.format("%s is not a JNLP agent", clientName)));
            return;
        }
        if ((ch = computer.getChannel()) != null) {
            String cookie = event.getProperty("Cookie");
            if (cookie != null && cookie.equals(ch.getProperty(COOKIE_NAME))) {
                LOGGER.log(Level.INFO, "Disconnecting {0} as we are reconnected from the current peer", clientName);
                try {
                    computer.disconnect(new TcpSlaveAgentListener.ConnectionFromCurrentPeer()).get(15L, TimeUnit.SECONDS);
                }
                catch (InterruptedException | ExecutionException | TimeoutException e) {
                    event.reject(new ConnectionRefusalException("Failed to disconnect the current client", e));
                    return;
                }
            } else {
                event.reject(new ConnectionRefusalException(String.format("%s is already connected to this master. Rejecting this connection.", clientName)));
                return;
            }
        }
        event.approve();
        event.setStash(new State(computer));
    }

    @Override
    public void beforeChannel(@NonNull JnlpConnectionState event) {
        State state = event.getStash(State.class);
        SlaveComputer computer = state.getNode();
        OutputStream log = computer.openLogFile();
        state.setLog(log);
        PrintWriter logw = new PrintWriter(log, true);
        logw.println("JNLP agent connected from " + event.getSocket().getInetAddress());
        for (ChannelConfigurator cc : ChannelConfigurator.all()) {
            cc.onChannelBuilding(event.getChannelBuilder(), computer);
        }
        event.getChannelBuilder().withHeaderStream(log);
        String cookie = event.getProperty("Cookie");
        if (cookie != null) {
            event.getChannelBuilder().withProperty(COOKIE_NAME, cookie);
        }
    }

    @Override
    public void afterChannel(@NonNull JnlpConnectionState event) {
        State state = event.getStash(State.class);
        SlaveComputer computer = state.getNode();
        try {
            computer.setChannel(event.getChannel(), state.getLog(), null);
        }
        catch (IOException | InterruptedException e) {
            PrintWriter logw = new PrintWriter(state.getLog(), true);
            Functions.printStackTrace((Throwable)e, logw);
            try {
                event.getChannel().close();
            }
            catch (IOException x) {
                LOGGER.log(Level.WARNING, null, x);
            }
        }
    }

    @Override
    public void channelClosed(@NonNull JnlpConnectionState event) {
        String nodeName = event.getProperty("Node-Name");
        IOException cause = event.getCloseCause();
        if (cause != null) {
            LOGGER.log(Level.WARNING, Thread.currentThread().getName() + " for " + nodeName + " terminated", cause);
        }
    }

    private static class State
    implements JnlpConnectionState.ListenerState {
        @Nonnull
        private final SlaveComputer node;
        @CheckForNull
        private OutputStream log;

        public State(@Nonnull SlaveComputer node) {
            this.node = node;
        }

        @Nonnull
        public SlaveComputer getNode() {
            return this.node;
        }

        @CheckForNull
        public OutputStream getLog() {
            return this.log;
        }

        public void setLog(@Nonnull OutputStream log) {
            this.log = log;
        }
    }
}

