/*
 * Decompiled with CFR 0.152.
 */
package jenkins.slaves;

import hudson.Extension;
import hudson.model.AdministrativeMonitor;
import java.util.ArrayList;
import java.util.Set;
import javax.annotation.CheckForNull;
import jenkins.AgentProtocol;
import jenkins.model.Jenkins;
import jenkins.slaves.Messages;
import org.apache.commons.lang.StringUtils;
import org.jenkinsci.Symbol;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.NoExternalUse;

@Extension
@Symbol(value={"deprecatedAgentProtocol"})
@Restricted(value={NoExternalUse.class})
public class DeprecatedAgentProtocolMonitor
extends AdministrativeMonitor {
    @Override
    public String getDisplayName() {
        return Messages.DeprecatedAgentProtocolMonitor_displayName();
    }

    @Override
    public boolean isActivated() {
        Set<String> agentProtocols = Jenkins.getInstance().getAgentProtocols();
        for (String name : agentProtocols) {
            AgentProtocol pr = AgentProtocol.of(name);
            if (pr == null || !pr.isDeprecated()) continue;
            return true;
        }
        return false;
    }

    @Restricted(value={NoExternalUse.class})
    public String getDeprecatedProtocols() {
        String res = DeprecatedAgentProtocolMonitor.getDeprecatedProtocolsString();
        return res != null ? res : "N/A";
    }

    @CheckForNull
    public static String getDeprecatedProtocolsString() {
        ArrayList<String> deprecatedProtocols = new ArrayList<String>();
        Set<String> agentProtocols = Jenkins.getInstance().getAgentProtocols();
        for (String name : agentProtocols) {
            AgentProtocol pr = AgentProtocol.of(name);
            if (pr == null || !pr.isDeprecated()) continue;
            deprecatedProtocols.add(name);
        }
        if (deprecatedProtocols.isEmpty()) {
            return null;
        }
        return StringUtils.join(deprecatedProtocols, (char)',');
    }
}

