/*
 * Decompiled with CFR 0.152.
 */
package jenkins.slaves;

import hudson.Extension;
import hudson.ExtensionList;
import hudson.Util;
import hudson.model.Computer;
import java.io.IOException;
import java.net.Socket;
import java.util.Collections;
import java.util.Map;
import java.util.logging.Logger;
import javax.inject.Inject;
import jenkins.AgentProtocol;
import jenkins.model.Jenkins;
import jenkins.security.HMACConfidentialKey;
import jenkins.slaves.JnlpAgentReceiver;
import jenkins.slaves.Messages;
import jenkins.slaves.NioChannelSelector;
import org.jenkinsci.Symbol;
import org.jenkinsci.remoting.engine.JnlpProtocol1Handler;

@Extension
@Symbol(value={"jnlp"})
public class JnlpSlaveAgentProtocol
extends AgentProtocol {
    private static final Logger LOGGER = Logger.getLogger(JnlpSlaveAgentProtocol.class.getName());
    public static final HMACConfidentialKey SLAVE_SECRET = new HMACConfidentialKey(JnlpSlaveAgentProtocol.class, "secret");
    private NioChannelSelector hub;
    private JnlpProtocol1Handler handler;
    private static final boolean OPT_IN;

    @Inject
    public void setHub(NioChannelSelector hub) {
        this.hub = hub;
        this.handler = new JnlpProtocol1Handler(JnlpAgentReceiver.DATABASE, Computer.threadPoolForRemoting, hub.getHub(), true);
    }

    @Override
    public boolean isOptIn() {
        return OPT_IN;
    }

    @Override
    public boolean isDeprecated() {
        return true;
    }

    @Override
    public String getName() {
        return this.handler.isEnabled() ? this.handler.getName() : null;
    }

    @Override
    public String getDisplayName() {
        return Messages.JnlpSlaveAgentProtocol_displayName();
    }

    @Override
    public void handle(Socket socket) throws IOException, InterruptedException {
        this.handler.handle(socket, (Map)Collections.singletonMap("Cookie", JnlpAgentReceiver.generateCookie()), ExtensionList.lookup(JnlpAgentReceiver.class));
    }

    static {
        byte hash = Util.fromHexString(Jenkins.getInstance().getLegacyInstanceId())[0];
        OPT_IN = hash % 10 == 0;
    }
}

