/*
 * Decompiled with CFR 0.152.
 */
package jenkins.slaves;

import hudson.util.VersionNumber;
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.Nonnull;

public class RemotingVersionInfo {
    private static final Logger LOGGER = Logger.getLogger(RemotingVersionInfo.class.getName());
    private static final String RESOURCE_NAME = "remoting-info.properties";
    @Nonnull
    private static VersionNumber EMBEDDED_VERSION;
    @Nonnull
    private static VersionNumber MINIMUM_SUPPORTED_VERSION;

    private RemotingVersionInfo() {
    }

    @Nonnull
    private static VersionNumber extractVersion(@Nonnull Properties props, @Nonnull String propertyName) throws ExceptionInInitializerError {
        String prop = props.getProperty(propertyName);
        if (prop == null) {
            throw new ExceptionInInitializerError(String.format("Property %s is not defined in %s", propertyName, RESOURCE_NAME));
        }
        if (prop.contains("${")) {
            throw new ExceptionInInitializerError(String.format("Property %s in %s has unresolved variable(s). Raw value: %s", propertyName, RESOURCE_NAME, prop));
        }
        try {
            return new VersionNumber(prop);
        }
        catch (RuntimeException ex) {
            throw new ExceptionInInitializerError(new IOException(String.format("Failed to parse version for for property %s in %s. Raw Value: %s", propertyName, RESOURCE_NAME, prop), ex));
        }
    }

    @Nonnull
    public static VersionNumber getEmbeddedVersion() {
        return EMBEDDED_VERSION;
    }

    @Nonnull
    public static VersionNumber getMinimumSupportedVersion() {
        return MINIMUM_SUPPORTED_VERSION;
    }

    static {
        Properties props = new Properties();
        try (InputStream is = RemotingVersionInfo.class.getResourceAsStream(RESOURCE_NAME);){
            if (is != null) {
                props.load(is);
            }
        }
        catch (IOException e) {
            LOGGER.log(Level.WARNING, "Failed to load Remoting Info from remoting-info.properties", e);
        }
        EMBEDDED_VERSION = RemotingVersionInfo.extractVersion(props, "remoting.embedded.version");
        MINIMUM_SUPPORTED_VERSION = RemotingVersionInfo.extractVersion(props, "remoting.minimum.supported.version");
    }
}

