/*
 * Decompiled with CFR 0.152.
 */
package jenkins.slaves.restarter;

import hudson.Extension;
import hudson.Functions;
import hudson.model.Computer;
import hudson.model.TaskListener;
import hudson.remoting.Engine;
import hudson.remoting.EngineListener;
import hudson.remoting.EngineListenerAdapter;
import hudson.remoting.VirtualChannel;
import hudson.slaves.ComputerListener;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.logging.Level;
import java.util.logging.Logger;
import jenkins.model.Jenkins;
import jenkins.security.MasterToSlaveCallable;
import jenkins.slaves.restarter.SlaveRestarter;

@Extension
public class JnlpSlaveRestarterInstaller
extends ComputerListener
implements Serializable {
    private static final Logger LOGGER = Logger.getLogger(JnlpSlaveRestarterInstaller.class.getName());
    private static final long serialVersionUID = 1L;

    @Override
    public void onOnline(Computer c, TaskListener listener) throws IOException, InterruptedException {
        Jenkins.MasterComputer.threadPoolForRemoting.submit(new Install(c, listener));
    }

    private static void install(Computer c, TaskListener listener) {
        try {
            ArrayList<SlaveRestarter> restarters = new ArrayList<SlaveRestarter>(SlaveRestarter.all());
            VirtualChannel ch = c.getChannel();
            if (ch == null) {
                return;
            }
            List<SlaveRestarter> effective = ch.call(new FindEffectiveRestarters(restarters));
            LOGGER.log(Level.FINE, "Effective SlaveRestarter on {0}: {1}", new Object[]{c.getName(), effective});
        }
        catch (Throwable e) {
            Functions.printStackTrace(e, listener.error("Failed to install restarter"));
        }
    }

    private static class FindEffectiveRestarters
    extends MasterToSlaveCallable<List<SlaveRestarter>, IOException> {
        private final List<SlaveRestarter> restarters;

        FindEffectiveRestarters(List<SlaveRestarter> restarters) {
            this.restarters = restarters;
        }

        @Override
        public List<SlaveRestarter> call() throws IOException {
            Engine e = Engine.current();
            if (e == null) {
                return null;
            }
            try {
                Engine.class.getMethod("addListener", EngineListener.class);
            }
            catch (NoSuchMethodException _) {
                return null;
            }
            Iterator<SlaveRestarter> itr = this.restarters.iterator();
            while (itr.hasNext()) {
                SlaveRestarter r = itr.next();
                if (r.canWork()) continue;
                itr.remove();
            }
            e.addListener(new EngineListenerAdapter(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void onReconnect() {
                    try {
                        for (SlaveRestarter r : restarters) {
                            try {
                                LOGGER.info("Restarting agent via " + r);
                                r.restart();
                            }
                            catch (Exception x) {
                                LOGGER.log(Level.SEVERE, "Failed to restart agent with " + r, x);
                            }
                        }
                    }
                    finally {
                        restarters.clear();
                    }
                }
            });
            return this.restarters;
        }
    }

    private static class Install
    implements Callable<Void> {
        private final Computer c;
        private final TaskListener listener;

        Install(Computer c, TaskListener listener) {
            this.c = c;
            this.listener = listener;
        }

        @Override
        public Void call() throws Exception {
            JnlpSlaveRestarterInstaller.install(this.c, this.listener);
            return null;
        }
    }
}

