/*
 * Decompiled with CFR 0.152.
 */
package jenkins.slaves.restarter;

import hudson.Extension;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.logging.Level;
import java.util.logging.Logger;
import jenkins.slaves.restarter.SlaveRestarter;
import org.apache.commons.io.IOUtils;

@Extension
public class WinswSlaveRestarter
extends SlaveRestarter {
    private transient String exe;
    private static final Logger LOGGER = Logger.getLogger(WinswSlaveRestarter.class.getName());
    private static final long serialVersionUID = 1L;

    @Override
    public boolean canWork() {
        try {
            this.exe = System.getenv("WINSW_EXECUTABLE");
            if (this.exe == null) {
                return false;
            }
            return this.exec("status") == 0;
        }
        catch (InterruptedException e) {
            LOGGER.log(Level.FINE, this.getClass() + " unsuitable", e);
            return false;
        }
        catch (IOException e) {
            LOGGER.log(Level.FINE, this.getClass() + " unsuitable", e);
            return false;
        }
    }

    private int exec(String cmd) throws InterruptedException, IOException {
        ProcessBuilder pb = new ProcessBuilder(this.exe, cmd);
        pb.redirectErrorStream(true);
        Process p = pb.start();
        p.getOutputStream().close();
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        IOUtils.copy((InputStream)p.getInputStream(), (OutputStream)baos);
        int r = p.waitFor();
        if (r != 0) {
            LOGGER.info(this.exe + " cmd: output:\n" + baos);
        }
        return r;
    }

    @Override
    public void restart() throws Exception {
        int r = this.exec("restart!");
        throw new IOException("Restart failure. '" + this.exe + " restart' completed with " + r + " but I'm still alive!  See https://jenkins.io/redirect/troubleshooting/windows-agent-restart for a possible explanation and solution");
    }
}

