/*
 * Decompiled with CFR 0.152.
 */
package jenkins.tasks;

import hudson.EnvVars;
import hudson.FilePath;
import hudson.Launcher;
import hudson.console.ConsoleLogFilter;
import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.model.Action;
import hudson.model.BuildListener;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.tasks.BuildWrapper;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;

public abstract class SimpleBuildWrapper
extends BuildWrapper {
    public abstract void setUp(Context var1, Run<?, ?> var2, FilePath var3, Launcher var4, TaskListener var5, EnvVars var6) throws IOException, InterruptedException;

    protected boolean runPreCheckout() {
        return false;
    }

    @Override
    public final BuildWrapper.Environment setUp(AbstractBuild build, Launcher launcher, BuildListener listener) throws IOException, InterruptedException {
        if (this.runPreCheckout()) {
            return new BuildWrapper.Environment(){};
        }
        Context c = new Context();
        this.setUp(c, build, build.getWorkspace(), launcher, listener, build.getEnvironment(listener));
        return new EnvironmentWrapper(c, launcher);
    }

    @Override
    public final void preCheckout(AbstractBuild build, Launcher launcher, BuildListener listener) throws IOException, InterruptedException {
        if (this.runPreCheckout()) {
            Context c = new Context();
            this.setUp(c, build, build.getWorkspace(), launcher, listener, build.getEnvironment(listener));
            build.getEnvironments().add(new EnvironmentWrapper(c, launcher));
        }
    }

    @CheckForNull
    public ConsoleLogFilter createLoggerDecorator(@Nonnull Run<?, ?> build) {
        return null;
    }

    @Override
    public final OutputStream decorateLogger(AbstractBuild build, OutputStream logger) throws IOException, InterruptedException, Run.RunnerAbortedException {
        ConsoleLogFilter filter = this.createLoggerDecorator(build);
        return filter != null ? filter.decorateLogger(build, logger) : logger;
    }

    @Override
    public Launcher decorateLauncher(AbstractBuild build, Launcher launcher, BuildListener listener) throws IOException, InterruptedException, Run.RunnerAbortedException {
        return super.decorateLauncher(build, launcher, listener);
    }

    @Override
    public void makeBuildVariables(AbstractBuild build, Map<String, String> variables) {
        super.makeBuildVariables(build, variables);
    }

    @Override
    public void makeSensitiveBuildVariables(AbstractBuild build, Set<String> sensitiveVariables) {
        super.makeSensitiveBuildVariables(build, sensitiveVariables);
    }

    @Override
    public final Collection<? extends Action> getProjectActions(AbstractProject job) {
        return Collections.emptySet();
    }

    private class EnvironmentWrapper
    extends BuildWrapper.Environment {
        private final Context c;
        private final Launcher launcher;

        EnvironmentWrapper(Context c, Launcher launcher) {
            super(SimpleBuildWrapper.this);
            this.c = c;
            this.launcher = launcher;
        }

        @Override
        public void buildEnvVars(Map<String, String> env) {
            if (env instanceof EnvVars) {
                ((EnvVars)env).overrideAll(this.c.env);
            } else {
                env.putAll(this.c.env);
            }
        }

        @Override
        public boolean tearDown(AbstractBuild build, BuildListener listener) throws IOException, InterruptedException {
            if (this.c.disposer != null) {
                this.c.disposer.tearDown(build, build.getWorkspace(), this.launcher, listener);
            }
            return true;
        }
    }

    public static abstract class Disposer
    implements Serializable {
        public abstract void tearDown(Run<?, ?> var1, FilePath var2, Launcher var3, TaskListener var4) throws IOException, InterruptedException;
    }

    public static final class Context {
        private Disposer disposer;
        private final Map<String, String> env = new HashMap<String, String>();

        @Nonnull
        public Map<String, String> getEnv() {
            return this.env;
        }

        public void env(String key, String value) {
            if (this.env.containsKey(key)) {
                throw new IllegalStateException("just one binding for " + key);
            }
            this.env.put(key, value);
        }

        @CheckForNull
        public Disposer getDisposer() {
            return this.disposer;
        }

        public void setDisposer(@Nonnull Disposer disposer) {
            if (this.disposer != null) {
                throw new IllegalStateException("just one disposer");
            }
            this.disposer = disposer;
        }
    }
}

