/*
 * Decompiled with CFR 0.152.
 */
package jenkins.util;

import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Field;
import java.net.URL;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Vector;
import jenkins.util.AntClassLoader;

public class AntWithFindResourceClassLoader
extends AntClassLoader
implements Closeable {
    private final Vector pathComponents;

    public AntWithFindResourceClassLoader(ClassLoader parent, boolean parentFirst) {
        super(parent, parentFirst);
        try {
            Field $pathComponents = AntClassLoader.class.getDeclaredField("pathComponents");
            $pathComponents.setAccessible(true);
            this.pathComponents = (Vector)$pathComponents.get(this);
        }
        catch (IllegalAccessException | NoSuchFieldException e) {
            throw new Error(e);
        }
    }

    public void addPathFiles(Collection<File> paths) throws IOException {
        for (File f : paths) {
            this.addPathFile(f);
        }
    }

    @Override
    public void close() throws IOException {
        this.cleanup();
    }

    @Override
    protected URL findResource(String name) {
        URL url = null;
        Enumeration e = this.pathComponents.elements();
        while (e.hasMoreElements() && url == null) {
            File pathComponent = (File)e.nextElement();
            url = this.getResourceURL(pathComponent, name);
            if (url == null) continue;
            this.log("Resource " + name + " loaded from ant loader", 4);
        }
        return url;
    }
}

