/*
 * Decompiled with CFR 0.152.
 */
package jenkins.util;

import com.google.common.util.concurrent.SettableFuture;
import hudson.remoting.AtmostOneThreadExecutor;
import hudson.security.ACL;
import hudson.util.DaemonThreadFactory;
import hudson.util.NamingThreadFactory;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.logging.Level;
import java.util.logging.Logger;
import jenkins.security.ImpersonatingExecutorService;

public class AtmostOneTaskExecutor<V> {
    private static final Logger LOGGER = Logger.getLogger(AtmostOneTaskExecutor.class.getName());
    private final ExecutorService base;
    private final Callable<V> task;
    private SettableFuture<V> pending;
    private SettableFuture<V> inprogress;

    public AtmostOneTaskExecutor(ExecutorService base, Callable<V> task) {
        this.base = base;
        this.task = task;
    }

    public AtmostOneTaskExecutor(Callable<V> task) {
        this((ExecutorService)((Object)new ImpersonatingExecutorService(new AtmostOneThreadExecutor(new NamingThreadFactory(new DaemonThreadFactory(), String.format("AtmostOneTaskExecutor[%s]", task))), ACL.SYSTEM)), task);
    }

    public synchronized Future<V> submit() {
        if (this.pending == null) {
            this.pending = SettableFuture.create();
            this.maybeRun();
        }
        return this.pending;
    }

    private synchronized void maybeRun() {
        if (this.inprogress == null && this.pending != null) {
            this.base.submit(new Callable<Void>(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public Void call() throws Exception {
                    AtmostOneTaskExecutor atmostOneTaskExecutor = AtmostOneTaskExecutor.this;
                    synchronized (atmostOneTaskExecutor) {
                        AtmostOneTaskExecutor.this.inprogress = AtmostOneTaskExecutor.this.pending;
                        AtmostOneTaskExecutor.this.pending = null;
                    }
                    try {
                        AtmostOneTaskExecutor.this.inprogress.set(AtmostOneTaskExecutor.this.task.call());
                    }
                    catch (Throwable t) {
                        LOGGER.log(Level.WARNING, null, t);
                        AtmostOneTaskExecutor.this.inprogress.setException(t);
                    }
                    finally {
                        atmostOneTaskExecutor = AtmostOneTaskExecutor.this;
                        synchronized (atmostOneTaskExecutor) {
                            AtmostOneTaskExecutor.this.inprogress = null;
                            AtmostOneTaskExecutor.this.maybeRun();
                        }
                    }
                    return null;
                }
            });
        }
    }
}

