/*
 * Decompiled with CFR 0.152.
 */
package jenkins.util;

import com.google.common.util.concurrent.ForwardingExecutorService;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

public abstract class InterceptingExecutorService
extends ForwardingExecutorService {
    private final ExecutorService base;

    public InterceptingExecutorService(ExecutorService base) {
        this.base = base;
    }

    protected abstract Runnable wrap(Runnable var1);

    protected abstract <V> Callable<V> wrap(Callable<V> var1);

    protected ExecutorService delegate() {
        return this.base;
    }

    public <T> Future<T> submit(Callable<T> task) {
        return super.submit(this.wrap(task));
    }

    public <T> Future<T> submit(Runnable task, T result) {
        return super.submit(this.wrap(task), result);
    }

    public Future<?> submit(Runnable task) {
        return super.submit(this.wrap(task));
    }

    public <T> List<Future<T>> invokeAll(Collection<? extends Callable<T>> tasks) throws InterruptedException {
        return super.invokeAll(this.wrap(tasks));
    }

    public <T> List<Future<T>> invokeAll(Collection<? extends Callable<T>> tasks, long timeout, TimeUnit unit) throws InterruptedException {
        return super.invokeAll(this.wrap(tasks), timeout, unit);
    }

    public <T> T invokeAny(Collection<? extends Callable<T>> tasks) throws InterruptedException, ExecutionException {
        return (T)super.invokeAny(this.wrap(tasks));
    }

    public <T> T invokeAny(Collection<? extends Callable<T>> tasks, long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
        return (T)super.invokeAny(this.wrap(tasks), timeout, unit);
    }

    public void execute(Runnable command) {
        super.execute(this.wrap(command));
    }

    private <T> Collection<Callable<T>> wrap(Collection<? extends Callable<T>> callables) {
        ArrayList<Callable<T>> r = new ArrayList<Callable<T>>();
        for (Callable<T> c : callables) {
            r.add(this.wrap(c));
        }
        return r;
    }
}

