/*
 * Decompiled with CFR 0.152.
 */
package jenkins.util;

import hudson.FilePath;
import hudson.Util;
import hudson.os.PosixException;
import hudson.remoting.Callable;
import hudson.remoting.VirtualChannel;
import hudson.util.DirScanner;
import hudson.util.FileVisitor;
import hudson.util.IOUtils;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.net.URI;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.InvalidPathException;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import jenkins.MasterToSlaveFileCallable;
import jenkins.security.MasterToSlaveCallable;
import org.apache.tools.ant.DirectoryScanner;
import org.apache.tools.ant.types.selectors.TokenizedPath;
import org.apache.tools.ant.types.selectors.TokenizedPattern;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.Beta;

public abstract class VirtualFile
implements Comparable<VirtualFile>,
Serializable {
    @Nonnull
    public abstract String getName();

    @Nonnull
    public abstract URI toURI();

    public abstract VirtualFile getParent();

    public abstract boolean isDirectory() throws IOException;

    public abstract boolean isFile() throws IOException;

    @Restricted(value={Beta.class})
    @CheckForNull
    public String readLink() throws IOException {
        return null;
    }

    public abstract boolean exists() throws IOException;

    @Nonnull
    public abstract VirtualFile[] list() throws IOException;

    @Deprecated
    @Nonnull
    public String[] list(String glob) throws IOException {
        return this.list(glob.replace('\\', '/'), null, true).toArray(new String[0]);
    }

    @Restricted(value={Beta.class})
    @Nonnull
    public Collection<String> list(@Nonnull String includes, @CheckForNull String excludes, boolean useDefaultExcludes) throws IOException {
        Collection<String> r = this.run(new CollectFiles(this));
        List<TokenizedPattern> includePatterns = this.patterns(includes);
        List<TokenizedPattern> excludePatterns = this.patterns(excludes);
        if (useDefaultExcludes) {
            for (String patt : DirectoryScanner.getDefaultExcludes()) {
                excludePatterns.add(new TokenizedPattern(patt.replace('/', File.separatorChar)));
            }
        }
        return r.stream().filter(p -> {
            TokenizedPath path = new TokenizedPath(p.replace('/', File.separatorChar));
            return includePatterns.stream().anyMatch(patt -> patt.matchPath(path, true)) && !excludePatterns.stream().anyMatch(patt -> patt.matchPath(path, true));
        }).collect(Collectors.toSet());
    }

    private List<TokenizedPattern> patterns(String patts) {
        ArrayList<TokenizedPattern> r = new ArrayList<TokenizedPattern>();
        if (patts != null) {
            for (String patt : patts.split(",")) {
                if (patt.endsWith("/")) {
                    patt = patt + "**";
                }
                r.add(new TokenizedPattern(patt.replace('/', File.separatorChar)));
            }
        }
        return r;
    }

    @Nonnull
    public abstract VirtualFile child(@Nonnull String var1);

    public abstract long length() throws IOException;

    public abstract long lastModified() throws IOException;

    @Restricted(value={Beta.class})
    public int mode() throws IOException {
        return -1;
    }

    public abstract boolean canRead() throws IOException;

    public abstract InputStream open() throws IOException;

    @Override
    public final int compareTo(VirtualFile o) {
        return this.getName().compareToIgnoreCase(o.getName());
    }

    public final boolean equals(Object obj) {
        return obj instanceof VirtualFile && this.toURI().equals(((VirtualFile)obj).toURI());
    }

    public final int hashCode() {
        return this.toURI().hashCode();
    }

    public final String toString() {
        return this.toURI().toString();
    }

    public <V> V run(Callable<V, IOException> callable) throws IOException {
        return callable.call();
    }

    @Restricted(value={Beta.class})
    @CheckForNull
    public URL toExternalURL() throws IOException {
        return null;
    }

    public static VirtualFile forFile(File f) {
        return new FileVF(f, f);
    }

    public static VirtualFile forFilePath(FilePath f) {
        return new FilePathVF(f);
    }

    private static final class Readable
    extends MasterToSlaveFileCallable<Boolean> {
        private Readable() {
        }

        @Override
        public Boolean invoke(File f, VirtualChannel channel) throws IOException, InterruptedException {
            return f.canRead();
        }
    }

    private static final class Scanner
    extends MasterToSlaveFileCallable<List<String>> {
        private final String includes;
        private final String excludes;
        private final boolean useDefaultExcludes;

        Scanner(String includes, String excludes, boolean useDefaultExcludes) {
            this.includes = includes;
            this.excludes = excludes;
            this.useDefaultExcludes = useDefaultExcludes;
        }

        @Override
        public List<String> invoke(File f, VirtualChannel channel) throws IOException {
            if (this.includes.isEmpty()) {
                return Collections.emptyList();
            }
            final ArrayList<String> paths = new ArrayList<String>();
            new DirScanner.Glob(this.includes, this.excludes, this.useDefaultExcludes).scan(f, new FileVisitor(){

                @Override
                public void visit(File f, String relativePath) throws IOException {
                    paths.add(relativePath.replace('\\', '/'));
                }
            });
            return paths;
        }
    }

    private static final class FilePathVF
    extends VirtualFile {
        private final FilePath f;

        FilePathVF(FilePath f) {
            this.f = f;
        }

        @Override
        public String getName() {
            return this.f.getName();
        }

        @Override
        public URI toURI() {
            try {
                return this.f.toURI();
            }
            catch (Exception x) {
                return URI.create(this.f.getRemote());
            }
        }

        @Override
        public VirtualFile getParent() {
            return this.f.getParent().toVirtualFile();
        }

        @Override
        public boolean isDirectory() throws IOException {
            try {
                return this.f.isDirectory();
            }
            catch (InterruptedException x) {
                throw new IOException(x);
            }
        }

        @Override
        public boolean isFile() throws IOException {
            return this.exists() && !this.isDirectory();
        }

        @Override
        public boolean exists() throws IOException {
            try {
                return this.f.exists();
            }
            catch (InterruptedException x) {
                throw new IOException(x);
            }
        }

        @Override
        public String readLink() throws IOException {
            try {
                return this.f.readLink();
            }
            catch (InterruptedException x) {
                throw new IOException(x);
            }
        }

        @Override
        public VirtualFile[] list() throws IOException {
            try {
                List<FilePath> kids = this.f.list();
                VirtualFile[] vfs = new VirtualFile[kids.size()];
                for (int i = 0; i < vfs.length; ++i) {
                    vfs[i] = FilePathVF.forFilePath(kids.get(i));
                }
                return vfs;
            }
            catch (InterruptedException x) {
                throw new IOException(x);
            }
        }

        @Override
        public Collection<String> list(String includes, String excludes, boolean useDefaultExcludes) throws IOException {
            try {
                return this.f.act(new Scanner(includes, excludes, useDefaultExcludes));
            }
            catch (InterruptedException x) {
                throw new IOException(x);
            }
        }

        @Override
        public VirtualFile child(String name) {
            return FilePathVF.forFilePath(this.f.child(name));
        }

        @Override
        public long length() throws IOException {
            try {
                return this.f.length();
            }
            catch (InterruptedException x) {
                throw new IOException(x);
            }
        }

        @Override
        public int mode() throws IOException {
            try {
                return this.f.mode();
            }
            catch (PosixException | InterruptedException x) {
                throw new IOException(x);
            }
        }

        @Override
        public long lastModified() throws IOException {
            try {
                return this.f.lastModified();
            }
            catch (InterruptedException x) {
                throw new IOException(x);
            }
        }

        @Override
        public boolean canRead() throws IOException {
            try {
                return this.f.act(new Readable());
            }
            catch (InterruptedException x) {
                throw new IOException(x);
            }
        }

        @Override
        public InputStream open() throws IOException {
            try {
                return this.f.read();
            }
            catch (InterruptedException x) {
                throw new IOException(x);
            }
        }

        @Override
        public <V> V run(Callable<V, IOException> callable) throws IOException {
            try {
                return this.f.act(callable);
            }
            catch (InterruptedException x) {
                throw new IOException(x);
            }
        }
    }

    private static final class FileVF
    extends VirtualFile {
        private final File f;
        private final File root;

        FileVF(File f, File root) {
            this.f = f;
            this.root = root;
        }

        @Override
        public String getName() {
            return this.f.getName();
        }

        @Override
        public URI toURI() {
            return this.f.toURI();
        }

        @Override
        public VirtualFile getParent() {
            return new FileVF(this.f.getParentFile(), this.root);
        }

        @Override
        public boolean isDirectory() throws IOException {
            if (this.isIllegalSymlink()) {
                return false;
            }
            return this.f.isDirectory();
        }

        @Override
        public boolean isFile() throws IOException {
            if (this.isIllegalSymlink()) {
                return false;
            }
            return this.f.isFile();
        }

        @Override
        public boolean exists() throws IOException {
            if (this.isIllegalSymlink()) {
                return false;
            }
            return this.f.exists();
        }

        @Override
        public String readLink() throws IOException {
            if (this.isIllegalSymlink()) {
                return null;
            }
            return Util.resolveSymlink(this.f);
        }

        @Override
        public VirtualFile[] list() throws IOException {
            if (this.isIllegalSymlink()) {
                return new VirtualFile[0];
            }
            File[] kids = this.f.listFiles();
            if (kids == null) {
                return new VirtualFile[0];
            }
            VirtualFile[] vfs = new VirtualFile[kids.length];
            for (int i = 0; i < kids.length; ++i) {
                vfs[i] = new FileVF(kids[i], this.root);
            }
            return vfs;
        }

        @Override
        public Collection<String> list(String includes, String excludes, boolean useDefaultExcludes) throws IOException {
            if (this.isIllegalSymlink()) {
                return Collections.emptySet();
            }
            return new Scanner(includes, excludes, useDefaultExcludes).invoke(this.f, null);
        }

        @Override
        public VirtualFile child(String name) {
            return new FileVF(new File(this.f, name), this.root);
        }

        @Override
        public long length() throws IOException {
            if (this.isIllegalSymlink()) {
                return 0L;
            }
            return this.f.length();
        }

        @Override
        public int mode() throws IOException {
            if (this.isIllegalSymlink()) {
                return -1;
            }
            return IOUtils.mode(this.f);
        }

        @Override
        public long lastModified() throws IOException {
            if (this.isIllegalSymlink()) {
                return 0L;
            }
            return this.f.lastModified();
        }

        @Override
        public boolean canRead() throws IOException {
            if (this.isIllegalSymlink()) {
                return false;
            }
            return this.f.canRead();
        }

        @Override
        public InputStream open() throws IOException {
            if (this.isIllegalSymlink()) {
                throw new FileNotFoundException(this.f.getPath());
            }
            try {
                return Files.newInputStream(this.f.toPath(), new OpenOption[0]);
            }
            catch (InvalidPathException e) {
                throw new IOException(e);
            }
        }

        private boolean isIllegalSymlink() {
            try {
                String myPath = this.f.toPath().toRealPath(new LinkOption[0]).toString();
                String rootPath = this.root.toPath().toRealPath(new LinkOption[0]).toString();
                if (!myPath.equals(rootPath) && !myPath.startsWith(rootPath + File.separatorChar)) {
                    return true;
                }
            }
            catch (IOException x) {
                Logger.getLogger(VirtualFile.class.getName()).log(Level.FINE, "could not determine symlink status of " + this.f, x);
            }
            catch (InvalidPathException x2) {
                Logger.getLogger(VirtualFile.class.getName()).log(Level.FINE, "Could not convert " + this.f + " to path", x2);
            }
            return false;
        }
    }

    private static final class CollectFiles
    extends MasterToSlaveCallable<Collection<String>, IOException> {
        private static final long serialVersionUID = 1L;
        private final VirtualFile root;

        CollectFiles(VirtualFile root) {
            this.root = root;
        }

        @Override
        public Collection<String> call() throws IOException {
            ArrayList<String> r = new ArrayList<String>();
            CollectFiles.collectFiles(this.root, r, "");
            return r;
        }

        private static void collectFiles(VirtualFile d, Collection<String> names, String prefix) throws IOException {
            for (VirtualFile child : d.list()) {
                if (child.isFile()) {
                    names.add(prefix + child.getName());
                    continue;
                }
                if (!child.isDirectory()) continue;
                CollectFiles.collectFiles(child, names, prefix + child.getName() + "/");
            }
        }
    }
}

