/*
 * Decompiled with CFR 0.152.
 */
package jenkins.widgets;

import com.google.common.collect.Iterables;
import hudson.model.AbstractBuild;
import hudson.model.Job;
import hudson.model.ParameterValue;
import hudson.model.ParametersAction;
import hudson.model.Queue;
import hudson.model.Run;
import hudson.search.UserSearchProperty;
import hudson.util.Iterators;
import hudson.widgets.HistoryWidget;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import jenkins.widgets.HistoryPageEntry;

public class HistoryPageFilter<T> {
    private final int maxEntries;
    private Long newerThan;
    private Long olderThan;
    private String searchString;
    public final List<HistoryPageEntry<Queue.Item>> queueItems = new ArrayList<HistoryPageEntry<Queue.Item>>();
    public final List<HistoryPageEntry<Run>> runs = new ArrayList<HistoryPageEntry<Run>>();
    public boolean hasUpPage = false;
    public boolean hasDownPage = false;
    public long nextBuildNumber;
    public HistoryWidget widget;
    public long newestOnPage = Long.MIN_VALUE;
    public long oldestOnPage = Long.MAX_VALUE;

    public HistoryPageFilter(int maxEntries) {
        this.maxEntries = maxEntries;
    }

    public void setNewerThan(Long newerThan) {
        if (this.olderThan != null) {
            throw new UnsupportedOperationException("Cannot set 'newerThan'. 'olderThan' already set.");
        }
        this.newerThan = newerThan;
    }

    public void setOlderThan(Long olderThan) {
        if (this.newerThan != null) {
            throw new UnsupportedOperationException("Cannot set 'olderThan'. 'newerThan' already set.");
        }
        this.olderThan = olderThan;
    }

    public void setSearchString(@Nonnull String searchString) {
        this.searchString = searchString;
    }

    @Deprecated
    public void add(@Nonnull List<T> runItems) {
        this.addInternal(runItems);
    }

    public void add(@Nonnull Iterable<T> runItems) {
        this.addInternal(runItems);
    }

    public void add(@Nonnull Iterable<T> runItems, @Nonnull List<Queue.Item> queueItems) {
        this.sort(queueItems);
        this.addInternal(Iterables.concat(queueItems, runItems));
    }

    private <ItemT> void addInternal(@Nonnull Iterable<ItemT> items) {
        block11: {
            block13: {
                ItemT item;
                block12: {
                    if (!items.iterator().hasNext()) {
                        return;
                    }
                    this.nextBuildNumber = this.getNextBuildNumber(items.iterator().next());
                    if (this.newerThan != null || this.olderThan != null) break block12;
                    Iterator<ItemT> iter = items.iterator();
                    while (iter.hasNext()) {
                        this.add(iter.next());
                        if (!this.isFull()) continue;
                    }
                    this.hasDownPage = iter.hasNext();
                    break block11;
                }
                if (this.newerThan == null) break block13;
                int toFillCount = this.getFillCount();
                if (toFillCount <= 0) break block11;
                LinkedList<ItemT> itemsToAdd = new LinkedList<ItemT>();
                Iterator<ItemT> iter = items.iterator();
                while (iter.hasNext() && HistoryPageEntry.getEntryId(item = iter.next()) > this.newerThan) {
                    itemsToAdd.addLast(item);
                    if (itemsToAdd.size() <= toFillCount) continue;
                    itemsToAdd.removeFirst();
                    this.hasUpPage = true;
                }
                if (itemsToAdd.size() == 0) {
                    this.hasDownPage = true;
                } else {
                    if (itemsToAdd.size() < toFillCount) {
                        Iterator<ItemT> skippedIter = items.iterator();
                        Iterators.skip(skippedIter, itemsToAdd.size());
                        for (int i = itemsToAdd.size(); i < toFillCount && skippedIter.hasNext(); ++i) {
                            ItemT item2 = skippedIter.next();
                            itemsToAdd.addLast(item2);
                        }
                    }
                    this.hasDownPage = iter.hasNext();
                    for (Object item3 : itemsToAdd) {
                        this.add(item3);
                    }
                }
                break block11;
            }
            if (this.olderThan != null) {
                Iterator<ItemT> iter = items.iterator();
                while (iter.hasNext()) {
                    ItemT item = iter.next();
                    if (HistoryPageEntry.getEntryId(item) >= this.olderThan) {
                        this.hasUpPage = true;
                        continue;
                    }
                    this.add(item);
                    if (!this.isFull()) continue;
                    this.hasDownPage = iter.hasNext();
                    break;
                }
            }
        }
    }

    public int size() {
        return this.queueItems.size() + this.runs.size();
    }

    private void sort(List<? extends Object> items) {
        Collections.sort(items, new Comparator<Object>(){

            @Override
            public int compare(Object o1, Object o2) {
                long o2QID;
                long o1QID = HistoryPageEntry.getEntryId(o1);
                if (o1QID < (o2QID = HistoryPageEntry.getEntryId(o2))) {
                    return 1;
                }
                if (o1QID == o2QID) {
                    return 0;
                }
                return -1;
            }
        });
    }

    private long getNextBuildNumber(@Nonnull Object entry) {
        if (entry instanceof Queue.Item) {
            Queue.Task task = ((Queue.Item)entry).task;
            if (task instanceof Job) {
                return ((Job)((Object)task)).getNextBuildNumber();
            }
        } else if (entry instanceof Run) {
            return ((Job)((Run)entry).getParent()).getNextBuildNumber();
        }
        return HistoryPageEntry.getEntryId(entry) + 1L;
    }

    private void addQueueItem(Queue.Item item) {
        HistoryPageEntry<Queue.Item> entry = new HistoryPageEntry<Queue.Item>(item);
        this.queueItems.add(entry);
        this.updateNewestOldest(entry.getEntryId());
    }

    private void addRun(Run run) {
        HistoryPageEntry<Run> entry = new HistoryPageEntry<Run>(run);
        if (this.runs.size() > 0 && entry.getEntryId() > this.runs.get(this.runs.size() - 1).getEntryId()) {
            throw new IllegalStateException("Runs were out of order");
        }
        this.runs.add(entry);
        this.updateNewestOldest(entry.getEntryId());
    }

    private void updateNewestOldest(long entryId) {
        this.newestOnPage = Math.max(this.newestOnPage, entryId);
        this.oldestOnPage = Math.min(this.oldestOnPage, entryId);
    }

    private boolean add(Object entry) {
        if (entry instanceof Queue.Item) {
            Queue.Item item = (Queue.Item)entry;
            if (this.searchString != null && !this.fitsSearchParams(item)) {
                return false;
            }
            this.addQueueItem(item);
            return true;
        }
        if (entry instanceof Run) {
            Run run = (Run)entry;
            if (this.searchString != null && !this.fitsSearchParams(run)) {
                return false;
            }
            this.addRun(run);
            return true;
        }
        return false;
    }

    private boolean isFull() {
        return this.size() >= this.maxEntries;
    }

    private int getFillCount() {
        return Math.max(0, this.maxEntries - this.size());
    }

    private boolean fitsSearchParams(@Nonnull Queue.Item item) {
        if (this.fitsSearchString(item.getDisplayName())) {
            return true;
        }
        return this.fitsSearchString(item.getId());
    }

    private boolean fitsSearchParams(@Nonnull Run run) {
        if (this.searchString == null) {
            return true;
        }
        if (this.fitsSearchString(run.getDisplayName())) {
            return true;
        }
        if (this.fitsSearchString(run.getDescription())) {
            return true;
        }
        if (this.fitsSearchString(run.getNumber())) {
            return true;
        }
        if (this.fitsSearchString(run.getQueueId())) {
            return true;
        }
        if (this.fitsSearchString(run.getResult())) {
            return true;
        }
        if (run instanceof AbstractBuild && this.fitsSearchBuildVariables((AbstractBuild)run)) {
            return true;
        }
        ParametersAction parametersAction = run.getAction(ParametersAction.class);
        return parametersAction != null && this.fitsSearchBuildParameters(parametersAction);
    }

    private boolean fitsSearchString(Object data) {
        if (this.searchString == null) {
            return true;
        }
        if (data == null) {
            return false;
        }
        if (data instanceof Number) {
            return data.toString().equals(this.searchString);
        }
        if (UserSearchProperty.isCaseInsensitive()) {
            return data.toString().toLowerCase().contains(this.searchString.toLowerCase());
        }
        return data.toString().contains(this.searchString);
    }

    private boolean fitsSearchBuildVariables(AbstractBuild<?, ?> runAsBuild) {
        Map<String, String> buildVariables = runAsBuild.getBuildVariables();
        for (String paramsValues : buildVariables.values()) {
            if (!this.fitsSearchString(paramsValues)) continue;
            return true;
        }
        return false;
    }

    private boolean fitsSearchBuildParameters(ParametersAction parametersAction) {
        List<ParameterValue> parameters = parametersAction.getParameters();
        for (ParameterValue parameter : parameters) {
            if (parameter.isSensitive() || !this.fitsSearchString(parameter.getValue())) continue;
            return true;
        }
        return false;
    }
}

