/*
 * Decompiled with CFR 0.152.
 */
package hudson.markup;

import com.google.common.base.Throwables;
import hudson.Extension;
import hudson.markup.MarkupFormatter;
import hudson.markup.MarkupFormatterDescriptor;
import hudson.markup.MyspacePolicy;
import java.io.IOException;
import java.io.Writer;
import org.kohsuke.stapler.DataBoundConstructor;
import org.owasp.html.Handler;
import org.owasp.html.HtmlSanitizer;
import org.owasp.html.HtmlStreamEventReceiver;
import org.owasp.html.HtmlStreamRenderer;

public class RawHtmlMarkupFormatter
extends MarkupFormatter {
    final boolean disableSyntaxHighlighting;
    public static final MarkupFormatter INSTANCE = new RawHtmlMarkupFormatter(false);

    @DataBoundConstructor
    public RawHtmlMarkupFormatter(boolean disableSyntaxHighlighting) {
        this.disableSyntaxHighlighting = disableSyntaxHighlighting;
    }

    public boolean isDisableSyntaxHighlighting() {
        return this.disableSyntaxHighlighting;
    }

    public void translate(String markup, Writer output) throws IOException {
        HtmlStreamRenderer renderer = HtmlStreamRenderer.create((Appendable)output, (Handler)new Handler<IOException>(){

            public void handle(IOException ex) {
                Throwables.propagate((Throwable)ex);
            }
        }, (Handler)new Handler<String>(){

            public void handle(String x) {
                throw new Error(x);
            }
        });
        HtmlSanitizer.sanitize((String)markup, (HtmlSanitizer.Policy)MyspacePolicy.POLICY_DEFINITION.apply((HtmlStreamEventReceiver)renderer));
    }

    public String getCodeMirrorMode() {
        return this.disableSyntaxHighlighting ? null : "htmlmixed";
    }

    public String getCodeMirrorConfig() {
        return "mode:'text/html'";
    }

    @Extension
    public static class DescriptorImpl
    extends MarkupFormatterDescriptor {
        public String getDisplayName() {
            return "Safe HTML";
        }
    }
}

