/*
 * Decompiled with CFR 0.152.
 */
package hudson.slaves;

import hudson.EnvVars;
import hudson.Extension;
import hudson.Util;
import hudson.model.TaskListener;
import hudson.slaves.CommandLauncher;
import hudson.slaves.ComputerConnector;
import hudson.slaves.ComputerConnectorDescriptor;
import hudson.util.FormValidation;
import java.io.IOException;
import org.jenkinsci.Symbol;
import org.jenkinsci.plugins.command_launcher.Messages;
import org.jenkinsci.plugins.scriptsecurity.scripts.ApprovalContext;
import org.jenkinsci.plugins.scriptsecurity.scripts.ScriptApproval;
import org.jenkinsci.plugins.scriptsecurity.scripts.languages.SystemCommandLanguage;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.QueryParameter;

public class CommandConnector
extends ComputerConnector {
    public final String command;

    @DataBoundConstructor
    public CommandConnector(String command) {
        this.command = command;
        ScriptApproval.get().configuring(command, SystemCommandLanguage.get(), ApprovalContext.create().withCurrentUser());
    }

    private Object readResolve() {
        ScriptApproval.get().configuring(this.command, SystemCommandLanguage.get(), ApprovalContext.create());
        return this;
    }

    public CommandLauncher launch(String host, TaskListener listener) throws IOException, InterruptedException {
        return new CommandLauncher(new EnvVars(new String[]{"SLAVE", host}), this.command);
    }

    @Extension
    @Symbol(value={"command"})
    public static class DescriptorImpl
    extends ComputerConnectorDescriptor {
        public String getDisplayName() {
            return Messages.CommandLauncher_displayName();
        }

        public FormValidation doCheckCommand(@QueryParameter String value) {
            if (Util.fixEmptyAndTrim((String)value) == null) {
                return FormValidation.error((String)Messages.CommandLauncher_NoLaunchCommand());
            }
            return ScriptApproval.get().checking(value, SystemCommandLanguage.get());
        }
    }
}

