/*
 * Decompiled with CFR 0.152.
 */
package org.kohsuke.stapler;

import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.GenericDeclaration;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import java.util.TreeMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.io.IOUtils;
import org.jvnet.tiger_types.Types;
import org.kohsuke.asm5.ClassReader;
import org.kohsuke.asm5.ClassVisitor;
import org.kohsuke.asm5.Label;
import org.kohsuke.asm5.MethodVisitor;
import org.kohsuke.stapler.CapturedParameterNames;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.Function;
import org.kohsuke.stapler.FunctionList;
import org.kohsuke.stapler.NoStaplerConstructorException;
import org.kohsuke.stapler.UnionAnnotatedElement;

public final class ClassDescriptor {
    public final Class clazz;
    public final FunctionList methods;
    public final Field[] fields;
    private static final Logger LOGGER = Logger.getLogger(ClassDescriptor.class.getName());
    private static final String[] EMPTY_ARRAY = new String[0];

    public ClassDescriptor(Class clazz, Class ... wrappers) {
        this.clazz = clazz;
        this.fields = clazz.getFields();
        ArrayList<MethodMirror> methods = new ArrayList<MethodMirror>();
        this.findMethods(clazz, clazz, methods, new HashSet<Class>());
        LinkedHashMap<Signature, ArrayList<Method>> groups = new LinkedHashMap<Signature, ArrayList<Method>>();
        for (MethodMirror m : methods) {
            ArrayList<Method> v = (ArrayList<Method>)groups.get(m.sig);
            if (v == null) {
                v = new ArrayList<Method>();
                groups.put(m.sig, v);
            }
            v.add(m.method);
        }
        ArrayList<Function> functions = new ArrayList<Function>();
        for (List m : groups.values()) {
            if (m.size() == 1) {
                Method one = (Method)m.get(0);
                functions.add(new Function.InstanceFunction(one).wrapByInterceptors(one));
                continue;
            }
            Collections.reverse(m);
            functions.add(new Function.OverridingInstanceFunction(m).wrapByInterceptors(new UnionAnnotatedElement(m)));
        }
        if (wrappers != null) {
            for (Class w : wrappers) {
                for (Method m : w.getMethods()) {
                    Class<?>[] p;
                    if (!Modifier.isStatic(m.getModifiers()) || (p = m.getParameterTypes()).length == 0 || p[0].isAssignableFrom(clazz)) continue;
                    functions.add(new Function.StaticFunction(m).wrapByInterceptors(m));
                }
            }
        }
        this.methods = new FunctionList(functions);
    }

    private List<MethodMirror> findMethods(Class c, Type logical, List<MethodMirror> result, Set<Class> visited) {
        if (!visited.add(c)) {
            return result;
        }
        for (Class<?> i : c.getInterfaces()) {
            this.findMethods(i, Types.getBaseClass((Type)logical, i), result, visited);
        }
        Class sc = c.getSuperclass();
        if (sc != null) {
            this.findMethods(sc, Types.getBaseClass((Type)logical, sc), result, visited);
        }
        Method[] declaredMethods = c.getDeclaredMethods();
        Arrays.sort(declaredMethods, new Comparator<Method>(){

            @Override
            public int compare(Method m1, Method m2) {
                boolean m2d;
                boolean m1d = m1.getAnnotation(Deprecated.class) != null;
                boolean bl = m2d = m2.getAnnotation(Deprecated.class) != null;
                if (m1d && !m2d) {
                    return 1;
                }
                if (!m1d && m2d) {
                    return -1;
                }
                return m1.toString().compareTo(m2.toString());
            }
        });
        for (Method m : declaredMethods) {
            if (m.isBridge() || (m.getModifiers() & 1) == 0) continue;
            Type[] paramTypes = m.getGenericParameterTypes();
            Class[] erasedParamTypes = new Class[paramTypes.length];
            for (int i = 0; i < paramTypes.length; ++i) {
                erasedParamTypes[i] = logical instanceof ParameterizedType ? Types.erasure((Type)Types.bind((Type)paramTypes[i], (GenericDeclaration)c, (ParameterizedType)((ParameterizedType)logical))) : Types.erasure((Type)paramTypes[i]);
            }
            result.add(new MethodMirror(new Signature(m.getName(), erasedParamTypes), m));
        }
        return result;
    }

    public static String[] loadParameterNames(Method m) {
        CapturedParameterNames cpn = m.getAnnotation(CapturedParameterNames.class);
        if (cpn != null) {
            return cpn.value();
        }
        try {
            String[] n = ASM.loadParametersFromAsm(m);
            if (n != null) {
                return n;
            }
        }
        catch (LinkageError e) {
            LOGGER.log(Level.FINE, "Incompatible ASM", e);
        }
        catch (IOException e) {
            LOGGER.log(Level.WARNING, "Failed to load a class file", e);
        }
        Class<?> c = m.getDeclaringClass();
        URL url = c.getClassLoader().getResource(c.getName().replace('.', '/').replace('$', '/') + '/' + m.getName() + ".stapler");
        if (url != null) {
            try {
                return IOUtils.toString((InputStream)url.openStream()).split(",");
            }
            catch (IOException e) {
                LOGGER.log(Level.WARNING, "Failed to load " + url, e);
                return EMPTY_ARRAY;
            }
        }
        return EMPTY_ARRAY;
    }

    public static String[] loadParameterNames(Constructor<?> m) {
        CapturedParameterNames cpn = m.getAnnotation(CapturedParameterNames.class);
        if (cpn != null) {
            return cpn.value();
        }
        try {
            String[] n = ASM.loadParametersFromAsm(m);
            if (n != null) {
                return n;
            }
        }
        catch (LinkageError e) {
            LOGGER.log(Level.FINE, "Incompatible ASM", e);
        }
        catch (IOException e) {
            LOGGER.log(Level.WARNING, "Failed to load a class file", e);
        }
        return EMPTY_ARRAY;
    }

    public String[] loadConstructorParamNames() {
        Constructor<?>[] ctrs = this.clazz.getConstructors();
        Constructor<?> dbc = null;
        for (Constructor<?> c : ctrs) {
            if (c.getAnnotation(DataBoundConstructor.class) == null) continue;
            dbc = c;
            break;
        }
        if (dbc == null) {
            throw new NoStaplerConstructorException("There's no @DataBoundConstructor on any constructor of " + this.clazz);
        }
        String[] names = ClassDescriptor.loadParameterNames(dbc);
        if (names.length == dbc.getParameterTypes().length) {
            return names;
        }
        String resourceName = this.clazz.getName().replace('.', '/').replace('$', '/') + ".stapler";
        ClassLoader cl = this.clazz.getClassLoader();
        if (cl == null) {
            throw new NoStaplerConstructorException(this.clazz + " is a built-in type");
        }
        InputStream s = cl.getResourceAsStream(resourceName);
        if (s != null) {
            try {
                Properties p = new Properties();
                p.load(s);
                s.close();
                String v = p.getProperty("constructor");
                if (v.length() == 0) {
                    return new String[0];
                }
                return v.split(",");
            }
            catch (IOException e) {
                throw new IllegalArgumentException("Unable to load " + resourceName, e);
            }
        }
        throw new NoStaplerConstructorException("Unable to find " + resourceName + ". Run 'mvn clean compile' once to run the annotation processor.");
    }

    final class Signature {
        final String methodName;
        final Class[] parameters;

        Signature(String methodName, Class[] parameters) {
            this.methodName = methodName;
            this.parameters = parameters;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Signature that = (Signature)o;
            return this.methodName.equals(that.methodName) && Arrays.equals(this.parameters, that.parameters);
        }

        public int hashCode() {
            return 31 * this.methodName.hashCode() + Arrays.hashCode(this.parameters);
        }
    }

    final class MethodMirror {
        final Signature sig;
        final Method method;

        public MethodMirror(Signature sig, Method method) {
            this.sig = sig;
            this.method = method;
        }
    }

    static class ASM {
        ASM() {
        }

        private static String[] loadParametersFromAsm(final Method m) throws IOException {
            String[] paramNames = new String[m.getParameterTypes().length];
            if (paramNames.length == 0) {
                return paramNames;
            }
            Class<?> c = m.getDeclaringClass();
            URL clazz = c.getClassLoader().getResource(c.getName().replace('.', '/') + ".class");
            if (clazz == null) {
                return null;
            }
            final TreeMap localVars = new TreeMap();
            ClassReader r = new ClassReader(clazz.openStream());
            r.accept(new ClassVisitor(327680){
                final String md;
                final int limit;
                {
                    super(x0);
                    this.md = org.kohsuke.asm5.Type.getMethodDescriptor((Method)m);
                    this.limit = (m.getModifiers() & 8) != 0 ? 0 : 1;
                }

                public MethodVisitor visitMethod(int access, String methodName, String desc, String signature, String[] exceptions) {
                    if (methodName.equals(m.getName()) && desc.equals(this.md)) {
                        return new MethodVisitor(327680){

                            public void visitLocalVariable(String name, String desc, String signature, Label start, Label end, int index) {
                                if (index >= limit) {
                                    localVars.put(index, name);
                                }
                            }
                        };
                    }
                    return null;
                }
            }, 0);
            int i = 0;
            Iterator iterator = localVars.values().iterator();
            while (iterator.hasNext()) {
                String s;
                paramNames[i] = s = (String)iterator.next();
                if (++i != paramNames.length) continue;
                return paramNames;
            }
            return null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private static String[] loadParametersFromAsm(final Constructor m) throws IOException {
            String[] paramNames = new String[m.getParameterTypes().length];
            if (paramNames.length == 0) {
                return paramNames;
            }
            Class c = m.getDeclaringClass();
            URL clazz = c.getClassLoader().getResource(c.getName().replace('.', '/') + ".class");
            if (clazz == null) {
                return null;
            }
            final TreeMap localVars = new TreeMap();
            try (InputStream is = clazz.openStream();){
                ClassReader r = new ClassReader(is);
                r.accept(new ClassVisitor(327680){
                    final String md;
                    {
                        super(x0);
                        this.md = ASM.getConstructorDescriptor(m);
                    }

                    public MethodVisitor visitMethod(int access, String methodName, String desc, String signature, String[] exceptions) {
                        if (methodName.equals("<init>") && desc.equals(this.md)) {
                            return new MethodVisitor(327680){

                                public void visitLocalVariable(String name, String desc, String signature, Label start, Label end, int index) {
                                    if (index > 0) {
                                        localVars.put(index, name);
                                    }
                                }
                            };
                        }
                        return null;
                    }
                }, 0);
            }
            int i = 0;
            Iterator iterator = localVars.values().iterator();
            while (iterator.hasNext()) {
                String s;
                paramNames[i] = s = (String)iterator.next();
                if (++i != paramNames.length) continue;
                return paramNames;
            }
            return null;
        }

        private static String getConstructorDescriptor(Constructor c) {
            StringBuilder buf = new StringBuilder("(");
            for (Class<?> p : c.getParameterTypes()) {
                buf.append(org.kohsuke.asm5.Type.getDescriptor(p));
            }
            return buf.append(")V").toString();
        }
    }
}

