/*
 * Decompiled with CFR 0.152.
 */
package org.kohsuke.stapler;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletException;
import org.apache.commons.discovery.ResourceNameIterator;
import org.apache.commons.discovery.resource.ClassLoaders;
import org.apache.commons.discovery.resource.names.DiscoverServiceNames;
import org.kohsuke.stapler.Dispatcher;
import org.kohsuke.stapler.IndexViewDispatcher;
import org.kohsuke.stapler.MetaClass;
import org.kohsuke.stapler.RequestImpl;
import org.kohsuke.stapler.ResponseImpl;
import org.kohsuke.stapler.lang.Klass;

public abstract class Facet {
    public static final Logger LOGGER = Logger.getLogger(Facet.class.getName());

    public abstract void buildViewDispatchers(MetaClass var1, List<Dispatcher> var2);

    public void buildIndexDispatchers(MetaClass owner, List<Dispatcher> dispatchers) {
        dispatchers.add(new IndexViewDispatcher(owner, this));
    }

    public void buildFallbackDispatchers(MetaClass owner, List<Dispatcher> dispatchers) {
    }

    public static List<Facet> discover(ClassLoader cl) {
        return Facet.discoverExtensions(Facet.class, cl);
    }

    public static <T> List<T> discoverExtensions(Class<T> type, ClassLoader ... cls) {
        ArrayList r = new ArrayList();
        HashSet<String> classNames = new HashSet<String>();
        for (ClassLoader cl : cls) {
            ClassLoaders classLoaders = new ClassLoaders();
            classLoaders.put(cl);
            DiscoverServiceNames dc = new DiscoverServiceNames(classLoaders);
            ResourceNameIterator itr = dc.findResourceNames(type.getName());
            while (itr.hasNext()) {
                Class<?> c;
                String name = itr.nextResourceName();
                if (!classNames.add(name)) continue;
                try {
                    c = cl.loadClass(name);
                }
                catch (ClassNotFoundException e) {
                    LOGGER.log(Level.WARNING, "Failed to load " + name, e);
                    continue;
                }
                try {
                    r.add(c.newInstance());
                }
                catch (InstantiationException e) {
                    LOGGER.log(Level.WARNING, "Failed to instantiate " + c, e);
                }
                catch (IllegalAccessException e) {
                    LOGGER.log(Level.WARNING, "Failed to instantiate " + c, e);
                }
            }
        }
        return r;
    }

    public RequestDispatcher createRequestDispatcher(RequestImpl request, Klass<?> type, Object it, String viewName) throws IOException {
        return null;
    }

    public RequestDispatcher createRequestDispatcher(RequestImpl request, Class type, Object it, String viewName) throws IOException {
        return this.createRequestDispatcher(request, Klass.java(type), it, viewName);
    }

    public abstract boolean handleIndexRequest(RequestImpl var1, ResponseImpl var2, Object var3, MetaClass var4) throws IOException, ServletException;

    public Klass<?> getKlass(Object o) {
        return null;
    }
}

