/*
 * Decompiled with CFR 0.152.
 */
package org.kohsuke.stapler;

import java.lang.annotation.Annotation;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashSet;
import org.kohsuke.stapler.Function;
import org.kohsuke.stapler.WebMethod;

public final class FunctionList
extends AbstractList<Function> {
    private final Function[] functions;

    public FunctionList(Function ... functions) {
        this.functions = functions;
    }

    public FunctionList(Collection<Function> functions) {
        this.functions = functions.toArray(new Function[0]);
    }

    private FunctionList filter(Filter f) {
        ArrayList<Function> r = new ArrayList<Function>();
        for (Function m : this.functions) {
            if (!f.keep(m)) continue;
            r.add(m);
        }
        return new FunctionList(r.toArray(new Function[0]));
    }

    @Override
    public Function get(int index) {
        return this.functions[index];
    }

    @Override
    public int size() {
        return this.functions.length;
    }

    public FunctionList union(FunctionList that) {
        LinkedHashSet<Function> combined = new LinkedHashSet<Function>();
        combined.addAll(Arrays.asList(this.functions));
        combined.addAll(Arrays.asList(that.functions));
        return new FunctionList(combined);
    }

    public FunctionList prefix(final String prefix) {
        return this.filter(new Filter(){

            @Override
            public boolean keep(Function m) {
                return m.getName().startsWith(prefix);
            }
        });
    }

    public FunctionList annotated(final Class<? extends Annotation> ann) {
        return this.filter(new Filter(){

            @Override
            public boolean keep(Function m) {
                return m.getAnnotation(ann) != null;
            }
        });
    }

    public FunctionList name(final String name) {
        return this.filter(new Filter(){

            @Override
            public boolean keep(Function m) {
                return m.getName().equals(name);
            }
        });
    }

    public FunctionList signature(final Class ... args) {
        return this.filter(new Filter(){

            @Override
            public boolean keep(Function m) {
                return Arrays.equals(m.getParameterTypes(), args);
            }
        });
    }

    public FunctionList webMethods() {
        return this.filter(new Filter(){

            @Override
            public boolean keep(Function m) {
                return m.getName().startsWith("do") || m.getAnnotation(WebMethod.class) != null;
            }
        });
    }

    public FunctionList signatureStartsWith(final Class ... args) {
        return this.filter(new Filter(){

            @Override
            public boolean keep(Function m) {
                Class[] params = m.getParameterTypes();
                if (params.length < args.length) {
                    return false;
                }
                for (int i = 0; i < args.length; ++i) {
                    if (params[i] == args[i]) continue;
                    return false;
                }
                return true;
            }
        });
    }

    public static interface Filter {
        public boolean keep(Function var1);
    }
}

