/*
 * Decompiled with CFR 0.152.
 */
package org.kohsuke.stapler;

import java.io.IOException;
import java.io.Reader;
import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.annotation.PostConstruct;
import javax.servlet.ServletException;
import net.sf.json.JSONArray;
import org.apache.commons.io.IOUtils;
import org.kohsuke.stapler.DirectoryishDispatcher;
import org.kohsuke.stapler.Dispatcher;
import org.kohsuke.stapler.Facet;
import org.kohsuke.stapler.Function;
import org.kohsuke.stapler.FunctionList;
import org.kohsuke.stapler.HttpDeletable;
import org.kohsuke.stapler.HttpDeletableDispatcher;
import org.kohsuke.stapler.IndexDispatcher;
import org.kohsuke.stapler.IndexHtmlDispatcher;
import org.kohsuke.stapler.JavaScriptMethodContext;
import org.kohsuke.stapler.KlassDescriptor;
import org.kohsuke.stapler.LimitedTo;
import org.kohsuke.stapler.MetaClassLoader;
import org.kohsuke.stapler.NameBasedDispatcher;
import org.kohsuke.stapler.RequestImpl;
import org.kohsuke.stapler.ResponseImpl;
import org.kohsuke.stapler.SingleLinkedList;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.TearOffSupport;
import org.kohsuke.stapler.TraversalMethodContext;
import org.kohsuke.stapler.WebApp;
import org.kohsuke.stapler.WebMethod;
import org.kohsuke.stapler.WebMethodContext;
import org.kohsuke.stapler.bind.JavaScriptMethod;
import org.kohsuke.stapler.lang.FieldRef;
import org.kohsuke.stapler.lang.Klass;
import org.kohsuke.stapler.lang.MethodRef;

public class MetaClass
extends TearOffSupport {
    public final Class clazz;
    public final Klass<?> klass;
    public final MetaClassLoader classLoader;
    public final List<Dispatcher> dispatchers = new ArrayList<Dispatcher>();
    public final MetaClass baseClass;
    public final WebApp webApp;
    private volatile SingleLinkedList<MethodRef> postConstructMethods;
    public static boolean NO_CACHE = false;

    MetaClass(WebApp webApp, Klass<?> klass) {
        this.clazz = klass.toJavaClass();
        this.klass = klass;
        this.webApp = webApp;
        this.baseClass = webApp.getMetaClass(klass.getSuperClass());
        this.classLoader = MetaClassLoader.get(this.clazz.getClassLoader());
        this.buildDispatchers();
    }

    /*
     * WARNING - void declaration
     */
    void buildDispatchers() {
        Function ff;
        String name;
        Annotation a;
        this.dispatchers.clear();
        KlassDescriptor node = new KlassDescriptor(this.klass);
        this.dispatchers.add(new DirectoryishDispatcher());
        if (HttpDeletable.class.isAssignableFrom(this.clazz)) {
            this.dispatchers.add(new HttpDeletableDispatcher());
        }
        for (Function function : node.methods.webMethods()) {
            void var5_18;
            a = function.getAnnotation(WebMethod.class);
            if (a != null && a.name().length > 0) {
                String[] stringArray = a.name();
            } else {
                String[] stringArray = new String[]{MetaClass.camelize(function.getName().substring(2))};
            }
            for (void name2 : var5_18) {
                final Function ff2 = function.contextualize(new WebMethodContext((String)name2));
                if (name2.length() == 0) {
                    this.dispatchers.add(new IndexDispatcher(ff2));
                    continue;
                }
                this.dispatchers.add(new NameBasedDispatcher((String)name2){

                    @Override
                    public boolean doDispatch(RequestImpl req, ResponseImpl rsp, Object node) throws IllegalAccessException, InvocationTargetException, ServletException, IOException {
                        if (1.traceable()) {
                            1.trace(req, rsp, "-> <%s>.%s(...)", node, ff2.getName());
                        }
                        return ff2.bindAndInvokeAndServeResponse(node, req, rsp, new Object[0]);
                    }

                    @Override
                    public String toString() {
                        return ff2.getQualifiedName() + "(...) for url=/" + this.name + "/...";
                    }
                });
            }
        }
        for (Function function : node.methods.name("doIndex")) {
            this.dispatchers.add(new IndexDispatcher(function.contextualize(new WebMethodContext(""))));
        }
        for (Function function : node.methods.prefix("js")) {
            String name3 = MetaClass.camelize(function.getName().substring(2));
            Function function2 = function.contextualize(new JavaScriptMethodContext(name3));
            this.dispatchers.add(new JavaScriptProxyMethodDispatcher(name3, function2));
        }
        for (Function function : node.methods.annotated(JavaScriptMethod.class)) {
            void var5_24;
            a = function.getAnnotation(JavaScriptMethod.class);
            if (a != null && a.name().length > 0) {
                String[] stringArray = a.name();
            } else {
                String[] stringArray = new String[]{function.getName()};
            }
            for (void name2 : var5_24) {
                this.dispatchers.add(new JavaScriptProxyMethodDispatcher((String)name2, function.contextualize(new JavaScriptMethodContext((String)name2))));
            }
        }
        for (Facet facet : this.webApp.facets) {
            facet.buildViewDispatchers(this, this.dispatchers);
        }
        for (Facet facet : this.webApp.facets) {
            facet.buildIndexDispatchers(this, this.dispatchers);
        }
        Dispatcher d = IndexHtmlDispatcher.make(this.webApp.context, this.clazz);
        if (d != null) {
            this.dispatchers.add(d);
        }
        for (final FieldRef f : node.fields) {
            this.dispatchers.add(new NameBasedDispatcher(f.getName()){
                final String role;
                {
                    super(name);
                    this.role = MetaClass.this.getProtectedRole(f);
                }

                @Override
                public boolean doDispatch(RequestImpl req, ResponseImpl rsp, Object node) throws IOException, ServletException, IllegalAccessException {
                    if (this.role != null && !req.isUserInRole(this.role)) {
                        throw new IllegalAccessException("Needs to be in role " + this.role);
                    }
                    if (2.traceable()) {
                        2.traceEval(req, rsp, node, f.getName());
                    }
                    req.getStapler().invoke(req, rsp, f.get(node));
                    return true;
                }

                @Override
                public String toString() {
                    return String.format("%1$s for url=/%2$s/...", f.getQualifiedName(), f.getName());
                }
            });
        }
        FunctionList functionList = node.methods.prefix("get");
        for (Function function : functionList.signature(new Class[0])) {
            if (function.getName().length() <= 3) continue;
            name = MetaClass.camelize(function.getName().substring(3));
            final Function ff3 = function.contextualize(new TraversalMethodContext(name));
            this.dispatchers.add(new NameBasedDispatcher(name){

                @Override
                public boolean doDispatch(RequestImpl req, ResponseImpl rsp, Object node) throws IOException, ServletException, IllegalAccessException, InvocationTargetException {
                    if (3.traceable()) {
                        3.traceEval(req, rsp, node, ff3.getName() + "()");
                    }
                    req.getStapler().invoke(req, rsp, ff3.invoke(req, rsp, node, new Object[0]));
                    return true;
                }

                @Override
                public String toString() {
                    return String.format("%1$s() for url=/%2$s/...", ff3.getQualifiedName(), this.name);
                }
            });
        }
        for (Function function : functionList.signature(StaplerRequest.class)) {
            if (function.getName().length() <= 3) continue;
            name = MetaClass.camelize(function.getName().substring(3));
            final Function ff4 = function.contextualize(new TraversalMethodContext(name));
            this.dispatchers.add(new NameBasedDispatcher(name){

                @Override
                public boolean doDispatch(RequestImpl req, ResponseImpl rsp, Object node) throws IOException, ServletException, IllegalAccessException, InvocationTargetException {
                    if (4.traceable()) {
                        4.traceEval(req, rsp, node, ff4.getName() + "(...)");
                    }
                    req.getStapler().invoke(req, rsp, ff4.invoke(req, rsp, node, req));
                    return true;
                }

                @Override
                public String toString() {
                    return String.format("%1$s(StaplerRequest) for url=/%2$s/...", ff4.getQualifiedName(), this.name);
                }
            });
        }
        for (Function function : functionList.signature(String.class)) {
            if (function.getName().length() <= 3) continue;
            name = MetaClass.camelize(function.getName().substring(3));
            final Function ff5 = function.contextualize(new TraversalMethodContext(name));
            this.dispatchers.add(new NameBasedDispatcher(name, 1){

                @Override
                public boolean doDispatch(RequestImpl req, ResponseImpl rsp, Object node) throws IOException, ServletException, IllegalAccessException, InvocationTargetException {
                    String token = req.tokens.next();
                    if (5.traceable()) {
                        5.traceEval(req, rsp, node, ff5.getName() + "(\"" + token + "\")");
                    }
                    req.getStapler().invoke(req, rsp, ff5.invoke(req, rsp, node, token));
                    return true;
                }

                @Override
                public String toString() {
                    return String.format("%1$s(String) for url=/%2$s/TOKEN/...", ff5.getQualifiedName(), this.name);
                }
            });
        }
        for (Function function : functionList.signature(Integer.TYPE)) {
            if (function.getName().length() <= 3) continue;
            name = MetaClass.camelize(function.getName().substring(3));
            final Function ff6 = function.contextualize(new TraversalMethodContext(name));
            this.dispatchers.add(new NameBasedDispatcher(name, 1){

                @Override
                public boolean doDispatch(RequestImpl req, ResponseImpl rsp, Object node) throws IOException, ServletException, IllegalAccessException, InvocationTargetException {
                    int idx = req.tokens.nextAsInt();
                    if (6.traceable()) {
                        6.traceEval(req, rsp, node, ff6.getName() + "(" + idx + ")");
                    }
                    req.getStapler().invoke(req, rsp, ff6.invoke(req, rsp, node, idx));
                    return true;
                }

                @Override
                public String toString() {
                    return String.format("%1$s(int) for url=/%2$s/N/...", ff6.getQualifiedName(), this.name);
                }
            });
        }
        for (Function function : functionList.signature(Long.TYPE)) {
            if (function.getName().length() <= 3) continue;
            name = MetaClass.camelize(function.getName().substring(3));
            final Function ff7 = function.contextualize(new TraversalMethodContext(name));
            this.dispatchers.add(new NameBasedDispatcher(name, 1){

                @Override
                public boolean doDispatch(RequestImpl req, ResponseImpl rsp, Object node) throws IOException, ServletException, IllegalAccessException, InvocationTargetException {
                    long idx = req.tokens.nextAsLong();
                    if (7.traceable()) {
                        7.traceEval(req, rsp, node, ff7.getName() + "(" + idx + ")");
                    }
                    req.getStapler().invoke(req, rsp, ff7.invoke(req, rsp, node, idx));
                    return true;
                }

                @Override
                public String toString() {
                    return String.format("%1$s(long) for url=/%2$s/N/...", ff7.getQualifiedName(), this.name);
                }
            });
        }
        if (this.klass.isArray()) {
            this.dispatchers.add(new Dispatcher(){

                @Override
                public boolean dispatch(RequestImpl req, ResponseImpl rsp, Object node) throws IOException, ServletException {
                    if (!req.tokens.hasMore()) {
                        return false;
                    }
                    try {
                        int index = req.tokens.nextAsInt();
                        if (8.traceable()) {
                            8.traceEval(req, rsp, node, "", "[" + index + "]");
                        }
                        req.getStapler().invoke(req, rsp, MetaClass.this.klass.getArrayElement(node, index));
                        return true;
                    }
                    catch (IndexOutOfBoundsException e) {
                        if (8.traceable()) {
                            8.trace(req, rsp, "-> IndexOutOfRange");
                        }
                        rsp.sendError(404);
                        return true;
                    }
                    catch (NumberFormatException e) {
                        return false;
                    }
                }

                @Override
                public String toString() {
                    return "Array look-up for url=/N/...";
                }
            });
        }
        if (this.klass.isMap()) {
            this.dispatchers.add(new Dispatcher(){

                @Override
                public boolean dispatch(RequestImpl req, ResponseImpl rsp, Object node) throws IOException, ServletException {
                    if (!req.tokens.hasMore()) {
                        return false;
                    }
                    try {
                        Object item;
                        String key = req.tokens.peek();
                        if (9.traceable()) {
                            9.traceEval(req, rsp, "", ".get(\"" + key + "\")");
                        }
                        if ((item = MetaClass.this.klass.getMapElement(node, key)) != null) {
                            req.tokens.next();
                            req.getStapler().invoke(req, rsp, item);
                            return true;
                        }
                        if (9.traceable()) {
                            9.trace(req, rsp, "Map.get(\"" + key + "\")==null. Back tracking.");
                        }
                        return false;
                    }
                    catch (NumberFormatException e) {
                        return false;
                    }
                }

                @Override
                public String toString() {
                    return "Map.get(String) look-up for url=/TOKEN/...";
                }
            });
        }
        for (Facet facet : this.webApp.facets) {
            facet.buildFallbackDispatchers(this, this.dispatchers);
        }
        for (Function function : functionList.signatureStartsWith(String.class).name("getDynamic")) {
            ff = function.contextualize(new TraversalMethodContext("\u0000"));
            this.dispatchers.add(new Dispatcher(){

                @Override
                public boolean dispatch(RequestImpl req, ResponseImpl rsp, Object node) throws IllegalAccessException, InvocationTargetException, IOException, ServletException {
                    Object target;
                    if (!req.tokens.hasMore()) {
                        return false;
                    }
                    String token = req.tokens.next();
                    if (10.traceable()) {
                        10.traceEval(req, rsp, node, "getDynamic(\"" + token + "\",...)");
                    }
                    if ((target = ff.bindAndInvoke(node, req, rsp, token)) != null) {
                        req.getStapler().invoke(req, rsp, target);
                        return true;
                    }
                    if (10.traceable()) {
                        10.trace(req, rsp, "            %s.getDynamic(\"%s\",...)==null. Back tracking.", node, token);
                    }
                    req.tokens.prev();
                    return false;
                }

                @Override
                public String toString() {
                    return String.format("%s(String,StaplerRequest,StaplerResponse) for url=/TOKEN/...", ff.getQualifiedName());
                }
            });
        }
        for (Function function : node.methods.name("doDynamic")) {
            ff = function.contextualize(new WebMethodContext("\u0000"));
            this.dispatchers.add(new Dispatcher(){

                @Override
                public boolean dispatch(RequestImpl req, ResponseImpl rsp, Object node) throws IllegalAccessException, InvocationTargetException, ServletException, IOException {
                    if (11.traceable()) {
                        11.trace(req, rsp, "-> <%s>.doDynamic(...)", node);
                    }
                    return ff.bindAndInvokeAndServeResponse(node, req, rsp, new Object[0]);
                }

                @Override
                public String toString() {
                    return String.format("%s(StaplerRequest,StaplerResponse) for any URL", ff.getQualifiedName());
                }
            });
        }
    }

    public SingleLinkedList<MethodRef> getPostConstructMethods() {
        if (this.postConstructMethods == null) {
            SingleLinkedList<MethodRef> l = this.baseClass == null ? SingleLinkedList.empty() : this.baseClass.getPostConstructMethods();
            for (MethodRef mr : this.klass.getDeclaredMethods()) {
                if (!mr.hasAnnotation(PostConstruct.class)) continue;
                l = l.grow(mr);
            }
            this.postConstructMethods = l;
        }
        return this.postConstructMethods;
    }

    private String getProtectedRole(FieldRef f) {
        try {
            LimitedTo a = f.getAnnotation(LimitedTo.class);
            return a != null ? a.value() : null;
        }
        catch (LinkageError e) {
            return null;
        }
    }

    public String toString() {
        return "MetaClass[" + this.klass + "]";
    }

    private static String camelize(String name) {
        return Character.toLowerCase(name.charAt(0)) + name.substring(1);
    }

    static {
        try {
            NO_CACHE = Boolean.getBoolean("stapler.jelly.noCache");
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
    }

    private static class JavaScriptProxyMethodDispatcher
    extends NameBasedDispatcher {
        private final Function f;

        public JavaScriptProxyMethodDispatcher(String name, Function f) {
            super(name, 0);
            this.f = f;
        }

        @Override
        public boolean doDispatch(RequestImpl req, ResponseImpl rsp, Object node) throws IllegalAccessException, InvocationTargetException, ServletException, IOException {
            if (!req.isJavaScriptProxyCall()) {
                return false;
            }
            req.stapler.getWebApp().getCrumbIssuer().validateCrumb(req, req.getHeader("Crumb"));
            if (JavaScriptProxyMethodDispatcher.traceable()) {
                JavaScriptProxyMethodDispatcher.trace(req, rsp, "-> <%s>.%s(...)", node, this.f.getName());
            }
            JSONArray jsargs = JSONArray.fromObject((Object)IOUtils.toString((Reader)req.getReader()));
            Object[] args = new Object[jsargs.size()];
            Class[] types = this.f.getParameterTypes();
            Object[] genericTypes = this.f.getGenericParameterTypes();
            if (args.length != types.length) {
                throw new IllegalArgumentException("argument count mismatch between " + jsargs + " and " + Arrays.toString(genericTypes));
            }
            for (int i = 0; i < args.length; ++i) {
                args[i] = req.bindJSON(genericTypes[i], types[i], jsargs.get(i));
            }
            return this.f.bindAndInvokeAndServeResponse(node, req, rsp, args);
        }

        @Override
        public String toString() {
            return this.f.getQualifiedName() + "(...) for url=/" + this.name + "/...";
        }
    }
}

