/*
 * Decompiled with CFR 0.152.
 */
package org.kohsuke.stapler;

import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import java.util.Map;

public abstract class TearOffSupport {
    private volatile Map<Class, Object> tearOffs;

    public final <T> T getTearOff(Class<T> t) {
        Map<Class, Object> m = this.tearOffs;
        if (m == null) {
            return null;
        }
        return (T)m.get(t);
    }

    public final <T> T loadTearOff(Class<T> t) {
        T o = this.getTearOff(t);
        if (o == null) {
            try {
                o = t.getConstructor(this.getClass()).newInstance(this);
                this.setTearOff(t, o);
            }
            catch (InstantiationException e) {
                throw new InstantiationError(e.getMessage());
            }
            catch (IllegalAccessException e) {
                throw new IllegalAccessError(e.getMessage());
            }
            catch (InvocationTargetException e) {
                Throwable ex = e.getTargetException();
                if (ex instanceof RuntimeException) {
                    throw (RuntimeException)ex;
                }
                if (ex instanceof Error) {
                    throw (Error)ex;
                }
                throw new Error(e);
            }
            catch (NoSuchMethodException e) {
                throw new NoSuchMethodError(e.getMessage());
            }
        }
        return o;
    }

    public synchronized <T> void setTearOff(Class<T> type, T instance) {
        Map<Class, Object> m = this.tearOffs;
        HashMap<Class, Object> r = m != null ? new HashMap<Class, Object>(this.tearOffs) : new HashMap();
        r.put(type, instance);
        this.tearOffs = r;
    }
}

