/*
 * Decompiled with CFR 0.152.
 */
package org.kohsuke.stapler;

import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.servlet.ServletContext;
import org.kohsuke.stapler.AbstractTearOff;
import org.kohsuke.stapler.BindInterceptor;
import org.kohsuke.stapler.CrumbIssuer;
import org.kohsuke.stapler.Facet;
import org.kohsuke.stapler.HttpResponseRenderer;
import org.kohsuke.stapler.MetaClass;
import org.kohsuke.stapler.Stapler;
import org.kohsuke.stapler.bind.BoundObjectTable;
import org.kohsuke.stapler.lang.KInstance;
import org.kohsuke.stapler.lang.Klass;

public class WebApp {
    public final ServletContext context;
    public final Map<Class, Class[]> wrappers = new HashMap<Class, Class[]>();
    public final Map<String, String> defaultEncodingForStaticResources = new HashMap<String, String>();
    public final List<Facet> facets = new Vector<Facet>();
    public final List<BindInterceptor> bindInterceptors = new CopyOnWriteArrayList<BindInterceptor>();
    public final Map<String, String> mimeTypes = new Hashtable<String, String>();
    private volatile ClassLoader classLoader;
    private final Map<Klass<?>, MetaClass> classMap = new HashMap();
    public final BoundObjectTable boundObjectTable = new BoundObjectTable();
    private final CopyOnWriteArrayList<HttpResponseRenderer> responseRenderers = new CopyOnWriteArrayList();
    private CrumbIssuer crumbIssuer = CrumbIssuer.DEFAULT;
    private final ConcurrentMap<String, Stapler> servlets = new ConcurrentHashMap<String, Stapler>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static WebApp get(ServletContext context) {
        Object o = context.getAttribute(WebApp.class.getName());
        if (o != null) return (WebApp)o;
        Class<WebApp> clazz = WebApp.class;
        synchronized (WebApp.class) {
            o = context.getAttribute(WebApp.class.getName());
            if (o != null) return (WebApp)o;
            o = new WebApp(context);
            context.setAttribute(WebApp.class.getName(), o);
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return (WebApp)o;
        }
    }

    public WebApp(ServletContext context) {
        this.context = context;
        this.facets.addAll(Facet.discoverExtensions(Facet.class, Thread.currentThread().getContextClassLoader(), this.getClass().getClassLoader()));
        this.responseRenderers.add(new HttpResponseRenderer.Default());
    }

    public Object getApp() {
        return this.context.getAttribute("app");
    }

    public void setApp(Object app) {
        this.context.setAttribute("app", app);
    }

    public CrumbIssuer getCrumbIssuer() {
        return this.crumbIssuer;
    }

    public void setCrumbIssuer(CrumbIssuer crumbIssuer) {
        this.crumbIssuer = crumbIssuer;
    }

    public CopyOnWriteArrayList<HttpResponseRenderer> getResponseRenderers() {
        return this.responseRenderers;
    }

    public ClassLoader getClassLoader() {
        ClassLoader cl = this.classLoader;
        if (cl == null) {
            cl = Thread.currentThread().getContextClassLoader();
        }
        if (cl == null) {
            cl = Stapler.class.getClassLoader();
        }
        return cl;
    }

    public <T extends Facet> T getFacet(Class<T> type) {
        for (Facet f : this.facets) {
            if (type != f.getClass()) continue;
            return (T)((Facet)type.cast(f));
        }
        return null;
    }

    public void setClassLoader(ClassLoader classLoader) {
        this.classLoader = classLoader;
    }

    public MetaClass getMetaClass(Class c) {
        return this.getMetaClass(Klass.java(c));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MetaClass getMetaClass(Klass<?> c) {
        if (c == null) {
            return null;
        }
        Map<Klass<?>, MetaClass> map = this.classMap;
        synchronized (map) {
            MetaClass mc = this.classMap.get(c);
            if (mc == null) {
                mc = new MetaClass(this, c);
                this.classMap.put(c, mc);
            }
            return mc;
        }
    }

    public MetaClass getMetaClass(Object o) {
        return this.getMetaClass(this.getKlass(o));
    }

    public Klass<?> getKlass(Object o) {
        KInstance ki;
        Klass k;
        if (o instanceof KInstance && (k = (ki = (KInstance)o).getKlass()) != null) {
            return k;
        }
        for (Facet f : this.facets) {
            Klass<?> k2 = f.getKlass(o);
            if (k2 == null) continue;
            return k2;
        }
        return Klass.java(o.getClass());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearScripts(Class<? extends AbstractTearOff> clazz) {
        Map<Klass<?>, MetaClass> map = this.classMap;
        synchronized (map) {
            for (MetaClass v : this.classMap.values()) {
                AbstractTearOff t = v.getTearOff(clazz);
                if (t == null) continue;
                t.clearScripts();
            }
        }
    }

    void addStaplerServlet(String servletName, Stapler servlet) {
        if (servletName == null) {
            servletName = "";
        }
        this.servlets.put(servletName, servlet);
    }

    public Stapler getSomeStapler() {
        return (Stapler)((Object)this.servlets.values().iterator().next());
    }

    public static WebApp getCurrent() {
        return Stapler.getCurrent().getWebApp();
    }
}

