/*
 * Decompiled with CFR 0.152.
 */
package org.kohsuke.stapler.bind;

import java.io.IOException;
import java.lang.ref.WeakReference;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import java.util.logging.Logger;
import javax.servlet.ServletException;
import javax.servlet.http.HttpSession;
import org.kohsuke.stapler.Ancestor;
import org.kohsuke.stapler.HttpResponse;
import org.kohsuke.stapler.HttpResponses;
import org.kohsuke.stapler.Stapler;
import org.kohsuke.stapler.StaplerFallback;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.StaplerResponse;
import org.kohsuke.stapler.bind.Bound;
import org.kohsuke.stapler.bind.WithWellKnownURL;

public class BoundObjectTable
implements StaplerFallback {
    public static final String PREFIX = "/$stapler/bound/";
    public static boolean DEBUG_LOGGING = Boolean.getBoolean(BoundObjectTable.class.getName() + ".debugLog");
    private static final Logger LOGGER = Logger.getLogger(BoundObjectTable.class.getName());

    @Override
    public Table getStaplerFallback() {
        return this.resolve(false);
    }

    private Bound bind(Ref ref) {
        return this.resolve(true).add(ref);
    }

    public Bound bind(Object o) {
        return this.bind(new StrongRef(o));
    }

    public Bound bindWeak(Object o) {
        return this.bind(new WeakRef(o));
    }

    public void releaseMe() {
        Ancestor eot = Stapler.getCurrentRequest().findAncestor(BoundObjectTable.class);
        if (eot == null) {
            throw new IllegalStateException("The thread is not handling a request to a abound object");
        }
        String id = eot.getNextToken(0);
        this.resolve(false).release(id);
    }

    private Table resolve(boolean createIfNotExist) {
        HttpSession session = Stapler.getCurrentRequest().getSession(createIfNotExist);
        if (session == null) {
            return null;
        }
        Table t = (Table)session.getAttribute(Table.class.getName());
        if (t == null) {
            if (createIfNotExist) {
                t = new Table();
                session.setAttribute(Table.class.getName(), (Object)t);
            } else {
                return null;
            }
        }
        return t;
    }

    public Table getTable() {
        return this.resolve(true);
    }

    private static class WeakRef
    extends WeakReference
    implements Ref {
        private WeakRef(Object referent) {
            super(referent);
        }
    }

    private static class StrongRef
    implements Ref {
        private final Object o;

        StrongRef(Object o) {
            this.o = o;
        }

        @Override
        public Object get() {
            return this.o;
        }
    }

    static interface Ref {
        public Object get();
    }

    private static final class WellKnownObjectHandle
    extends Bound {
        private final String url;
        private final Object target;

        public WellKnownObjectHandle(String url, Object target) {
            this.url = url;
            this.target = target;
        }

        @Override
        public void release() {
        }

        @Override
        public String getURL() {
            return Stapler.getCurrentRequest().getContextPath() + this.url;
        }

        @Override
        public Object getTarget() {
            return this.target;
        }

        @Override
        public void generateResponse(StaplerRequest req, StaplerResponse rsp, Object node) throws IOException, ServletException {
            rsp.sendRedirect2(this.getURL());
        }
    }

    public static class Table {
        private final Map<String, Ref> entries = new HashMap<String, Ref>();
        private boolean logging;

        private synchronized Bound add(Ref ref) {
            final Object target = ref.get();
            if (target instanceof WithWellKnownURL) {
                WithWellKnownURL w = (WithWellKnownURL)target;
                String url = w.getWellKnownUrl();
                if (!url.startsWith("/")) {
                    LOGGER.warning("WithWellKnownURL.getWellKnownUrl must start with a slash. But we got " + url + " from " + w);
                }
                return new WellKnownObjectHandle(url, w);
            }
            final String id = UUID.randomUUID().toString();
            this.entries.put(id, ref);
            if (this.logging) {
                LOGGER.info(String.format("%s binding %s for %s", this.toString(), target, id));
            }
            return new Bound(){

                @Override
                public void release() {
                    this.release(id);
                }

                @Override
                public String getURL() {
                    return Stapler.getCurrentRequest().getContextPath() + BoundObjectTable.PREFIX + id;
                }

                @Override
                public Object getTarget() {
                    return target;
                }

                @Override
                public void generateResponse(StaplerRequest req, StaplerResponse rsp, Object node) throws IOException, ServletException {
                    rsp.sendRedirect2(this.getURL());
                }
            };
        }

        public Object getDynamic(String id) {
            return this.resolve(id);
        }

        private synchronized Ref release(String id) {
            return this.entries.remove(id);
        }

        private synchronized Object resolve(String id) {
            Ref e = this.entries.get(id);
            if (e == null) {
                if (this.logging) {
                    LOGGER.info(this.toString() + " doesn't have binding for " + id);
                }
                return null;
            }
            Object v = e.get();
            if (v == null) {
                if (this.logging) {
                    LOGGER.warning(this.toString() + " had binding for " + id + " but it got garbage collected");
                }
                this.entries.remove(id);
            }
            return v;
        }

        public HttpResponse doEnableLogging() {
            if (DEBUG_LOGGING) {
                this.logging = true;
                return HttpResponses.text("Logging enabled for this session: " + this + "\n");
            }
            return HttpResponses.forbidden();
        }
    }
}

