/*
 * Decompiled with CFR 0.152.
 */
package org.kohsuke.stapler.export;

import org.kohsuke.stapler.export.ClassAttributeBehaviour;
import org.kohsuke.stapler.export.ExportInterceptor;
import org.kohsuke.stapler.export.Flavor;

public class ExportConfig {
    public boolean prettyPrint;
    private ClassAttributeBehaviour classAttribute = ClassAttributeBehaviour.IF_NEEDED;
    private ExportInterceptor exportInterceptor = ExportInterceptor.DEFAULT;
    private boolean skipIfFail = false;
    private Flavor flavor = Flavor.JSON;

    public boolean isPrettyPrint() {
        return this.prettyPrint;
    }

    public ExportConfig withPrettyPrint(boolean prettyPrint) {
        this.prettyPrint = prettyPrint;
        return this;
    }

    public ClassAttributeBehaviour getClassAttribute() {
        return this.classAttribute;
    }

    public ExportConfig withClassAttribute(ClassAttributeBehaviour cab) {
        if (cab == null) {
            throw new NullPointerException();
        }
        this.classAttribute = cab;
        return this;
    }

    public ExportInterceptor getExportInterceptor() {
        return this.exportInterceptor;
    }

    public ExportConfig withExportInterceptor(ExportInterceptor interceptor) {
        this.exportInterceptor = interceptor;
        return this;
    }

    public ExportConfig withSkipIfFail(boolean skipIfFail) {
        this.skipIfFail = skipIfFail;
        return this;
    }

    public boolean isSkipIfFail() {
        return this.skipIfFail;
    }

    public Flavor getFlavor() {
        return this.flavor;
    }

    public ExportConfig withFlavor(Flavor flavor) {
        this.flavor = flavor;
        return this;
    }
}

