/*
 * Decompiled with CFR 0.152.
 */
package org.kohsuke.stapler.lang;

import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import org.kohsuke.stapler.lang.AnnotatedRef;

public abstract class FieldRef
extends AnnotatedRef {
    public abstract String getName();

    public abstract Object get(Object var1) throws IllegalAccessException;

    public abstract String getQualifiedName();

    public boolean isRoutable() {
        return true;
    }

    public static FieldRef wrap(final Field f) {
        f.setAccessible(true);
        return new FieldRef(){

            @Override
            public <T extends Annotation> T getAnnotation(Class<T> type) {
                return f.getAnnotation(type);
            }

            @Override
            public String getName() {
                return f.getName();
            }

            @Override
            public Object get(Object instance) throws IllegalAccessException {
                return f.get(instance);
            }

            @Override
            public String getQualifiedName() {
                return f.getDeclaringClass().getName() + "." + this.getName();
            }

            @Override
            public boolean isRoutable() {
                return Modifier.isPublic(f.getModifiers());
            }
        };
    }
}

