/*
 * Decompiled with CFR 0.152.
 */
package org.kohsuke.stapler.lang;

import java.net.URL;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import javax.annotation.Nonnull;
import org.kohsuke.stapler.Function;
import org.kohsuke.stapler.lang.FieldRef;
import org.kohsuke.stapler.lang.KlassNavigator;
import org.kohsuke.stapler.lang.MethodRef;

public final class Klass<C> {
    public final C clazz;
    public final KlassNavigator<C> navigator;

    public Klass(C clazz, KlassNavigator<C> navigator) {
        this.clazz = clazz;
        this.navigator = navigator;
    }

    public URL getResource(String resourceName) {
        return this.navigator.getResource(this.clazz, resourceName);
    }

    public Iterable<Klass<?>> getAncestors() {
        return this.navigator.getAncestors(this.clazz);
    }

    public Klass<?> getSuperClass() {
        return this.navigator.getSuperClass(this.clazz);
    }

    public Class toJavaClass() {
        return this.navigator.toJavaClass(this.clazz);
    }

    public List<MethodRef> getDeclaredMethods() {
        return this.navigator.getDeclaredMethods(this.clazz);
    }

    @Nonnull
    public List<FieldRef> getDeclaredFields() {
        return this.navigator.getDeclaredFields(this.clazz);
    }

    public List<FieldRef> getFields() {
        LinkedHashMap<String, FieldRef> fields = new LinkedHashMap<String, FieldRef>();
        for (Klass<?> k = this; k != null; k = k.getSuperClass()) {
            for (FieldRef f : k.getDeclaredFields()) {
                String name = f.getName();
                if (fields.containsKey(name) || !f.isRoutable()) continue;
                fields.put(name, f);
            }
        }
        return new ArrayList<FieldRef>(fields.values());
    }

    @Nonnull
    public List<Function> getFunctions() {
        return this.navigator.getFunctions(this.clazz);
    }

    public boolean isArray() {
        return this.navigator.isArray(this.clazz);
    }

    public Object getArrayElement(Object o, int index) throws IndexOutOfBoundsException {
        return this.navigator.getArrayElement(o, index);
    }

    public boolean isMap() {
        return this.navigator.isMap(this.clazz);
    }

    public Object getMapElement(Object o, String key) {
        return this.navigator.getMapElement(o, key);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Klass that = (Klass)o;
        return this.clazz.equals(that.clazz) && this.navigator.equals(that.navigator);
    }

    public int hashCode() {
        return 31 * this.clazz.hashCode() + this.navigator.hashCode();
    }

    public String toString() {
        return this.clazz.toString();
    }

    public static Klass<Class> java(Class c) {
        return c == null ? null : new Klass<Class>(c, KlassNavigator.JAVA);
    }
}

