/*
 * Decompiled with CFR 0.152.
 */
package org.kohsuke.stapler.lang;

import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import javax.annotation.CheckForNull;
import org.kohsuke.stapler.lang.AnnotatedRef;

public abstract class MethodRef
extends AnnotatedRef {
    public boolean isRoutable() {
        return true;
    }

    @CheckForNull
    public String getName() {
        return null;
    }

    public abstract Object invoke(Object var1, Object ... var2) throws InvocationTargetException, IllegalAccessException;

    public static MethodRef wrap(final Method m) {
        m.setAccessible(true);
        return new MethodRef(){

            @Override
            public <T extends Annotation> T getAnnotation(Class<T> type) {
                return m.getAnnotation(type);
            }

            @Override
            public boolean isRoutable() {
                if (m.isBridge()) {
                    return false;
                }
                return (m.getModifiers() & 1) != 0;
            }

            @Override
            public String getName() {
                return m.getName();
            }

            @Override
            public Object invoke(Object _this, Object ... args) throws InvocationTargetException, IllegalAccessException {
                return m.invoke(_this, args);
            }
        };
    }
}

