/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.workflow.cps;

import com.cloudbees.groovy.cps.Block;
import com.cloudbees.groovy.cps.Continuable;
import com.cloudbees.groovy.cps.Env;
import com.cloudbees.groovy.cps.Envs;
import com.cloudbees.groovy.cps.Outcome;
import com.cloudbees.groovy.cps.impl.ConstantBlock;
import com.cloudbees.groovy.cps.impl.ThrowBlock;
import com.cloudbees.groovy.cps.sandbox.DefaultInvoker;
import com.cloudbees.groovy.cps.sandbox.Invoker;
import com.cloudbees.groovy.cps.sandbox.SandboxInvoker;
import com.cloudbees.jenkins.support.api.Component;
import com.cloudbees.jenkins.support.api.Container;
import com.cloudbees.jenkins.support.api.Content;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.util.concurrent.FutureCallback;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.SettableFuture;
import com.thoughtworks.xstream.XStream;
import com.thoughtworks.xstream.converters.Converter;
import com.thoughtworks.xstream.converters.MarshallingContext;
import com.thoughtworks.xstream.converters.UnmarshallingContext;
import com.thoughtworks.xstream.converters.reflection.ReflectionProvider;
import com.thoughtworks.xstream.io.ExtendedHierarchicalStreamWriterHelper;
import com.thoughtworks.xstream.io.HierarchicalStreamReader;
import com.thoughtworks.xstream.io.HierarchicalStreamWriter;
import com.thoughtworks.xstream.mapper.Mapper;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import groovy.lang.GroovyClassLoader;
import groovy.lang.GroovyShell;
import groovy.lang.Script;
import hudson.AbortException;
import hudson.BulkChange;
import hudson.Extension;
import hudson.ExtensionList;
import hudson.init.Terminator;
import hudson.model.Action;
import hudson.model.Item;
import hudson.model.Job;
import hudson.model.Queue;
import hudson.model.Result;
import hudson.model.Run;
import hudson.model.Saveable;
import hudson.model.User;
import hudson.security.ACL;
import hudson.security.AccessControlled;
import hudson.security.Permission;
import hudson.util.Iterators;
import java.beans.Introspector;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.NavigableMap;
import java.util.Set;
import java.util.Stack;
import java.util.TreeMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.GuardedBy;
import jenkins.model.CauseOfInterruption;
import jenkins.model.Jenkins;
import org.acegisecurity.Authentication;
import org.acegisecurity.userdetails.UsernameNotFoundException;
import org.apache.commons.io.Charsets;
import org.codehaus.groovy.GroovyBugError;
import org.jboss.marshalling.Unmarshaller;
import org.jboss.marshalling.reflect.SerializableClassRegistry;
import org.jenkinsci.plugins.workflow.actions.ErrorAction;
import org.jenkinsci.plugins.workflow.cps.CpsGroovyShell;
import org.jenkinsci.plugins.workflow.cps.CpsGroovyShellFactory;
import org.jenkinsci.plugins.workflow.cps.CpsScript;
import org.jenkinsci.plugins.workflow.cps.CpsThread;
import org.jenkinsci.plugins.workflow.cps.CpsThreadDump;
import org.jenkinsci.plugins.workflow.cps.CpsThreadGroup;
import org.jenkinsci.plugins.workflow.cps.FlowHead;
import org.jenkinsci.plugins.workflow.flow.BlockableResume;
import org.jenkinsci.plugins.workflow.flow.FlowDurabilityHint;
import org.jenkinsci.plugins.workflow.flow.FlowExecution;
import org.jenkinsci.plugins.workflow.flow.FlowExecutionList;
import org.jenkinsci.plugins.workflow.flow.FlowExecutionOwner;
import org.jenkinsci.plugins.workflow.flow.GraphListener;
import org.jenkinsci.plugins.workflow.graph.BlockStartNode;
import org.jenkinsci.plugins.workflow.graph.FlowEndNode;
import org.jenkinsci.plugins.workflow.graph.FlowNode;
import org.jenkinsci.plugins.workflow.graph.FlowStartNode;
import org.jenkinsci.plugins.workflow.steps.FlowInterruptedException;
import org.jenkinsci.plugins.workflow.steps.StepContext;
import org.jenkinsci.plugins.workflow.steps.StepExecution;
import org.jenkinsci.plugins.workflow.support.concurrent.Futures;
import org.jenkinsci.plugins.workflow.support.concurrent.Timeout;
import org.jenkinsci.plugins.workflow.support.pickles.serialization.RiverReader;
import org.jenkinsci.plugins.workflow.support.storage.BulkFlowNodeStorage;
import org.jenkinsci.plugins.workflow.support.storage.FlowNodeStorage;
import org.jenkinsci.plugins.workflow.support.storage.SimpleXStreamFlowNodeStorage;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.DoNotUse;
import org.kohsuke.accmod.restrictions.NoExternalUse;

public class CpsFlowExecution
extends FlowExecution
implements BlockableResume {
    private final String script;
    Map<String, String> loadedScripts = new HashMap<String, String>();
    private final boolean sandbox;
    private transient FlowExecutionOwner owner;
    public volatile transient ListenableFuture<CpsThreadGroup> programPromise;
    private volatile transient Collection<ListenableFuture<?>> pickleFutures;
    transient TimingFlowNodeStorage storage;
    @CheckForNull
    private final String user;
    Boolean persistedClean = null;
    boolean resumeBlocked = false;
    private String storageDir = null;
    @GuardedBy(value="this")
    Stack<BlockStartNode> startNodes = new Stack();
    @SuppressFBWarnings(value={"IS_FIELD_NOT_GUARDED", "IS2_INCONSISTENT_SYNC"})
    private transient List<String> startNodesSerial;
    @GuardedBy(value="this")
    NavigableMap<Integer, FlowHead> heads = new TreeMap<Integer, FlowHead>();
    @SuppressFBWarnings(value={"IS_FIELD_NOT_GUARDED", "IS2_INCONSISTENT_SYNC"})
    private transient Map<Integer, String> headsSerial;
    private final AtomicInteger iota = new AtomicInteger();
    private static final int ID_LOOKUP_TABLE_SIZE = 500;
    private static final String[] ID_LOOKUP_TABLE = new String[500];
    private transient List<GraphListener> listeners;
    private Result result = Result.SUCCESS;
    boolean done;
    private transient CpsGroovyShell shell;
    private transient CpsGroovyShell trusted;
    private transient Class<?> scriptClass;
    final transient List<Action> flowStartNodeActions = new ArrayList<Action>();
    @CheckForNull
    @GuardedBy(value="this")
    Map<String, Long> timings;
    static final Logger TIMING_LOGGER;
    private static final Logger LOGGER;
    static final ThreadLocal<CpsFlowExecution> PROGRAM_STATE_SERIALIZATION;

    public boolean isResumeBlocked() {
        return this.resumeBlocked;
    }

    public void setResumeBlocked(boolean resumeBlocked) {
        if (this.resumeBlocked != resumeBlocked) {
            this.resumeBlocked = resumeBlocked;
        }
    }

    @Deprecated
    public CpsFlowExecution(String script, FlowExecutionOwner owner) throws IOException {
        this(script, false, owner);
    }

    public CpsFlowExecution(@Nonnull String script, boolean sandbox, @Nonnull FlowExecutionOwner owner, @CheckForNull FlowDurabilityHint durabilityHint) throws IOException {
        this.owner = owner;
        this.script = script;
        this.sandbox = sandbox;
        this.durabilityHint = durabilityHint;
        Authentication auth = Jenkins.getAuthentication();
        this.user = auth.equals(ACL.SYSTEM) ? null : auth.getName();
        this.storage = this.createStorage();
        this.storage.setAvoidAtomicWrite(!this.getDurabilityHint().isAtomicWrite());
    }

    public CpsFlowExecution(String script, boolean sandbox, FlowExecutionOwner owner) throws IOException {
        this(script, sandbox, owner, null);
    }

    private Object readResolve() {
        if (this.loadedScripts == null) {
            this.loadedScripts = new HashMap<String, String>();
        }
        return this;
    }

    Timing time(TimingKind kind) {
        return new Timing(kind);
    }

    synchronized void logTimings() {
        if (this.timings != null && TIMING_LOGGER.isLoggable(Level.FINE)) {
            TreeMap<String, String> formatted = new TreeMap<String, String>();
            for (Map.Entry<String, Long> entry : this.timings.entrySet()) {
                formatted.put(entry.getKey(), entry.getValue() / 1000L / 1000L + "ms");
            }
            TIMING_LOGGER.log(Level.FINE, "timings for {0}: {1}", new Object[]{this.owner, formatted});
        }
    }

    public GroovyShell getShell() {
        return this.shell;
    }

    public GroovyShell getTrustedShell() {
        return this.trusted;
    }

    public FlowNodeStorage getStorage() {
        return this.storage;
    }

    public String getScript() {
        return this.script;
    }

    public Map<String, String> getLoadedScripts() {
        return ImmutableMap.copyOf(this.loadedScripts);
    }

    public boolean isSandbox() {
        return this.sandbox;
    }

    public FlowExecutionOwner getOwner() {
        return this.owner;
    }

    private TimingFlowNodeStorage createStorage() throws IOException {
        FlowDurabilityHint hint = this.getDurabilityHint();
        SimpleXStreamFlowNodeStorage wrappedStorage = hint.isPersistWithEveryStep() ? new SimpleXStreamFlowNodeStorage((FlowExecution)this, this.getStorageDir()) : new BulkFlowNodeStorage((FlowExecution)this, this.getStorageDir());
        return new TimingFlowNodeStorage((FlowNodeStorage)wrappedStorage);
    }

    public File getStorageDir() throws IOException {
        return new File(this.owner.getRootDir(), this.storageDir != null ? this.storageDir : "workflow");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start() throws IOException {
        SettableFuture f;
        final CpsScript s = this.parseScript();
        this.scriptClass = ((Object)((Object)s)).getClass();
        s.$initialize();
        final FlowHead h = new FlowHead(this);
        CpsFlowExecution cpsFlowExecution = this;
        synchronized (cpsFlowExecution) {
            this.heads.put(h.getId(), h);
        }
        h.newStartNode(new FlowStartNode((FlowExecution)this, this.iotaStr()));
        final CpsThreadGroup g = new CpsThreadGroup(this);
        g.register((Script)s);
        this.programPromise = f = SettableFuture.create();
        this.saveOwner();
        g.runner.submit(new Runnable(){

            @Override
            public void run() {
                CpsThread t = g.addThread(new Continuable((Script)s, this.createInitialEnv()), h, null);
                t.resume(new Outcome(null, null));
                f.set((Object)g);
            }

            private Env createInitialEnv() {
                return Envs.empty((Invoker)(CpsFlowExecution.this.isSandbox() ? new SandboxInvoker() : new DefaultInvoker()));
            }
        });
    }

    private CpsScript parseScript() throws IOException {
        this.trusted = new CpsGroovyShellFactory(this).forTrusted().build();
        this.shell = new CpsGroovyShellFactory(this).withParent(this.trusted).build();
        CpsScript s = (CpsScript)this.shell.reparse("WorkflowScript", this.script);
        for (Map.Entry<String, String> e : this.loadedScripts.entrySet()) {
            this.shell.reparse(e.getKey(), e.getValue());
        }
        s.execution = this;
        return s;
    }

    @Restricted(value={NoExternalUse.class})
    public String iotaStr() {
        int iotaVal = this.iota();
        if (iotaVal > 0 && iotaVal < 500) {
            return ID_LOOKUP_TABLE[iotaVal];
        }
        return String.valueOf(iotaVal).intern();
    }

    @Restricted(value={NoExternalUse.class})
    public int iota() {
        return this.iota.incrementAndGet();
    }

    int approximateNodeCount() {
        return this.iota.get();
    }

    private synchronized String getHeadsAsString() {
        NavigableMap<Integer, FlowHead> myHeads = this.heads;
        if (myHeads == null) {
            return "null-heads";
        }
        if (myHeads.size() == 0) {
            return "empty-heads";
        }
        return myHeads.entrySet().stream().map(h -> h.getKey() + "::" + h.getValue()).collect(Collectors.joining(","));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @GuardedBy(value="this")
    void createPlaceholderNodes(Throwable failureReason) throws Exception {
        CpsFlowExecution cpsFlowExecution = this;
        synchronized (cpsFlowExecution) {
            Queue.Executable ex2;
            this.done = true;
            if (this.owner != null && (ex2 = this.owner.getExecutable()) instanceof Run) {
                Result res = ((Run)ex2).getResult();
                this.setResult(res != null ? res : Result.FAILURE);
            }
            this.programPromise = Futures.immediateFailedFuture((Throwable)new IllegalStateException("Failed loading heads", failureReason));
            LOGGER.log(Level.INFO, "Creating placeholder flownodes for execution: " + (Object)((Object)this));
            if (this.owner != null) {
                try {
                    this.owner.getListener().getLogger().println("Creating placeholder flownodes because failed loading originals.");
                }
                catch (Exception ex2) {
                    // empty catch block
                }
            }
            this.storageDir = this.storageDir != null ? this.storageDir + "-fallback" : "workflow-fallback";
            this.storage = this.createStorage();
            this.startNodes = new Stack();
            FlowHead head = new FlowHead(this);
            this.heads = new TreeMap<Integer, FlowHead>();
            this.heads.put(head.getId(), head);
            FlowStartNode start = new FlowStartNode((FlowExecution)this, this.iotaStr());
            head.newStartNode(start);
            FlowEndNode end = new FlowEndNode((FlowExecution)this, this.iotaStr(), (FlowStartNode)this.startNodes.pop(), this.result, this.getCurrentHeads().toArray(new FlowNode[0]));
            end.addAction((Action)new ErrorAction(failureReason));
            head.setNewHead((FlowNode)end);
        }
        this.saveOwner();
    }

    @SuppressFBWarnings(value={"IS2_INCONSISTENT_SYNC"}, justification="Storage does not actually NEED to be synchronized but the rest does.")
    protected synchronized void initializeStorage() throws IOException {
        this.storage = this.createStorage();
        this.heads = new TreeMap<Integer, FlowHead>();
        for (Map.Entry<Integer, String> entry : this.headsSerial.entrySet()) {
            FlowHead h = new FlowHead(this, entry.getKey());
            FlowNode n = this.storage.getNode(entry.getValue());
            if (n != null) {
                h.setForDeserialize(this.storage.getNode(entry.getValue()));
                this.heads.put(h.getId(), h);
                continue;
            }
            throw new IOException("Tried to load head FlowNodes for execution " + this.owner + " but FlowNode was not found in storage for head id:FlowNodeId " + entry.getKey() + ":" + entry.getValue());
        }
        this.headsSerial = null;
        this.startNodes = new Stack();
        for (String id : this.startNodesSerial) {
            FlowNode node = this.storage.getNode(id);
            if (node != null) {
                this.startNodes.add((BlockStartNode)this.storage.getNode(id));
                continue;
            }
            throw new IOException("Tried to load startNode FlowNodes for execution " + this.owner + " but FlowNode was not found in storage for FlowNode Id " + id);
        }
        this.startNodesSerial = null;
    }

    public boolean canResume() {
        if (this.isResumeBlocked()) {
            return false;
        }
        if (this.persistedClean != null) {
            return this.persistedClean;
        }
        FlowDurabilityHint hint = this.getDurabilityHint();
        return hint.isPersistWithEveryStep();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SuppressFBWarnings(value={"RC_REF_COMPARISON_BAD_PRACTICE_BOOLEAN"}, justification="We want to explicitly check for boolean not-null and true")
    public void onLoad(FlowExecutionOwner owner) throws IOException {
        block15: {
            this.owner = owner;
            try {
                try {
                    this.initializeStorage();
                }
                catch (Exception ex) {
                    LOGGER.log(Level.WARNING, "Error initializing storage and loading nodes, will try to create placeholders for: " + (Object)((Object)this), ex);
                    this.createPlaceholderNodes(ex);
                    return;
                }
            }
            catch (Exception ex) {
                this.done = true;
                this.programPromise = Futures.immediateFailedFuture((Throwable)ex);
                throw new IOException("Failed to even create placeholder nodes for execution", ex);
            }
            try {
                if (this.isComplete()) {
                    if (this.done == Boolean.TRUE && !super.isComplete()) {
                        LOGGER.log(Level.INFO, "Completed flow without FlowEndNode: " + (Object)((Object)this) + " heads:" + this.getHeadsAsString());
                    }
                    if (super.isComplete() && this.done != Boolean.TRUE) {
                        LOGGER.log(Level.FINE, "Flow has FlowEndNode, but is not marked as done, fixing this for" + (Object)((Object)this));
                        this.done = true;
                        this.saveOwner();
                    }
                    break block15;
                }
                if (this.canResume()) {
                    this.loadProgramAsync(this.getProgramDataFile());
                    break block15;
                }
                LOGGER.log(Level.WARNING, "Pipeline state not properly persisted, cannot resume " + owner.getUrl());
                throw new IOException("Cannot resume build -- was not cleanly saved when Jenkins shut down.");
            }
            catch (Exception e) {
                SettableFuture p;
                this.programPromise = p = SettableFuture.create();
                this.loadProgramFailed(e, (SettableFuture<CpsThreadGroup>)p);
            }
            finally {
                if (this.programPromise == null) {
                    this.programPromise = Futures.immediateFailedFuture((Throwable)new IllegalStateException("completed or broken execution"));
                }
            }
        }
    }

    public void loadProgramAsync(File programDataFile) {
        SettableFuture result;
        this.programPromise = result = SettableFuture.create();
        try {
            this.scriptClass = ((Object)((Object)this.parseScript())).getClass();
            final RiverReader r = new RiverReader(programDataFile, this.scriptClass.getClassLoader(), this.owner);
            this.pickleFutures = new ArrayList();
            Futures.addCallback((ListenableFuture)r.restorePickles(this.pickleFutures), (FutureCallback)new FutureCallback<Unmarshaller>(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void onSuccess(Unmarshaller u) {
                    CpsFlowExecution.this.pickleFutures = null;
                    try {
                        CpsFlowExecution old = PROGRAM_STATE_SERIALIZATION.get();
                        PROGRAM_STATE_SERIALIZATION.set(CpsFlowExecution.this);
                        try {
                            CpsThreadGroup g = (CpsThreadGroup)u.readObject();
                            result.set((Object)g);
                            try {
                                if (g.isPaused()) {
                                    CpsFlowExecution.this.owner.getListener().getLogger().println("Still paused");
                                } else {
                                    CpsFlowExecution.this.owner.getListener().getLogger().println("Ready to run at " + new Date());
                                    g.scheduleRun();
                                }
                            }
                            catch (IOException x) {
                                LOGGER.log(Level.WARNING, null, x);
                            }
                            PROGRAM_STATE_SERIALIZATION.set(old);
                        }
                        catch (Throwable t) {
                            try {
                                this.onFailure(t);
                            }
                            catch (Throwable throwable) {
                                throw throwable;
                            }
                            finally {
                                PROGRAM_STATE_SERIALIZATION.set(old);
                            }
                        }
                    }
                    finally {
                        r.close();
                    }
                }

                public void onFailure(Throwable t) {
                    try {
                        CpsFlowExecution.this.loadProgramFailed(t, (SettableFuture<CpsThreadGroup>)result);
                    }
                    finally {
                        r.close();
                    }
                }
            });
        }
        catch (Exception | GroovyBugError e) {
            this.loadProgramFailed(e, (SettableFuture<CpsThreadGroup>)result);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadProgramFailed(final Throwable problem, SettableFuture<CpsThreadGroup> promise) {
        FlowHead head;
        CpsFlowExecution cpsFlowExecution = this;
        synchronized (cpsFlowExecution) {
            head = this.heads == null || this.heads.isEmpty() ? null : this.getFirstHead();
        }
        if (head == null) {
            head = new FlowHead(this);
            try {
                head.newStartNode(new FlowStartNode((FlowExecution)this, this.iotaStr()));
            }
            catch (IOException e) {
                LOGGER.log(Level.FINE, "Failed to persist", e);
            }
        }
        CpsThreadGroup g = new CpsThreadGroup(this);
        final FlowHead head_ = head;
        promise.set((Object)g);
        this.runInCpsVmThread(new FutureCallback<CpsThreadGroup>(){

            public void onSuccess(CpsThreadGroup g) {
                CpsThread t = g.addThread(new Continuable((Block)new ThrowBlock((Block)new ConstantBlock((Object)(problem instanceof AbortException ? problem : new IOException("Failed to load build state", problem))))), head_, null);
                t.resume(new Outcome(null, null));
            }

            public void onFailure(Throwable t) {
                LOGGER.log(Level.WARNING, "Failed to set program failure on " + CpsFlowExecution.this.owner, t);
                CpsFlowExecution.this.croak(t);
            }
        });
    }

    void croak(Throwable t) {
        this.setResult(Result.FAILURE);
        this.onProgramEnd(new Outcome(null, t));
        this.cleanUpHeap();
        try {
            this.saveOwner();
        }
        catch (Exception ex) {
            LOGGER.log(Level.WARNING, "Failed to persist WorkflowRun after noting a serious failure for run: " + this.owner, ex);
        }
    }

    File getProgramDataFile() throws IOException {
        return new File(this.owner.getRootDir(), "program.dat");
    }

    void runInCpsVmThread(final FutureCallback<CpsThreadGroup> callback) {
        if (this.programPromise == null) {
            throw new IllegalStateException("build storage unloadable, or build already finished");
        }
        Futures.addCallback(this.programPromise, (FutureCallback)new FutureCallback<CpsThreadGroup>(){
            final Exception source = new Exception();

            public void onSuccess(final CpsThreadGroup g) {
                g.runner.submit(new Runnable(){

                    @Override
                    public void run() {
                        callback.onSuccess((Object)g);
                    }
                });
            }

            public void onFailure(Throwable t) {
                callback.onFailure(t);
            }
        });
    }

    public boolean blocksRestart() {
        CpsThreadGroup g;
        if (this.programPromise == null || !this.programPromise.isDone()) {
            return true;
        }
        try {
            g = (CpsThreadGroup)this.programPromise.get();
        }
        catch (Exception x) {
            LOGGER.log(Level.FINE, "Not blocking restart due to exception in ProgramPromise: " + (Object)((Object)this), x);
            return false;
        }
        return g.busy;
    }

    public void waitForSuspension() throws InterruptedException, ExecutionException {
        if (this.programPromise == null) {
            return;
        }
        CpsThreadGroup g = (CpsThreadGroup)this.programPromise.get();
        g.scheduleRun().get();
    }

    @CheckForNull
    public synchronized FlowHead getFlowHead(int id) {
        if (this.heads == null) {
            LOGGER.log(Level.WARNING, null, new IllegalStateException("List of flow heads unset for " + (Object)((Object)this)));
            return null;
        }
        return (FlowHead)this.heads.get(id);
    }

    public synchronized List<FlowNode> getCurrentHeads() {
        if (this.heads == null) {
            LOGGER.log(Level.WARNING, null, new IllegalStateException("List of flow heads unset for " + (Object)((Object)this)));
            return Collections.emptyList();
        }
        ArrayList<FlowNode> r = new ArrayList<FlowNode>(this.heads.size());
        for (FlowHead h : this.heads.values()) {
            r.add(h.get());
        }
        return r;
    }

    public ListenableFuture<List<StepExecution>> getCurrentExecutions(final boolean innerMostOnly) {
        if (this.programPromise == null || this.isComplete()) {
            return Futures.immediateFuture(Collections.emptyList());
        }
        final SettableFuture r = SettableFuture.create();
        this.runInCpsVmThread(new FutureCallback<CpsThreadGroup>(){

            public void onSuccess(CpsThreadGroup g) {
                if (innerMostOnly) {
                    LinkedHashMap<FlowHead, StepExecution> m = new LinkedHashMap<FlowHead, StepExecution>();
                    for (CpsThread t : g.threads.values()) {
                        StepExecution e = t.getStep();
                        if (e == null) continue;
                        m.put(t.head, e);
                    }
                    r.set((Object)ImmutableList.copyOf(m.values()));
                } else {
                    ArrayList<StepExecution> es = new ArrayList<StepExecution>();
                    for (CpsThread t : g.threads.values()) {
                        StepExecution e = t.getStep();
                        if (e == null) continue;
                        es.add(e);
                    }
                    r.set(Collections.unmodifiableList(es));
                }
            }

            public void onFailure(Throwable t) {
                r.setException(t);
            }
        });
        return r;
    }

    public CpsThreadDump getThreadDump() {
        if (this.programPromise == null || this.isComplete()) {
            return CpsThreadDump.EMPTY;
        }
        if (!this.programPromise.isDone()) {
            Collection<ListenableFuture<?>> _pickleFutures = this.pickleFutures;
            if (_pickleFutures != null) {
                StringBuilder b = new StringBuilder("Program is not yet loaded");
                for (ListenableFuture<?> pickleFuture : _pickleFutures) {
                    b.append("\n\t").append(pickleFuture);
                    if (pickleFuture.isCancelled()) {
                        b.append(" (cancelled)");
                    }
                    if (!pickleFuture.isDone()) continue;
                    b.append(" (complete)");
                }
                return CpsThreadDump.fromText(b.toString());
            }
            return CpsThreadDump.fromText("Program state is unknown");
        }
        try {
            return ((CpsThreadGroup)this.programPromise.get()).getThreadDump();
        }
        catch (InterruptedException e) {
            throw new AssertionError();
        }
        catch (ExecutionException e) {
            return CpsThreadDump.from(new Exception("Failed to resurrect program state", e));
        }
    }

    public synchronized boolean isCurrentHead(FlowNode n) {
        if (this.heads == null) {
            LOGGER.log(Level.WARNING, null, new IllegalStateException("List of flow heads unset for " + (Object)((Object)this)));
            return false;
        }
        for (FlowHead h : this.heads.values()) {
            if (!h.get().equals((Object)n)) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addHead(FlowHead h) {
        CpsFlowExecution cpsFlowExecution = this;
        synchronized (cpsFlowExecution) {
            this.heads.put(h.getId(), h);
        }
        this.saveExecutionIfDurable();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeHead(FlowHead h) {
        CpsFlowExecution cpsFlowExecution = this;
        synchronized (cpsFlowExecution) {
            this.heads.remove(h.getId());
        }
        this.saveExecutionIfDurable();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void subsumeHead(FlowNode n) {
        ArrayList _heads;
        CpsFlowExecution cpsFlowExecution = this;
        synchronized (cpsFlowExecution) {
            _heads = new ArrayList(this.heads.values());
        }
        for (FlowHead h : _heads) {
            if (h.get() != n) continue;
            h.remove();
            this.saveExecutionIfDurable();
            return;
        }
    }

    public void addListener(GraphListener listener) {
        if (this.listeners == null) {
            this.listeners = new CopyOnWriteArrayList<GraphListener>();
        }
        this.listeners.add(listener);
    }

    public void removeListener(GraphListener listener) {
        if (this.listeners != null) {
            this.listeners.remove(listener);
        }
    }

    public void interrupt(Result result, CauseOfInterruption ... causes) throws IOException, InterruptedException {
        this.setResult(result);
        LOGGER.log(Level.FINE, "Interrupting {0} as {1}", new Object[]{this.owner, result});
        final FlowInterruptedException ex = new FlowInterruptedException(result, causes);
        this.runInCpsVmThread(new FutureCallback<CpsThreadGroup>(){

            public void onSuccess(CpsThreadGroup g) {
                LinkedHashMap<FlowHead, CpsThread> m = new LinkedHashMap<FlowHead, CpsThread>();
                for (CpsThread t : g.threads.values()) {
                    m.put(t.head, t);
                }
                for (CpsThread t : Iterators.reverse((List)ImmutableList.copyOf(m.values()))) {
                    try {
                        t.stop((Throwable)ex);
                    }
                    catch (Exception x) {
                        LOGGER.log(Level.WARNING, "Failed to abort " + CpsFlowExecution.this.owner, x);
                    }
                }
            }

            public void onFailure(Throwable t) {
                LOGGER.log(Level.WARNING, "Failed to interrupt steps in " + CpsFlowExecution.this.owner, t);
            }
        });
        Collection<ListenableFuture<?>> futures = this.pickleFutures;
        if (futures != null) {
            LOGGER.log(Level.FINE, "We are still rehydrating pickles in {0}", this.owner);
            for (ListenableFuture<?> future : futures) {
                if (future.isDone()) continue;
                LOGGER.log(Level.FINE, "Trying to cancel {0} for {1}", new Object[]{future, this.owner});
                if (future.cancel(true)) continue;
                LOGGER.log(Level.WARNING, "Failed to cancel {0} for {1}", new Object[]{future, this.owner});
            }
        }
    }

    public FlowNode getNode(String id) throws IOException {
        return this.storage.getNode(id);
    }

    public void setResult(Result v) {
        this.result = this.result.combine(v);
    }

    public Result getResult() {
        return this.result;
    }

    public List<Action> loadActions(FlowNode node) throws IOException {
        return this.storage.loadActions(node);
    }

    public void saveActions(FlowNode node, List<Action> actions) throws IOException {
        this.storage.saveActions(node, actions);
    }

    void cacheNode(@Nonnull FlowNode node) {
        try {
            this.getStorage().storeNode(node, true);
        }
        catch (IOException ioe) {
            LOGGER.log(Level.WARNING, "Attempt to persist triggered IOException for node " + node.getId(), ioe);
        }
    }

    public static void maybeAutoPersistNode(@Nonnull FlowNode node) {
        try {
            FlowExecution exec = node.getExecution();
            if (exec instanceof CpsFlowExecution && exec.getDurabilityHint().isPersistWithEveryStep()) {
                FlowNodeStorage exc = ((CpsFlowExecution)exec).getStorage();
                exc.autopersist(node);
            }
        }
        catch (IOException ioe) {
            LOGGER.log(Level.WARNING, "Attempt to persist triggered IOException for node " + node.getId(), ioe);
        }
    }

    @SuppressFBWarnings(value={"RC_REF_COMPARISON_BAD_PRACTICE_BOOLEAN"}, justification="We want to explicitly check for boolean not-null and true")
    public boolean isComplete() {
        return this.done || super.isComplete();
    }

    synchronized void onProgramEnd(Outcome outcome) {
        FlowEndNode head = new FlowEndNode((FlowExecution)this, this.iotaStr(), (FlowStartNode)this.startNodes.pop(), this.result, this.getCurrentHeads().toArray(new FlowNode[0]));
        if (outcome.isFailure()) {
            head.addAction((Action)new ErrorAction(outcome.getAbnormal()));
        }
        try {
            if (this.heads != null) {
                FlowHead first = this.getFirstHead();
                first.setNewHead((FlowNode)head);
                this.done = true;
                this.heads.clear();
                this.heads.put(first.getId(), first);
                String tempIotaStr = Integer.toString(this.iota.get());
                FlowHead lastHead = (FlowHead)this.heads.get(first.getId());
                if (lastHead == null || lastHead.get() == null || !lastHead.get().getId().equals(tempIotaStr)) {
                    LOGGER.log(Level.WARNING, "Invalid final head for execution " + this.owner + " with head: " + lastHead);
                }
            }
        }
        catch (Exception ex) {
            this.done = true;
            LOGGER.log(Level.WARNING, "Error trying to end execution " + (Object)((Object)this), ex);
        }
        try {
            this.getStorage().flush();
        }
        catch (IOException ioe) {
            LOGGER.log(Level.WARNING, "Error flushing FlowNodeStorage to disk at end of run", ioe);
        }
        this.persistedClean = Boolean.TRUE;
    }

    void cleanUpHeap() {
        LOGGER.log(Level.FINE, "cleanUpHeap on {0}", this.owner);
        this.shell = null;
        this.trusted = null;
        if (this.scriptClass != null) {
            try {
                CpsFlowExecution.cleanUpLoader(this.scriptClass.getClassLoader(), new HashSet<ClassLoader>(), new HashSet());
            }
            catch (Exception x) {
                LOGGER.log(Level.WARNING, "failed to clean up memory from " + this.owner, x);
            }
            this.scriptClass = null;
        } else {
            LOGGER.fine("no scriptClass");
        }
    }

    private static void cleanUpLoader(ClassLoader loader, Set<ClassLoader> encounteredLoaders, Set<Class<?>> encounteredClasses) throws Exception {
        if (loader instanceof CpsGroovyShell.TimingLoader) {
            CpsFlowExecution.cleanUpLoader(loader.getParent(), encounteredLoaders, encounteredClasses);
            return;
        }
        if (!(loader instanceof GroovyClassLoader)) {
            LOGGER.log(Level.FINER, "ignoring {0}", loader);
            return;
        }
        if (!encounteredLoaders.add(loader)) {
            return;
        }
        CpsFlowExecution.cleanUpLoader(loader.getParent(), encounteredLoaders, encounteredClasses);
        LOGGER.log(Level.FINER, "found {0}", String.valueOf(loader));
        SerializableClassRegistry.getInstance().release(loader);
        CpsFlowExecution.cleanUpGlobalClassValue(loader);
        GroovyClassLoader gcl = (GroovyClassLoader)loader;
        for (Class clazz : gcl.getLoadedClasses()) {
            if (!encounteredClasses.add(clazz)) continue;
            LOGGER.log(Level.FINER, "found {0}", clazz.getName());
            Introspector.flushFromCaches(clazz);
            CpsFlowExecution.cleanUpGlobalClassSet(clazz);
            CpsFlowExecution.cleanUpObjectStreamClassCaches(clazz);
            CpsFlowExecution.cleanUpLoader(clazz.getClassLoader(), encounteredLoaders, encounteredClasses);
        }
        gcl.clearCache();
    }

    private static void cleanUpGlobalClassValue(@Nonnull ClassLoader loader) throws Exception {
        Class<?> classInfoC = Class.forName("org.codehaus.groovy.reflection.ClassInfo");
        Field globalClassValueF = classInfoC.getDeclaredField("globalClassValue");
        globalClassValueF.setAccessible(true);
        Object globalClassValue = globalClassValueF.get(null);
        Class<?> groovyClassValuePreJava7C = Class.forName("org.codehaus.groovy.reflection.GroovyClassValuePreJava7");
        if (!groovyClassValuePreJava7C.isInstance(globalClassValue)) {
            return;
        }
        Field mapF = groovyClassValuePreJava7C.getDeclaredField("map");
        mapF.setAccessible(true);
        Object map = mapF.get(globalClassValue);
        Class<?> groovyClassValuePreJava7Map = Class.forName("org.codehaus.groovy.reflection.GroovyClassValuePreJava7$GroovyClassValuePreJava7Map");
        Collection entries = (Collection)groovyClassValuePreJava7Map.getMethod("values", new Class[0]).invoke(map, new Object[0]);
        Method removeM = groovyClassValuePreJava7Map.getMethod("remove", Object.class);
        Class<?> entryC = Class.forName("org.codehaus.groovy.util.AbstractConcurrentMapBase$Entry");
        Method getValueM = entryC.getMethod("getValue", new Class[0]);
        ArrayList<Object> toRemove = new ArrayList<Object>();
        try {
            Field classRefF = classInfoC.getDeclaredField("classRef");
            classRefF.setAccessible(true);
            for (Object e : entries) {
                Object value = getValueM.invoke(e, new Object[0]);
                toRemove.add(((WeakReference)classRefF.get(value)).get());
            }
        }
        catch (NoSuchFieldException x) {
            Field klazzF = classInfoC.getDeclaredField("klazz");
            klazzF.setAccessible(true);
            for (Object entry : entries) {
                Object value = getValueM.invoke(entry, new Object[0]);
                toRemove.add((Class)klazzF.get(value));
            }
        }
        Iterator it = toRemove.iterator();
        while (it.hasNext()) {
            Class klazz = (Class)it.next();
            ClassLoader classLoader = klazz.getClassLoader();
            if (classLoader == loader) continue;
            it.remove();
            LOGGER.log(Level.FINEST, "ignoring {0} with loader {1}", new Object[]{klazz, String.valueOf(classLoader)});
        }
        LOGGER.log(Level.FINE, "cleaning up {0} associated with {1}", new Object[]{((Object)toRemove).toString(), loader.toString()});
        for (Class clazz : toRemove) {
            removeM.invoke(map, clazz);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void cleanUpGlobalClassSet(@Nonnull Class<?> clazz) throws Exception {
        Class<?> classInfoC = Class.forName("org.codehaus.groovy.reflection.ClassInfo");
        Field globalClassSetF = classInfoC.getDeclaredField("globalClassSet");
        globalClassSetF.setAccessible(true);
        Object globalClassSet = globalClassSetF.get(null);
        try {
            classInfoC.getDeclaredField("classRef");
            return;
        }
        catch (NoSuchFieldException noSuchFieldException) {
            Field itemsF = globalClassSet.getClass().getDeclaredField("items");
            itemsF.setAccessible(true);
            Object items = itemsF.get(globalClassSet);
            Method iteratorM = items.getClass().getMethod("iterator", new Class[0]);
            Field klazzF = classInfoC.getDeclaredField("klazz");
            klazzF.setAccessible(true);
            Object object = items;
            synchronized (object) {
                Iterator iterator = (Iterator)iteratorM.invoke(items, new Object[0]);
                while (iterator.hasNext()) {
                    Object classInfo = iterator.next();
                    if (classInfo == null) {
                        LOGGER.finer("JENKINS-41945: ignoring null ClassInfo from ManagedLinkedList.Iter.next");
                        continue;
                    }
                    if (klazzF.get(classInfo) != clazz) continue;
                    iterator.remove();
                    LOGGER.log(Level.FINER, "cleaning up {0} from GlobalClassSet", clazz.getName());
                }
            }
            return;
        }
    }

    private static void cleanUpObjectStreamClassCaches(@Nonnull Class<?> clazz) throws Exception {
        Class<?> cachesC = Class.forName("java.io.ObjectStreamClass$Caches");
        block0: for (String cacheFName : new String[]{"localDescs", "reflectors"}) {
            Field cacheF = cachesC.getDeclaredField(cacheFName);
            cacheF.setAccessible(true);
            ConcurrentMap cache = (ConcurrentMap)cacheF.get(null);
            Iterator iterator = cache.entrySet().iterator();
            while (iterator.hasNext()) {
                if (((Reference)iterator.next().getKey()).get() != clazz) continue;
                iterator.remove();
                LOGGER.log(Level.FINER, "cleaning up {0} from ObjectStreamClass.Caches.{1}", new Object[]{clazz.getName(), cacheFName});
                continue block0;
            }
        }
    }

    synchronized FlowHead getFirstHead() {
        assert (!this.heads.isEmpty());
        return this.heads.firstEntry().getValue();
    }

    List<GraphListener> getListenersToRun() {
        ArrayList<GraphListener> l = new ArrayList<GraphListener>();
        if (this.listeners != null) {
            l.addAll(this.listeners);
        }
        l.addAll((Collection<GraphListener>)ExtensionList.lookup(GraphListener.class));
        return l;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void notifyListeners(List<FlowNode> nodes, boolean synchronous) {
        List<GraphListener> toRun = this.getListenersToRun();
        if (!toRun.isEmpty()) {
            Saveable s = Saveable.NOOP;
            try {
                Queue.Executable exec = this.owner.getExecutable();
                if (exec instanceof Saveable) {
                    s = (Saveable)exec;
                }
            }
            catch (IOException x) {
                LOGGER.log(Level.WARNING, "failed to notify listeners of changes to " + nodes + " in " + (Object)((Object)this), x);
            }
            BulkChange bc = new BulkChange(s);
            try {
                for (FlowNode node : nodes) {
                    for (GraphListener listener : toRun) {
                        if (listener instanceof GraphListener.Synchronous != synchronous) continue;
                        listener.onNewHead(node);
                    }
                }
            }
            finally {
                if (synchronous) {
                    bc.abort();
                } else {
                    try {
                        bc.commit();
                    }
                    catch (IOException x) {
                        LOGGER.log(Level.WARNING, null, x);
                    }
                }
            }
        }
    }

    public Authentication getAuthentication() {
        if (this.user == null) {
            return ACL.SYSTEM;
        }
        try {
            return User.get((String)this.user).impersonate();
        }
        catch (UsernameNotFoundException x) {
            LOGGER.log(Level.WARNING, "could not restore authentication", x);
            return Jenkins.ANONYMOUS;
        }
    }

    @Restricted(value={NoExternalUse.class})
    public String getNextScriptName(String path) {
        return this.shell.generateScriptName().replaceFirst("[.]groovy$", "");
    }

    public boolean isDoneFlagSet() {
        return this.done;
    }

    public boolean isPaused() {
        if (this.programPromise.isDone()) {
            try {
                return ((CpsThreadGroup)this.programPromise.get()).isPaused();
            }
            catch (InterruptedException | ExecutionException x) {
                LOGGER.log(Level.WARNING, null, x);
            }
        }
        return false;
    }

    private void setPersistedClean(boolean persistedClean) {
        this.persistedClean = persistedClean;
    }

    public void pause(final boolean v) throws IOException {
        Queue.Executable executable = this.owner.getExecutable();
        if (executable instanceof AccessControlled) {
            ((AccessControlled)executable).checkPermission(Item.CANCEL);
        }
        this.done = false;
        Futures.addCallback(this.programPromise, (FutureCallback)new FutureCallback<CpsThreadGroup>(){

            public void onSuccess(CpsThreadGroup g) {
                if (v) {
                    g.pause();
                    CpsFlowExecution.this.checkAndAbortNonresumableBuild();
                    CpsFlowExecution.this.checkpoint();
                } else {
                    g.unpause();
                }
                try {
                    CpsFlowExecution.this.owner.getListener().getLogger().println(v ? "Pausing" : "Resuming");
                }
                catch (IOException x) {
                    LOGGER.log(Level.WARNING, null, x);
                }
            }

            public void onFailure(Throwable x) {
                LOGGER.log(Level.WARNING, "cannot pause/unpause " + this, x);
            }
        });
    }

    public String toString() {
        return "CpsFlowExecution[" + this.owner + "]";
    }

    @Restricted(value={DoNotUse.class})
    @Terminator
    public static void suspendAll() {
        CpsFlowExecution exec = null;
        try (Timeout t = Timeout.limit((long)3L, (TimeUnit)TimeUnit.MINUTES);){
            LOGGER.fine("starting to suspend all executions");
            for (FlowExecution execution : FlowExecutionList.get()) {
                try {
                    if (!(execution instanceof CpsFlowExecution)) continue;
                    CpsFlowExecution cpsExec = (CpsFlowExecution)execution;
                    cpsExec.checkAndAbortNonresumableBuild();
                    LOGGER.log(Level.FINE, "waiting to suspend {0}", execution);
                    exec = (CpsFlowExecution)execution;
                    if (exec.programPromise != null) {
                        LOGGER.log(Level.FINER, "Waiting for Pipeline to go to sleep for shutdown: " + execution);
                        try {
                            ((CpsThreadGroup)exec.programPromise.get(1L, TimeUnit.MINUTES)).scheduleRun().get(1L, TimeUnit.MINUTES);
                            LOGGER.log(Level.FINER, " Pipeline went to sleep OK: " + execution);
                        }
                        catch (InterruptedException | TimeoutException ex) {
                            LOGGER.log(Level.WARNING, "Error waiting for Pipeline to suspend: " + (Object)((Object)exec), ex);
                        }
                    }
                    cpsExec.checkpoint();
                }
                catch (Exception ex) {
                    LOGGER.log(Level.WARNING, "Error persisting Pipeline execution at shutdown: " + ((CpsFlowExecution)execution).owner, ex);
                }
            }
            LOGGER.fine("finished suspending all executions");
        }
        catch (Exception x) {
            LOGGER.log(Level.WARNING, "problem suspending " + exec, x);
        }
    }

    void saveExecutionIfDurable() {
        if (this.getDurabilityHint().isPersistWithEveryStep()) {
            this.saveOwner();
        }
    }

    void saveOwner() {
        block5: {
            try {
                if (this.owner == null || !(this.owner.getExecutable() instanceof Saveable)) break block5;
                Saveable saveable = (Saveable)this.owner.getExecutable();
                this.persistedClean = true;
                if (this.storage != null && this.storage.delegate != null) {
                    try {
                        this.storage.flush();
                    }
                    catch (Exception ex) {
                        LOGGER.log(Level.WARNING, "Error persisting FlowNodes for execution " + this.owner, ex);
                        this.persistedClean = false;
                    }
                }
                saveable.save();
            }
            catch (IOException ex) {
                LOGGER.log(Level.WARNING, "Error persisting Run " + this.owner, ex);
                this.persistedClean = false;
            }
        }
    }

    private void checkpoint() {
        if (this.isComplete() || this.getDurabilityHint().isPersistWithEveryStep()) {
            return;
        }
        boolean persistOk = true;
        FlowNodeStorage storage = this.getStorage();
        if (storage != null) {
            try {
                storage.flush();
            }
            catch (IOException ioe) {
                persistOk = false;
                LOGGER.log(Level.WARNING, "Error persisting FlowNode storage before shutdown", ioe);
            }
            try {
                final SettableFuture myOutcome = SettableFuture.create();
                LOGGER.log(Level.INFO, "About to try to checkpoint the program for build" + (Object)((Object)this));
                if (this.programPromise != null && this.programPromise.isDone()) {
                    this.runInCpsVmThread(new FutureCallback<CpsThreadGroup>(){

                        public void onSuccess(CpsThreadGroup result) {
                            try {
                                LOGGER.log(Level.INFO, "Trying to save program before shutdown " + this);
                                result.saveProgramIfPossible(true);
                                LOGGER.log(Level.INFO, "Finished saving program before shutdown " + this);
                                myOutcome.set(null);
                            }
                            catch (Exception ex) {
                                LOGGER.log(Level.WARNING, "Error persisting program: " + ex);
                                myOutcome.setException((Throwable)ex);
                            }
                        }

                        public void onFailure(Throwable t) {
                            LOGGER.log(Level.WARNING, "Failed trying to save program before shutdown " + this);
                            myOutcome.setException(t);
                        }
                    });
                    myOutcome.get(30L, TimeUnit.SECONDS);
                    LOGGER.log(Level.FINE, "Successfully saved program for " + (Object)((Object)this));
                }
            }
            catch (TimeoutException te) {
                persistOk = false;
                LOGGER.log(Level.WARNING, "Timeout persisting program at execution checkpoint", te);
            }
            catch (InterruptedException | ExecutionException ex) {
                persistOk = false;
                LOGGER.log(Level.FINE, "Error saving program, that should be handled elsewhere.", ex);
            }
            try {
                storage.flush();
                LOGGER.log(Level.FINE, "Successfully did final flush of storage for " + (Object)((Object)this));
            }
            catch (IOException ioe) {
                persistOk = false;
                LOGGER.log(Level.WARNING, "Error persisting FlowNode storage before shutdown", ioe);
            }
            this.persistedClean = persistOk;
            try {
                this.saveOwner();
            }
            catch (Exception ex) {
                LOGGER.log(Level.WARNING, "Error saving build for " + (Object)((Object)this), ex);
            }
        }
    }

    private void checkAndAbortNonresumableBuild() {
        if (this.isComplete() || this.getDurabilityHint().isPersistWithEveryStep() || !this.isResumeBlocked()) {
            return;
        }
        try {
            this.owner.getListener().getLogger().println("Failing build: shutting down master and build is marked to not resume");
            FlowInterruptedException x = new FlowInterruptedException(Result.ABORTED, new CauseOfInterruption[0]);
            Futures.addCallback(this.getCurrentExecutions(true), (FutureCallback)new FutureCallback<List<StepExecution>>((Throwable)x){
                final /* synthetic */ Throwable val$x;
                {
                    this.val$x = throwable;
                }

                public void onSuccess(List<StepExecution> l) {
                    for (StepExecution e : Iterators.reverse(l)) {
                        StepContext context = e.getContext();
                        context.onFailure(this.val$x);
                        try {
                            FlowNode n = (FlowNode)context.get(FlowNode.class);
                            if (n == null) continue;
                            CpsFlowExecution.this.owner.getListener().getLogger().println("Terminating " + n.getDisplayFunctionName());
                        }
                        catch (Exception x) {
                            LOGGER.log(Level.FINE, null, x);
                        }
                    }
                }

                public void onFailure(Throwable t) {
                    LOGGER.log(Level.WARNING, "Error stopping build due to error obtaining executions", t);
                }
            });
        }
        catch (IOException ioe) {
            LOGGER.log(Level.WARNING, "Error just doing logging", ioe);
        }
    }

    protected void notifyShutdown() {
    }

    static {
        for (int i = 0; i < ID_LOOKUP_TABLE.length; ++i) {
            CpsFlowExecution.ID_LOOKUP_TABLE[i] = String.valueOf(i).intern();
        }
        TIMING_LOGGER = Logger.getLogger(CpsFlowExecution.class.getName() + ".timing");
        LOGGER = Logger.getLogger(CpsFlowExecution.class.getName());
        PROGRAM_STATE_SERIALIZATION = new ThreadLocal();
    }

    @Extension(optional=true)
    public static class PipelineTimings
    extends Component {
        public Set<Permission> getRequiredPermissions() {
            return Collections.singleton(Jenkins.ADMINISTER);
        }

        public String getDisplayName() {
            return "Timing data about recently completed Pipeline builds";
        }

        public void addContents(Container container) {
            container.add(new Content("nodes/master/pipeline-timings.txt"){

                public void writeTo(OutputStream outputStream) throws IOException {
                    PrintWriter pw = new PrintWriter(new OutputStreamWriter(outputStream, Charsets.UTF_8));
                    for (Job job : Jenkins.getActiveInstance().getAllItems(Job.class)) {
                        Map<String, Long> timings;
                        FlowExecution exec;
                        FlowExecutionOwner owner;
                        Run run;
                        if (!(job instanceof Queue.FlyweightTask) || !((run = job.getLastCompletedBuild()) instanceof FlowExecutionOwner.Executable) || (owner = ((FlowExecutionOwner.Executable)run).asFlowExecutionOwner()) == null || !((exec = owner.get()) instanceof CpsFlowExecution) || (timings = ((CpsFlowExecution)exec).timings) == null) continue;
                        pw.println("Timings for " + run + ":");
                        for (Map.Entry<String, Long> entry : new TreeMap<String, Long>(timings).entrySet()) {
                            pw.println("  " + entry.getKey() + "\t" + entry.getValue() / 1000L / 1000L + "ms");
                        }
                        pw.println();
                    }
                    pw.flush();
                }
            });
        }
    }

    class TimingFlowNodeStorage
    extends FlowNodeStorage {
        private final FlowNodeStorage delegate;
        private final ReadWriteLock readWriteLock = new ReentrantReadWriteLock();

        TimingFlowNodeStorage(FlowNodeStorage delegate) {
            this.delegate = delegate;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public FlowNode getNode(String string) throws IOException {
            Throwable throwable = null;
            try (Timing t = CpsFlowExecution.this.time(TimingKind.flowNode);){
                this.readWriteLock.readLock().lock();
                try {
                    FlowNode flowNode = this.delegate.getNode(string);
                    this.readWriteLock.readLock().unlock();
                    return flowNode;
                }
                catch (Throwable throwable2) {
                    try {
                        this.readWriteLock.readLock().unlock();
                        throw throwable2;
                    }
                    catch (Throwable throwable3) {
                        throwable = throwable3;
                        throw throwable3;
                    }
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void storeNode(@Nonnull FlowNode n) throws IOException {
            try (Timing t = CpsFlowExecution.this.time(TimingKind.flowNode);){
                this.readWriteLock.writeLock().lock();
                try {
                    this.delegate.storeNode(n);
                }
                finally {
                    this.readWriteLock.writeLock().unlock();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void storeNode(@Nonnull FlowNode n, boolean delayWritingActions) throws IOException {
            try (Timing t = CpsFlowExecution.this.time(TimingKind.flowNode);){
                this.readWriteLock.writeLock().lock();
                try {
                    this.delegate.storeNode(n, delayWritingActions);
                }
                finally {
                    this.readWriteLock.writeLock().unlock();
                }
            }
        }

        public void flush() throws IOException {
            try (Timing t = CpsFlowExecution.this.time(TimingKind.flowNode);){
                this.readWriteLock.writeLock().lock();
                try {
                    this.delegate.flush();
                }
                finally {
                    this.readWriteLock.writeLock().unlock();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void flushNode(FlowNode node) throws IOException {
            try (Timing t = CpsFlowExecution.this.time(TimingKind.flowNode);){
                this.readWriteLock.writeLock().lock();
                try {
                    this.delegate.flushNode(node);
                }
                finally {
                    this.readWriteLock.writeLock().unlock();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void autopersist(@Nonnull FlowNode n) throws IOException {
            try (Timing t = CpsFlowExecution.this.time(TimingKind.flowNode);){
                this.readWriteLock.writeLock().lock();
                try {
                    this.delegate.autopersist(n);
                }
                finally {
                    this.readWriteLock.writeLock().unlock();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public List<Action> loadActions(FlowNode node) throws IOException {
            Throwable throwable = null;
            try (Timing t = CpsFlowExecution.this.time(TimingKind.flowNode);){
                this.readWriteLock.readLock().lock();
                try {
                    List list = this.delegate.loadActions(node);
                    this.readWriteLock.readLock().unlock();
                    return list;
                }
                catch (Throwable throwable2) {
                    try {
                        this.readWriteLock.readLock().unlock();
                        throw throwable2;
                    }
                    catch (Throwable throwable3) {
                        throwable = throwable3;
                        throw throwable3;
                    }
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void saveActions(FlowNode node, List<Action> actions) throws IOException {
            try (Timing t = CpsFlowExecution.this.time(TimingKind.flowNode);){
                this.readWriteLock.writeLock().lock();
                try {
                    this.delegate.saveActions(node, actions);
                }
                finally {
                    this.readWriteLock.writeLock().unlock();
                }
            }
        }
    }

    public static final class ConverterImpl
    implements Converter {
        private final ReflectionProvider ref;
        private final Mapper mapper;

        public ConverterImpl(XStream xs) {
            this.ref = xs.getReflectionProvider();
            this.mapper = xs.getMapper();
        }

        public boolean canConvert(Class type) {
            return CpsFlowExecution.class == type;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void marshal(Object source, HierarchicalStreamWriter w, MarshallingContext context) {
            CpsFlowExecution e = (CpsFlowExecution)((Object)source);
            this.writeChild(w, context, "result", e.result, Result.class);
            this.writeChild(w, context, "script", e.script, String.class);
            this.writeChild(w, context, "loadedScripts", e.loadedScripts, Map.class);
            if (e.persistedClean != null) {
                this.writeChild(w, context, "persistedClean", e.persistedClean, Boolean.class);
            }
            if (e.durabilityHint != null) {
                this.writeChild(w, context, "durabilityHint", e.durabilityHint, FlowDurabilityHint.class);
            }
            CpsFlowExecution cpsFlowExecution = e;
            synchronized (cpsFlowExecution) {
                if (e.timings != null) {
                    this.writeChild(w, context, "timings", e.timings, Map.class);
                }
            }
            this.writeChild(w, context, "sandbox", e.sandbox, Boolean.class);
            if (e.user != null) {
                this.writeChild(w, context, "user", e.user, String.class);
            }
            this.writeChild(w, context, "iota", e.iota.get(), Integer.class);
            cpsFlowExecution = e;
            synchronized (cpsFlowExecution) {
                if (e.headsSerial != null && (e.heads == null || e.heads.isEmpty())) {
                    for (Map.Entry entry : e.headsSerial.entrySet()) {
                        this.writeChild(w, context, "head", entry.getKey() + ":" + (String)entry.getValue(), String.class);
                    }
                } else {
                    for (FlowHead flowHead : e.heads.values()) {
                        this.writeChild(w, context, "head", flowHead.getId() + ":" + flowHead.get().getId(), String.class);
                    }
                }
                if (e.startNodesSerial != null && e.startNodes == null) {
                    for (String string : e.startNodesSerial) {
                        this.writeChild(w, context, "start", string, String.class);
                    }
                } else {
                    for (BlockStartNode blockStartNode : e.startNodes) {
                        this.writeChild(w, context, "start", blockStartNode.getId(), String.class);
                    }
                }
                this.writeChild(w, context, "done", e.done, Boolean.class);
            }
            this.writeChild(w, context, "resumeBlocked", e.resumeBlocked, Boolean.class);
            if (e.storageDir != null) {
                this.writeChild(w, context, "storageDir", e.storageDir, String.class);
            }
        }

        private <T> void writeChild(HierarchicalStreamWriter w, MarshallingContext context, String name, @Nonnull T v, Class<T> staticType) {
            if (!this.mapper.shouldSerializeMember(CpsFlowExecution.class, name)) {
                return;
            }
            ExtendedHierarchicalStreamWriterHelper.startNode((HierarchicalStreamWriter)w, (String)name, staticType);
            Class<?> actualType = v.getClass();
            if (actualType != staticType) {
                w.addAttribute(this.mapper.aliasForSystemAttribute("class"), this.mapper.serializedClass(actualType));
            }
            context.convertAnother(v);
            w.endNode();
        }

        @SuppressFBWarnings(value={"BX_UNBOXING_IMMEDIATELY_REBOXED"}, justification="Nastiness with the impl")
        public Object unmarshal(HierarchicalStreamReader reader, UnmarshallingContext context) {
            try {
                CpsFlowExecution result = context.currentObject() != null ? (CpsFlowExecution)((Object)context.currentObject()) : (CpsFlowExecution)((Object)this.ref.newInstance(CpsFlowExecution.class));
                result.startNodesSerial = new ArrayList();
                result.headsSerial = new TreeMap();
                while (reader.hasMoreChildren()) {
                    reader.moveDown();
                    String nodeName = reader.getNodeName();
                    if (nodeName.equals("result")) {
                        Result r = this.readChild(reader, context, Result.class, (Object)result);
                        this.setField(result, "result", r);
                    } else if (nodeName.equals("script")) {
                        String script = this.readChild(reader, context, String.class, (Object)result);
                        this.setField(result, "script", script);
                    } else if (nodeName.equals("loadedScripts")) {
                        Map loadedScripts = this.readChild(reader, context, Map.class, (Object)result);
                        this.setField(result, "loadedScripts", loadedScripts);
                    } else if (nodeName.equals("timings")) {
                        Map timings = this.readChild(reader, context, Map.class, (Object)result);
                        this.setField(result, "timings", timings);
                    } else if (nodeName.equals("sandbox")) {
                        boolean sandbox = this.readChild(reader, context, Boolean.class, (Object)result);
                        this.setField(result, "sandbox", sandbox);
                    } else if (nodeName.equals("owner")) {
                        this.readChild(reader, context, Object.class, (Object)result);
                    } else if (nodeName.equals("user")) {
                        String user = this.readChild(reader, context, String.class, (Object)result);
                        this.setField(result, "user", user);
                    } else if (nodeName.equals("head")) {
                        String[] head = this.readChild(reader, context, String.class, (Object)result).split(":");
                        result.headsSerial.put(Integer.parseInt(head[0]), head[1]);
                    } else if (nodeName.equals("iota")) {
                        Integer iota = this.readChild(reader, context, Integer.class, (Object)result);
                        this.setField(result, "iota", new AtomicInteger(iota));
                    } else if (nodeName.equals("done")) {
                        Boolean isDone = this.readChild(reader, context, Boolean.class, (Object)result);
                        this.setField(result, "done", isDone);
                    } else if (nodeName.equals("start")) {
                        String id = this.readChild(reader, context, String.class, (Object)result);
                        result.startNodesSerial.add(id);
                    } else if (nodeName.equals("durabilityHint")) {
                        FlowDurabilityHint hint = this.readChild(reader, context, FlowDurabilityHint.class, (Object)result);
                        this.setFieldParent(result, "durabilityHint", hint);
                    } else if (nodeName.equals("persistedClean")) {
                        Boolean hint = this.readChild(reader, context, Boolean.class, (Object)result);
                        this.setField(result, "persistedClean", hint);
                    } else if (nodeName.equals("resumeBlocked")) {
                        Boolean val = this.readChild(reader, context, Boolean.class, (Object)result);
                        this.setField(result, "resumeBlocked", (boolean)val);
                    } else if (nodeName.equals("storageDir")) {
                        String val = this.readChild(reader, context, String.class, (Object)result);
                        this.setField(result, "storageDir", val);
                    }
                    reader.moveUp();
                }
                return result;
            }
            catch (Exception ex) {
                LOGGER.log(Level.SEVERE, "Failed to even load the FlowExecution", ex);
                throw new RuntimeException(ex);
            }
        }

        private void setField(CpsFlowExecution result, String fieldName, Object value) {
            this.ref.writeField((Object)result, fieldName, value, CpsFlowExecution.class);
        }

        private void setFieldParent(CpsFlowExecution result, String fieldName, Object value) {
            this.ref.writeField((Object)result, fieldName, value, FlowExecution.class);
        }

        private <T> T readChild(HierarchicalStreamReader r, UnmarshallingContext context, Class<T> type, Object parent) {
            String classAttribute = r.getAttribute(this.mapper.aliasForAttribute("class"));
            if (classAttribute != null) {
                type = this.mapper.realClass(classAttribute);
            }
            return type.cast(context.convertAnother(parent, type));
        }
    }

    class Timing
    implements AutoCloseable {
        private final TimingKind kind;
        private final long start;

        private Timing(TimingKind kind) {
            this.kind = kind;
            this.start = System.nanoTime();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void close() {
            CpsFlowExecution cpsFlowExecution = CpsFlowExecution.this;
            synchronized (cpsFlowExecution) {
                Long orig;
                if (CpsFlowExecution.this.timings == null) {
                    CpsFlowExecution.this.timings = new HashMap<String, Long>();
                }
                if ((orig = CpsFlowExecution.this.timings.get(this.kind.name())) == null) {
                    orig = 0L;
                }
                CpsFlowExecution.this.timings.put(this.kind.name(), orig + System.nanoTime() - this.start);
            }
        }
    }

    static enum TimingKind {
        parse,
        classLoad,
        run,
        saveProgram,
        flowNode;

    }
}

