/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.workflow.cps;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import groovy.lang.Binding;
import groovy.lang.GroovyClassLoader;
import groovy.lang.GroovyCodeSource;
import groovy.lang.GroovyShell;
import groovy.lang.Script;
import java.io.IOException;
import java.lang.reflect.Field;
import java.net.URL;
import java.util.Enumeration;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import org.codehaus.groovy.control.CompilationFailedException;
import org.codehaus.groovy.control.CompilationUnit;
import org.codehaus.groovy.control.CompilerConfiguration;
import org.codehaus.groovy.control.SourceUnit;
import org.jenkinsci.plugins.workflow.cps.CpsFlowExecution;
import org.jenkinsci.plugins.workflow.cps.CpsScript;

@SuppressFBWarnings(value={"DP_CREATE_CLASSLOADER_INSIDE_DO_PRIVILEGED"}, justification="irrelevant")
class CpsGroovyShell
extends GroovyShell {
    private static final Logger LOGGER = Logger.getLogger(CpsGroovyShell.class.getName());
    @CheckForNull
    private final CpsFlowExecution execution;

    CpsGroovyShell(ClassLoader parent, @CheckForNull CpsFlowExecution execution, CompilerConfiguration cc) {
        this(execution, cc, execution != null ? new TimingLoader(parent, execution) : parent);
    }

    private CpsGroovyShell(@CheckForNull CpsFlowExecution execution, CompilerConfiguration cc, ClassLoader usuallyTimingLoader) {
        super(usuallyTimingLoader, new Binding(), cc);
        this.execution = execution;
        try {
            Field loaderF = GroovyShell.class.getDeclaredField("loader");
            loaderF.setAccessible(true);
            loaderF.set((Object)this, (Object)new CleanGroovyClassLoader(usuallyTimingLoader, cc));
        }
        catch (Exception x) {
            LOGGER.log(Level.WARNING, "failed to install CleanGroovyClassLoader", x);
        }
    }

    public void prepareScript(Script script) {
        if (script instanceof CpsScript) {
            CpsScript cs = (CpsScript)script;
            cs.execution = this.execution;
            try {
                cs.$initialize();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }

    public Script parse(GroovyCodeSource codeSource) throws CompilationFailedException {
        Script s = this.doParse(codeSource);
        if (this.execution != null) {
            this.execution.loadedScripts.put(s.getClass().getSimpleName(), codeSource.getScriptText());
            this.execution.saveExecutionIfDurable();
        }
        this.prepareScript(s);
        return s;
    }

    Script reparse(String className, String text) throws CompilationFailedException {
        return this.doParse(new GroovyCodeSource(text, className, "/groovy/shell"));
    }

    private Script doParse(GroovyCodeSource codeSource) throws CompilationFailedException {
        if (this.execution != null) {
            try (CpsFlowExecution.Timing t = this.execution.time(CpsFlowExecution.TimingKind.parse);){
                Script script = super.parse(codeSource);
                return script;
            }
        }
        return super.parse(codeSource);
    }

    protected synchronized String generateScriptName() {
        if (this.execution != null) {
            return "Script" + (this.execution.loadedScripts.size() + 1) + ".groovy";
        }
        return super.generateScriptName();
    }

    static class TimingLoader
    extends ClassLoader {
        @Nonnull
        private final CpsFlowExecution execution;

        TimingLoader(ClassLoader parent, @Nonnull CpsFlowExecution execution) {
            super(parent);
            this.execution = execution;
        }

        @Override
        protected Class<?> loadClass(String name, boolean resolve) throws ClassNotFoundException {
            try (CpsFlowExecution.Timing t = this.execution.time(CpsFlowExecution.TimingKind.classLoad);){
                Class<?> clazz = super.loadClass(name, resolve);
                return clazz;
            }
        }

        @Override
        public URL getResource(String name) {
            try (CpsFlowExecution.Timing t = this.execution.time(CpsFlowExecution.TimingKind.classLoad);){
                URL uRL = super.getResource(name);
                return uRL;
            }
        }

        @Override
        public Enumeration<URL> getResources(String name) throws IOException {
            try (CpsFlowExecution.Timing t = this.execution.time(CpsFlowExecution.TimingKind.classLoad);){
                Enumeration<URL> enumeration = super.getResources(name);
                return enumeration;
            }
        }
    }

    private static final class CleanGroovyClassLoader
    extends GroovyClassLoader {
        CleanGroovyClassLoader(ClassLoader loader, CompilerConfiguration config) {
            super(loader, config);
        }

        protected GroovyClassLoader.ClassCollector createCollector(CompilationUnit unit, SourceUnit su) {
            return new CleanClassCollector(unit, su);
        }

        private final class CleanClassCollector
        extends GroovyClassLoader.ClassCollector {
            CleanClassCollector(CompilationUnit unit, SourceUnit su) {
                super(null, unit, su);
            }

            public GroovyClassLoader getDefiningClassLoader() {
                return CleanGroovyClassLoader.this;
            }
        }
    }
}

