/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.workflow.cps;

import com.cloudbees.groovy.cps.CpsTransformer;
import com.cloudbees.groovy.cps.NonCPS;
import com.cloudbees.groovy.cps.SandboxCpsTransformer;
import com.cloudbees.groovy.cps.TransformerConfiguration;
import groovy.lang.GroovyShell;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.CheckForNull;
import javax.annotation.Nullable;
import jenkins.model.Jenkins;
import org.codehaus.groovy.control.CompilerConfiguration;
import org.codehaus.groovy.control.customizers.CompilationCustomizer;
import org.codehaus.groovy.control.customizers.ImportCustomizer;
import org.jenkinsci.plugins.scriptsecurity.sandbox.groovy.GroovySandbox;
import org.jenkinsci.plugins.workflow.cps.CpsClosure2;
import org.jenkinsci.plugins.workflow.cps.CpsFlowExecution;
import org.jenkinsci.plugins.workflow.cps.CpsGroovyShell;
import org.jenkinsci.plugins.workflow.cps.CpsScript;
import org.jenkinsci.plugins.workflow.cps.GroovyShellDecorator;
import org.jenkinsci.plugins.workflow.cps.Safepoint;

class CpsGroovyShellFactory {
    @CheckForNull
    private final CpsFlowExecution execution;
    private boolean sandbox;
    private List<GroovyShellDecorator> decorators;
    private ClassLoader parent;

    public CpsGroovyShellFactory(@Nullable CpsFlowExecution execution) {
        this.execution = execution;
        this.sandbox = execution != null && execution.isSandbox();
        this.decorators = GroovyShellDecorator.all();
    }

    private CpsGroovyShellFactory(CpsFlowExecution execution, boolean sandbox, ClassLoader parent, List<GroovyShellDecorator> decorators) {
        this.execution = execution;
        this.sandbox = sandbox;
        this.parent = parent;
        this.decorators = decorators;
    }

    public CpsGroovyShellFactory forTrusted() {
        ArrayList<GroovyShellDecorator> inner = new ArrayList<GroovyShellDecorator>();
        for (GroovyShellDecorator d : this.decorators) {
            inner.add(d.forTrusted());
        }
        return new CpsGroovyShellFactory(this.execution, false, this.parent, inner);
    }

    public CpsGroovyShellFactory withSandbox(boolean b) {
        this.sandbox = b;
        return this;
    }

    public CpsGroovyShellFactory withParent(GroovyShell parent) {
        return this.withParent((ClassLoader)parent.getClassLoader());
    }

    public CpsGroovyShellFactory withParent(ClassLoader parent) {
        this.parent = parent;
        return this;
    }

    private CpsTransformer makeCpsTransformer() {
        SandboxCpsTransformer t = this.sandbox ? new SandboxCpsTransformer() : new CpsTransformer();
        t.setConfiguration(new TransformerConfiguration().withClosureType(CpsClosure2.class).withSafepoint(Safepoint.class, "safepoint"));
        return t;
    }

    private CompilerConfiguration makeConfig() {
        CompilerConfiguration cc = new CompilerConfiguration();
        cc.addCompilationCustomizers(new CompilationCustomizer[]{this.makeImportCustomizer()});
        cc.addCompilationCustomizers(new CompilationCustomizer[]{this.makeCpsTransformer()});
        cc.setScriptBaseClass(CpsScript.class.getName());
        for (GroovyShellDecorator d : this.decorators) {
            d.configureCompiler(this.execution, cc);
        }
        return cc;
    }

    private ImportCustomizer makeImportCustomizer() {
        ImportCustomizer ic = new ImportCustomizer();
        ic.addStarImports(new String[]{NonCPS.class.getPackage().getName()});
        ic.addStarImports(new String[]{"hudson.model", "jenkins.model"});
        for (GroovyShellDecorator d : this.decorators) {
            d.customizeImports(this.execution, ic);
        }
        return ic;
    }

    private ClassLoader makeClassLoader() {
        ClassLoader cl = Jenkins.getActiveInstance().getPluginManager().uberClassLoader;
        return GroovySandbox.createSecureClassLoader((ClassLoader)cl);
    }

    public CpsGroovyShell build() {
        ClassLoader parent = this.parent;
        if (parent == null) {
            parent = this.makeClassLoader();
        }
        CpsGroovyShell shell = new CpsGroovyShell(parent, this.execution, this.makeConfig());
        for (GroovyShellDecorator d : this.decorators) {
            d.configureShell(this.execution, shell);
        }
        return shell;
    }
}

