/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.workflow.cps;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nonnull;
import org.jenkinsci.plugins.workflow.cps.CpsStepContext;
import org.jenkinsci.plugins.workflow.cps.CpsThread;
import org.jenkinsci.plugins.workflow.cps.CpsThreadGroup;
import org.jenkinsci.plugins.workflow.cps.FlowHead;
import org.jenkinsci.plugins.workflow.steps.StepDescriptor;
import org.jenkinsci.plugins.workflow.steps.StepExecution;

public final class CpsThreadDump {
    private final List<ThreadInfo> threads = new ArrayList<ThreadInfo>();
    public static final CpsThreadDump EMPTY = new CpsThreadDump();
    @Deprecated
    public static final CpsThreadDump UNKNOWN = CpsThreadDump.fromText("Program state is not yet known");

    private CpsThreadDump() {
    }

    public List<ThreadInfo> getThreads() {
        return Collections.unmodifiableList(this.threads);
    }

    @SuppressFBWarnings(value={"DM_DEFAULT_ENCODING"}, justification="Only used by tests anyway.")
    public void print(PrintStream ps) {
        this.print(new PrintWriter(ps, true));
    }

    public void print(PrintWriter w) {
        for (ThreadInfo t : this.threads) {
            t.print(w);
        }
    }

    public String toString() {
        StringWriter sw = new StringWriter();
        this.print(new PrintWriter(sw));
        return sw.toString();
    }

    public static CpsThreadDump from(Throwable t) {
        CpsThreadDump td = new CpsThreadDump();
        td.threads.add(new ThreadInfo(t));
        return td;
    }

    public static CpsThreadDump from(CpsThreadGroup g) {
        LinkedHashMap<FlowHead, ArrayList<CpsThread>> m = new LinkedHashMap<FlowHead, ArrayList<CpsThread>>();
        for (CpsThread t : g.threads.values()) {
            ArrayList<CpsThread> l = (ArrayList<CpsThread>)m.get(t.head);
            if (l == null) {
                l = new ArrayList<CpsThread>();
                m.put(t.head, l);
            }
            l.add(t);
        }
        CpsThreadDump td = new CpsThreadDump();
        for (List e : m.values()) {
            td.threads.add(new ThreadInfo(e));
        }
        return td;
    }

    @Nonnull
    public static CpsThreadDump fromText(final @Nonnull String text) {
        return CpsThreadDump.from(new Throwable(){

            @Override
            public String toString() {
                return text;
            }

            @Override
            public Throwable fillInStackTrace() {
                return this;
            }
        });
    }

    public static final class ThreadInfo {
        private final String headline;
        private final List<StackTraceElement> stack = new ArrayList<StackTraceElement>();

        private ThreadInfo(List<CpsThread> e) {
            CpsThread head = e.get(e.size() - 1);
            this.headline = "Thread #" + head.id;
            ListIterator<CpsThread> itr = e.listIterator(e.size());
            while (itr.hasPrevious()) {
                StepDescriptor d;
                CpsThread t = itr.previous();
                StepExecution s = t.getStep();
                if (s != null && (d = ((CpsStepContext)s.getContext()).getStepDescriptor()) != null) {
                    String status = s.getStatusBounded(3L, TimeUnit.SECONDS);
                    if (status != null) {
                        this.stack.add(new StackTraceElement("DSL", d.getFunctionName(), status, -1));
                    } else {
                        this.stack.add(new StackTraceElement("DSL", d.getFunctionName(), null, -2));
                    }
                }
                this.stack.addAll(t.getStackTrace());
            }
        }

        public ThreadInfo(Throwable t) {
            this.headline = t.toString();
            this.stack.addAll(Arrays.asList(t.getStackTrace()));
        }

        public List<StackTraceElement> getStackTrace() {
            return Collections.unmodifiableList(this.stack);
        }

        public String getHeadline() {
            return this.headline;
        }

        public void print(PrintWriter w) {
            w.println(this.headline);
            for (StackTraceElement e : this.stack) {
                w.println("\tat " + e);
            }
        }

        public String toString() {
            StringWriter sw = new StringWriter();
            this.print(new PrintWriter(sw));
            return sw.toString();
        }
    }
}

