/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.workflow.cps;

import hudson.model.Computer;
import hudson.remoting.SingleLaneExecutorService;
import hudson.security.ACL;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.logging.Level;
import java.util.logging.Logger;
import jenkins.util.InterceptingExecutorService;
import org.acegisecurity.Authentication;
import org.jenkinsci.plugins.workflow.cps.CpsFlowExecution;
import org.jenkinsci.plugins.workflow.cps.CpsThreadGroup;

class CpsVmExecutorService
extends InterceptingExecutorService {
    private CpsThreadGroup cpsThreadGroup;
    static ThreadLocal<CpsThreadGroup> CURRENT = new ThreadLocal();
    static ThreadLocal<ClassLoader> ORIGINAL_CONTEXT_CLASS_LOADER = new ThreadLocal();
    private static final Logger LOGGER = Logger.getLogger(CpsVmExecutorService.class.getName());

    public CpsVmExecutorService(CpsThreadGroup cpsThreadGroup) {
        super((ExecutorService)new SingleLaneExecutorService(Computer.threadPoolForRemoting));
        this.cpsThreadGroup = cpsThreadGroup;
    }

    protected Runnable wrap(final Runnable r) {
        return new Runnable(){

            @Override
            public void run() {
                ThreadContext context = CpsVmExecutorService.this.setUp();
                try {
                    r.run();
                }
                catch (Throwable t) {
                    CpsVmExecutorService.this.reportProblem(t);
                    throw t;
                }
                finally {
                    CpsVmExecutorService.this.tearDown(context);
                }
            }
        };
    }

    private void reportProblem(Throwable t) {
        LOGGER.log(Level.WARNING, "Unexpected exception in CPS VM thread: " + (Object)((Object)this.cpsThreadGroup.getExecution()), t);
        this.cpsThreadGroup.getExecution().croak(t);
    }

    protected <V> Callable<V> wrap(final Callable<V> r) {
        return new Callable<V>(){

            @Override
            public V call() throws Exception {
                ThreadContext context = CpsVmExecutorService.this.setUp();
                try {
                    Object v = r.call();
                    return v;
                }
                catch (Throwable t) {
                    CpsVmExecutorService.this.reportProblem(t);
                    throw t;
                }
                finally {
                    CpsVmExecutorService.this.tearDown(context);
                }
            }
        };
    }

    private ThreadContext setUp() {
        CpsFlowExecution execution = this.cpsThreadGroup.getExecution();
        ACL.impersonate((Authentication)execution.getAuthentication());
        CURRENT.set(this.cpsThreadGroup);
        this.cpsThreadGroup.busy = true;
        Thread t = Thread.currentThread();
        ThreadContext context = new ThreadContext(t, execution);
        t.setName("Running " + (Object)((Object)execution));
        assert (this.cpsThreadGroup.getExecution() != null);
        if (this.cpsThreadGroup.getExecution().getShell() != null) {
            assert (this.cpsThreadGroup.getExecution().getShell().getClassLoader() != null);
            t.setContextClassLoader((ClassLoader)this.cpsThreadGroup.getExecution().getShell().getClassLoader());
        }
        return context;
    }

    private void tearDown(ThreadContext context) {
        CURRENT.set(null);
        this.cpsThreadGroup.busy = false;
        context.restore();
        CpsFlowExecution execution = this.cpsThreadGroup.getExecution();
        if (this.isShutdown()) {
            execution.logTimings();
        }
    }

    private static class ThreadContext {
        final Thread thread;
        final String name;
        final ClassLoader classLoader;
        final CpsFlowExecution.Timing timing;

        ThreadContext(Thread thread, CpsFlowExecution execution) {
            this.thread = thread;
            this.name = thread.getName();
            this.classLoader = thread.getContextClassLoader();
            ORIGINAL_CONTEXT_CLASS_LOADER.set(this.classLoader);
            this.timing = execution.time(CpsFlowExecution.TimingKind.run);
        }

        void restore() {
            this.thread.setName(this.name);
            this.thread.setContextClassLoader(this.classLoader);
            ORIGINAL_CONTEXT_CLASS_LOADER.set(null);
            this.timing.close();
        }
    }
}

