/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.workflow.cps;

import com.cloudbees.groovy.cps.Continuable;
import com.cloudbees.groovy.cps.Outcome;
import groovy.lang.Closure;
import groovy.lang.GString;
import groovy.lang.GroovyObjectSupport;
import groovy.lang.GroovyRuntimeException;
import hudson.EnvVars;
import hudson.model.Action;
import hudson.model.Computer;
import hudson.model.Describable;
import hudson.model.Descriptor;
import hudson.model.Queue;
import hudson.model.Run;
import hudson.model.TaskListener;
import java.io.IOException;
import java.io.PrintStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.logging.Level;
import java.util.logging.Logger;
import jenkins.model.Jenkins;
import org.apache.commons.lang.StringUtils;
import org.jenkinsci.Symbol;
import org.jenkinsci.plugins.structs.SymbolLookup;
import org.jenkinsci.plugins.structs.describable.DescribableModel;
import org.jenkinsci.plugins.structs.describable.DescribableParameter;
import org.jenkinsci.plugins.structs.describable.UninstantiatedDescribable;
import org.jenkinsci.plugins.workflow.cps.CpsBodyInvoker;
import org.jenkinsci.plugins.workflow.cps.CpsFlowExecution;
import org.jenkinsci.plugins.workflow.cps.CpsStepContext;
import org.jenkinsci.plugins.workflow.cps.CpsThread;
import org.jenkinsci.plugins.workflow.cps.CpsVmExecutorService;
import org.jenkinsci.plugins.workflow.cps.CpsVmThreadOnly;
import org.jenkinsci.plugins.workflow.cps.FlowHead;
import org.jenkinsci.plugins.workflow.cps.GlobalVariable;
import org.jenkinsci.plugins.workflow.cps.ThreadTask;
import org.jenkinsci.plugins.workflow.cps.ThreadTaskResult;
import org.jenkinsci.plugins.workflow.cps.actions.ArgumentsActionImpl;
import org.jenkinsci.plugins.workflow.cps.nodes.StepAtomNode;
import org.jenkinsci.plugins.workflow.cps.nodes.StepEndNode;
import org.jenkinsci.plugins.workflow.cps.nodes.StepNode;
import org.jenkinsci.plugins.workflow.cps.nodes.StepStartNode;
import org.jenkinsci.plugins.workflow.cps.steps.LoadStep;
import org.jenkinsci.plugins.workflow.cps.steps.ParallelStep;
import org.jenkinsci.plugins.workflow.flow.FlowExecutionOwner;
import org.jenkinsci.plugins.workflow.graph.FlowNode;
import org.jenkinsci.plugins.workflow.steps.BodyExecutionCallback;
import org.jenkinsci.plugins.workflow.steps.MissingContextVariableException;
import org.jenkinsci.plugins.workflow.steps.Step;
import org.jenkinsci.plugins.workflow.steps.StepContext;
import org.jenkinsci.plugins.workflow.steps.StepDescriptor;
import org.jenkinsci.plugins.workflow.steps.StepExecution;
import org.jvnet.hudson.annotation_indexer.Index;
import org.kohsuke.stapler.ClassDescriptor;
import org.kohsuke.stapler.NoStaplerConstructorException;

public class DSL
extends GroovyObjectSupport
implements Serializable {
    private final FlowExecutionOwner handle;
    private transient CpsFlowExecution exec;
    private transient Map<String, StepDescriptor> functions;
    private static final Logger LOGGER = Logger.getLogger(DSL.class.getName());
    private static final String KEEP_STEP_ARGUMENTS_PROPERTYNAME = DSL.class.getName() + ".keepStepArguments";
    private static boolean isKeepStepArguments = StringUtils.isEmpty((String)System.getProperty(KEEP_STEP_ARGUMENTS_PROPERTYNAME)) || Boolean.parseBoolean(System.getProperty(KEEP_STEP_ARGUMENTS_PROPERTYNAME));
    private static final long serialVersionUID = 1L;

    public DSL(FlowExecutionOwner handle) {
        this.handle = handle;
    }

    protected Object readResolve() throws IOException {
        return this;
    }

    public static boolean isKeepStepArguments() {
        return isKeepStepArguments;
    }

    @CpsVmThreadOnly
    public Object invokeMethod(String name, Object args) {
        StepDescriptor sd;
        try {
            if (this.exec == null) {
                this.exec = (CpsFlowExecution)this.handle.get();
            }
        }
        catch (IOException e) {
            throw new GroovyRuntimeException((Throwable)e);
        }
        if (this.functions == null) {
            this.functions = new TreeMap<String, StepDescriptor>();
            while (StepDescriptor.all().isEmpty()) {
                LOGGER.warning("Jenkins does not seem to be fully started yet, waiting\u2026");
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException x) {
                    throw new GroovyRuntimeException((Throwable)x);
                }
            }
            for (StepDescriptor d : StepDescriptor.all()) {
                this.functions.put(d.getFunctionName(), d);
            }
        }
        if ((sd = this.functions.get(name)) != null) {
            return this.invokeStep(sd, args);
        }
        if (SymbolLookup.get().findDescriptor(Describable.class, name) != null) {
            return this.invokeDescribable(name, args);
        }
        TreeSet symbols = new TreeSet();
        TreeSet<String> globals = new TreeSet<String>();
        try {
            for (Class e : Index.list(Symbol.class, (ClassLoader)Jenkins.getActiveInstance().pluginManager.uberClassLoader, Class.class)) {
                if (!Descriptor.class.isAssignableFrom(e)) continue;
                symbols.addAll(SymbolLookup.getSymbolValue((Class)e));
            }
            Queue.Executable executable = this.exec.getOwner().getExecutable();
            for (GlobalVariable var : GlobalVariable.forRun(executable instanceof Run ? (Run)executable : null)) {
                globals.add(var.getName());
            }
        }
        catch (IOException x) {
            Logger.getLogger(DSL.class.getName()).log(Level.WARNING, null, x);
        }
        throw new NoSuchMethodError("No such DSL method '" + name + "' found among steps " + this.functions.keySet() + " or symbols " + symbols + " or globals " + globals);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Object invokeStep(StepDescriptor d, Object args) {
        boolean sync;
        Step s;
        StepNode an;
        boolean hack;
        NamedArgsAndClosure ps = DSL.parseArgs(args, d);
        CpsThread thread = CpsThread.current();
        boolean bl = hack = d instanceof ParallelStep.DescriptorImpl || d instanceof LoadStep.DescriptorImpl;
        if (ps.body == null && !hack) {
            an = new StepAtomNode(this.exec, d, thread.head.get());
            thread.head.setNewHead((FlowNode)an);
        } else {
            an = new StepStartNode(this.exec, d, thread.head.get());
            thread.head.setNewHead((FlowNode)an);
        }
        CpsStepContext context = new CpsStepContext(d, thread, this.handle, (FlowNode)an, ps.body);
        ClassLoader originalLoader = Thread.currentThread().getContextClassLoader();
        try {
            d.checkContextAvailability((StepContext)context);
            Thread.currentThread().setContextClassLoader(CpsVmExecutorService.ORIGINAL_CONTEXT_CLASS_LOADER.get());
            s = d.newInstance(ps.namedArgs);
            try {
                if (ps.namedArgs != null && !ps.namedArgs.isEmpty() && DSL.isKeepStepArguments() && !(s instanceof ParallelStep)) {
                    Computer comp = (Computer)context.get(Computer.class);
                    EnvVars allEnv = new EnvVars((EnvVars)context.get(EnvVars.class));
                    if (comp != null && allEnv != null) {
                        allEnv.entrySet().removeAll(comp.getEnvironment().entrySet());
                    }
                    an.addAction((Action)new ArgumentsActionImpl(ps.namedArgs, allEnv));
                }
            }
            catch (Exception e) {
                LOGGER.log(Level.WARNING, "Error storing the arguments for step: " + d.getFunctionName(), e);
            }
            CpsFlowExecution.maybeAutoPersistNode((FlowNode)an);
            StepExecution e = s.start((StepContext)context);
            thread.setStep(e);
            sync = e.start();
        }
        catch (Exception e) {
            if (e instanceof MissingContextVariableException) {
                this.reportMissingContextVariableException(context, (MissingContextVariableException)e);
            }
            context.onFailure(e);
            s = null;
            sync = true;
        }
        finally {
            Thread.currentThread().setContextClassLoader(originalLoader);
        }
        if (sync) {
            assert (context.bodyInvokers.isEmpty()) : "If a step claims synchronous completion, it shouldn't invoke body";
            if (context.getOutcome() == null) {
                context.onFailure((Throwable)((Object)new AssertionError((Object)("Step " + s + " claimed to have ended synchronously, but didn't set the result via StepContext.onSuccess/onFailure"))));
            }
            thread.setStep(null);
            if (an instanceof StepStartNode) {
                thread.head.setNewHead((FlowNode)new StepEndNode(this.exec, (StepStartNode)an, new FlowNode[]{an}));
            }
            thread.head.markIfFail(context.getOutcome());
            return context.replay();
        }
        Continuable.suspend((Object)new ThreadTaskImpl(context));
        throw new AssertionError();
    }

    private static String loadSoleArgumentKey(StepDescriptor d) {
        try {
            String[] names = new ClassDescriptor(d.clazz, new Class[0]).loadConstructorParamNames();
            return names.length == 1 ? names[0] : null;
        }
        catch (NoStaplerConstructorException e) {
            return null;
        }
    }

    protected Object invokeDescribable(String symbol, Object _args) {
        List metaSteps = StepDescriptor.metaStepsOf((String)symbol);
        StepDescriptor metaStep = metaSteps.size() == 1 ? (StepDescriptor)metaSteps.get(0) : null;
        boolean singleArgumentOnly = false;
        if (metaStep != null) {
            Descriptor symbolDescriptor = SymbolLookup.get().findDescriptor(metaStep.getMetaStepArgumentType(), symbol);
            DescribableModel symbolModel = DescribableModel.of((Class)symbolDescriptor.clazz);
            singleArgumentOnly = symbolModel.hasSingleRequiredParameter() && symbolModel.getParameters().size() == 1;
        }
        NamedArgsAndClosure args = DSL.parseArgs(_args, metaStep != null && metaStep.takesImplicitBlockArgument(), "<anonymous>", singleArgumentOnly);
        UninstantiatedDescribable ud = new UninstantiatedDescribable(symbol, null, args.namedArgs);
        if (metaStep == null) {
            return ud;
        }
        Descriptor d = SymbolLookup.get().findDescriptor(metaStep.getMetaStepArgumentType(), symbol);
        try {
            DescribableModel mm = DescribableModel.of((Class)metaStep.clazz);
            DescribableModel dm = DescribableModel.of((Class)d.clazz);
            DescribableParameter p = mm.getFirstRequiredParameter();
            if (p == null) {
                throw new IllegalArgumentException("Attempted to use meta-step " + metaStep.getFunctionName() + " to process " + symbol + " but this meta-step is buggy; it has no mandatory parameter");
            }
            TreeMap margs = new TreeMap();
            TreeMap dargs = new TreeMap();
            for (Map.Entry e : ud.getArguments().entrySet()) {
                String n = (String)e.getKey();
                Object v = e.getValue();
                DescribableParameter mp = mm.getParameter(n);
                DescribableParameter dp = dm.getParameter(n);
                if (mp != null && mp.isRequired()) {
                    margs.put(n, v);
                    continue;
                }
                if (dp != null && dp.isRequired()) {
                    dargs.put(n, v);
                    continue;
                }
                if (mp != null) {
                    margs.put(n, v);
                    continue;
                }
                dargs.put(n, v);
            }
            ud = new UninstantiatedDescribable(symbol, null, dargs);
            margs.put(p.getName(), ud);
            return this.invokeStep(metaStep, new NamedArgsAndClosure(margs, args.body));
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Failed to prepare " + symbol + " step", e);
        }
    }

    private void reportMissingContextVariableException(CpsStepContext context, MissingContextVariableException e) {
        TaskListener tl;
        try {
            tl = (TaskListener)context.get(TaskListener.class);
            if (tl == null) {
                return;
            }
        }
        catch (IOException _) {
            return;
        }
        catch (InterruptedException _) {
            return;
        }
        StringBuilder names = new StringBuilder();
        for (StepDescriptor p : e.getProviders()) {
            if (names.length() > 0) {
                names.append(',');
            }
            names.append(p.getFunctionName());
        }
        PrintStream logger = tl.getLogger();
        logger.println(e.getMessage());
        if (names.length() > 0) {
            logger.println("Perhaps you forgot to surround the code with a step that provides this, such as: " + names);
        }
    }

    private static int preallocatedHashmapCapacity(int elementsToHold) {
        if (elementsToHold == 0) {
            return 0;
        }
        if (elementsToHold < 3) {
            return elementsToHold + 1;
        }
        return elementsToHold + elementsToHold / 3;
    }

    private static Object flattenGString(Object v) {
        if (v instanceof GString) {
            return v.toString();
        }
        if (v instanceof List) {
            boolean mutated = false;
            ArrayList<Object> r = new ArrayList<Object>();
            for (Object o : (List)v) {
                Object o2;
                mutated |= o != (o2 = DSL.flattenGString(o));
                r.add(o2);
            }
            return mutated ? r : v;
        }
        if (v instanceof Map) {
            boolean mutated = false;
            LinkedHashMap<Object, Object> r = new LinkedHashMap<Object, Object>(DSL.preallocatedHashmapCapacity(((Map)v).size()));
            for (Map.Entry e : ((Map)v).entrySet()) {
                Object k = e.getKey();
                Object k2 = DSL.flattenGString(k);
                Object o = e.getValue();
                Object o2 = DSL.flattenGString(o);
                mutated |= k != k2 || o != o2;
                r.put(k2, o2);
            }
            return mutated ? r : v;
        }
        return v;
    }

    static NamedArgsAndClosure parseArgs(Object arg, StepDescriptor d) {
        boolean singleArgumentOnly = false;
        try {
            DescribableModel stepModel = DescribableModel.of((Class)d.clazz);
            boolean bl = singleArgumentOnly = stepModel.hasSingleRequiredParameter() && stepModel.getParameters().size() == 1;
            if (singleArgumentOnly) {
                DescribableParameter dp = stepModel.getSoleRequiredParameter();
                String paramName = dp != null ? dp.getName() : null;
                return DSL.parseArgs(arg, d.takesImplicitBlockArgument(), paramName, singleArgumentOnly);
            }
        }
        catch (NoStaplerConstructorException noStaplerConstructorException) {
            // empty catch block
        }
        return DSL.parseArgs(arg, d.takesImplicitBlockArgument(), DSL.loadSoleArgumentKey(d), singleArgumentOnly);
    }

    static NamedArgsAndClosure parseArgs(Object arg, boolean expectsBlock, String soleArgumentKey, boolean singleRequiredArg) {
        if (arg instanceof NamedArgsAndClosure) {
            return (NamedArgsAndClosure)arg;
        }
        if (arg instanceof Map) {
            return new NamedArgsAndClosure((Map)arg, null);
        }
        if (arg instanceof Closure && expectsBlock) {
            return new NamedArgsAndClosure(Collections.emptyMap(), (Closure)arg);
        }
        if (arg instanceof Object[]) {
            List<Object> a = Arrays.asList((Object[])arg);
            if (a.size() == 0) {
                return new NamedArgsAndClosure(Collections.emptyMap(), null);
            }
            Closure c = null;
            Object last = a.get(a.size() - 1);
            if (last instanceof Closure && expectsBlock) {
                c = (Closure)last;
                a = a.subList(0, a.size() - 1);
            }
            if (a.size() == 1 && a.get(0) instanceof Map && !((Map)a.get(0)).containsKey("$class")) {
                Map mapArg = (Map)a.get(0);
                if (!singleRequiredArg || soleArgumentKey != null && mapArg.size() == 1 && mapArg.containsKey(soleArgumentKey)) {
                    return new NamedArgsAndClosure(mapArg, c);
                }
            }
            switch (a.size()) {
                case 0: {
                    return new NamedArgsAndClosure(Collections.emptyMap(), c);
                }
                case 1: {
                    return new NamedArgsAndClosure(DSL.singleParam(soleArgumentKey, a.get(0)), c);
                }
            }
            throw new IllegalArgumentException("Expected named arguments but got " + a);
        }
        return new NamedArgsAndClosure(DSL.singleParam(soleArgumentKey, arg), null);
    }

    private static Map<String, Object> singleParam(String soleArgumentKey, Object arg) {
        if (soleArgumentKey != null) {
            return Collections.singletonMap(soleArgumentKey, arg);
        }
        throw new IllegalArgumentException("Expected named arguments but got " + arg);
    }

    private static class ThreadTaskImpl
    extends ThreadTask
    implements Serializable {
        private final CpsStepContext context;
        private static final long serialVersionUID = 1L;

        public ThreadTaskImpl(CpsStepContext context) {
            this.context = context;
        }

        @Override
        protected ThreadTaskResult eval(CpsThread cur) {
            this.invokeBody(cur);
            if (!this.context.switchToAsyncMode()) {
                return ThreadTaskResult.resumeWith(this.context.getOutcome());
            }
            return ThreadTaskResult.suspendWith(new Outcome((Object)this.context, null));
        }

        private void invokeBody(CpsThread cur) {
            FlowHead[] heads = new FlowHead[this.context.bodyInvokers.size()];
            for (int i = 0; i < heads.length; ++i) {
                heads[i] = i == 0 ? cur.head : cur.head.fork();
            }
            int idx = 0;
            for (CpsBodyInvoker b : this.context.bodyInvokers) {
                FlowHead h = heads[idx];
                b.launch(cur, h);
                this.context.bodyHeads.add(h.getId());
                ++idx;
            }
            this.context.bodyInvokers.clear();
        }

        private static class HeadCollector
        extends BodyExecutionCallback {
            private final CpsStepContext context;
            private final FlowHead head;

            public HeadCollector(CpsStepContext context, FlowHead head) {
                this.context = context;
                this.head = head;
            }

            private void onEnd() {
            }

            public void onSuccess(StepContext context, Object result) {
                this.onEnd();
            }

            public void onFailure(StepContext context, Throwable t) {
                this.onEnd();
            }
        }
    }

    static class NamedArgsAndClosure {
        final Map<String, Object> namedArgs;
        final Closure body;

        private NamedArgsAndClosure(Map<?, ?> namedArgs, Closure body) {
            this.namedArgs = new LinkedHashMap<String, Object>(DSL.preallocatedHashmapCapacity(namedArgs.size()));
            this.body = body;
            for (Map.Entry<?, ?> entry : namedArgs.entrySet()) {
                String k = entry.getKey().toString().intern();
                Object v = DSL.flattenGString(entry.getValue());
                this.namedArgs.put(k, v);
            }
        }
    }
}

