/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.workflow.cps;

import com.cloudbees.groovy.cps.Outcome;
import com.google.common.annotations.VisibleForTesting;
import hudson.model.Action;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Collections;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.Nonnull;
import org.jenkinsci.plugins.workflow.actions.ErrorAction;
import org.jenkinsci.plugins.workflow.actions.FlowNodeAction;
import org.jenkinsci.plugins.workflow.actions.TimingAction;
import org.jenkinsci.plugins.workflow.cps.CpsFlowExecution;
import org.jenkinsci.plugins.workflow.cps.CpsThreadGroup;
import org.jenkinsci.plugins.workflow.graph.BlockStartNode;
import org.jenkinsci.plugins.workflow.graph.FlowNode;
import org.jenkinsci.plugins.workflow.graph.FlowStartNode;

final class FlowHead
implements Serializable {
    private int id;
    private transient CpsFlowExecution execution;
    @VisibleForTesting
    FlowNode head;
    private static final Logger LOGGER = Logger.getLogger(FlowHead.class.getName());
    private static final long serialVersionUID = 1L;

    FlowHead(CpsFlowExecution execution, int id) {
        this.id = id;
        this.execution = execution;
    }

    FlowHead(CpsFlowExecution execution) {
        this(execution, execution.iota());
    }

    public FlowHead fork() {
        FlowHead h = new FlowHead(this.execution);
        h.head = this.head;
        this.execution.addHead(h);
        return h;
    }

    public int getId() {
        return this.id;
    }

    public CpsFlowExecution getExecution() {
        return this.execution;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void newStartNode(FlowStartNode n) throws IOException {
        if (this.execution.flowStartNodeActions != null) {
            for (Action a : this.execution.flowStartNodeActions) {
                if (a instanceof FlowNodeAction) {
                    ((FlowNodeAction)a).onLoad((FlowNode)n);
                }
                n.addAction(a);
            }
            this.execution.flowStartNodeActions.clear();
        }
        CpsFlowExecution cpsFlowExecution = this.execution;
        synchronized (cpsFlowExecution) {
            this.head = (FlowNode)this.execution.startNodes.push((BlockStartNode)n);
        }
        this.execution.storage.storeNode(this.head, false);
    }

    void setNewHead(@Nonnull FlowNode v) {
        if (v == null) {
            throw new IllegalArgumentException("FlowHead.setNewHead called on FlowHead id=" + this.id + " with a null FlowNode, execution=" + (Object)((Object)this.execution));
        }
        try {
            if (this.head != null) {
                CpsFlowExecution.maybeAutoPersistNode(this.head);
                assert (this.execution.storage.getNode(this.head.getId()) != null);
            }
            this.execution.storage.storeNode(v, true);
            assert (this.execution.storage.getNode(v.getId()) != null);
            v.addAction((Action)new TimingAction());
            CpsFlowExecution.maybeAutoPersistNode(v);
        }
        catch (Exception e) {
            LOGGER.log(Level.WARNING, "Failed to record new head or persist old: " + v, e);
        }
        this.head = v;
        CpsThreadGroup c = CpsThreadGroup.current();
        if (c != null) {
            c.notifyNewHead(v);
        } else {
            this.execution.notifyListeners(Collections.singletonList(v), true);
            this.execution.notifyListeners(Collections.singletonList(v), false);
        }
    }

    FlowNode get() {
        return this.head;
    }

    public void markIfFail(Outcome o) {
        if (o.isFailure()) {
            this.get().addAction((Action)new ErrorAction(o.getAbnormal()));
        }
    }

    void setForDeserialize(FlowNode v) {
        this.head = v;
    }

    void remove() {
        this.getExecution().removeHead(this);
    }

    private void writeObject(ObjectOutputStream oos) throws IOException {
        oos.writeInt(this.id);
    }

    private void readObject(ObjectInputStream ois) throws IOException, ClassNotFoundException {
        this.id = ois.readInt();
    }

    @Nonnull
    private Object readResolve() {
        this.execution = CpsFlowExecution.PROGRAM_STATE_SERIALIZATION.get();
        if (this.execution != null) {
            FlowHead myHead = this.execution.getFlowHead(this.id);
            if (myHead == null) {
                throw new IllegalStateException("FlowHead loading problem at deserialize: Null FlowHead with id " + this.id + " in execution " + (Object)((Object)this.execution));
            }
            return myHead;
        }
        LOGGER.log(Level.WARNING, "Tried to load a FlowHead from program with no Execution in PROGRAM_STATE_SERIALIZATION");
        return this;
    }

    public String toString() {
        return this.id + ":" + this.head;
    }
}

