/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.workflow.cps;

import groovy.lang.GroovyClassLoader;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Collection;
import org.jenkinsci.plugins.scriptsecurity.sandbox.Whitelist;

class GroovyClassLoaderWhitelist
extends Whitelist {
    private final Collection<ClassLoader> scriptLoaders;
    private final Whitelist delegate;

    GroovyClassLoaderWhitelist(Whitelist delegate, GroovyClassLoader ... scriptLoaders) {
        this.scriptLoaders = Arrays.asList(scriptLoaders);
        this.delegate = delegate;
    }

    private boolean permits(Class<?> declaringClass) {
        ClassLoader cl = declaringClass.getClassLoader();
        if (cl instanceof GroovyClassLoader.InnerLoader) {
            return this.scriptLoaders.contains(cl.getParent());
        }
        return this.scriptLoaders.contains(cl);
    }

    public boolean permitsMethod(Method method, Object receiver, Object[] args) {
        return this.permits(method.getDeclaringClass()) || this.delegate.permitsMethod(method, receiver, args);
    }

    public boolean permitsConstructor(Constructor<?> constructor, Object[] args) {
        return this.permits(constructor.getDeclaringClass()) || this.delegate.permitsConstructor(constructor, args);
    }

    public boolean permitsStaticMethod(Method method, Object[] args) {
        return this.permits(method.getDeclaringClass()) || this.delegate.permitsStaticMethod(method, args);
    }

    public boolean permitsFieldGet(Field field, Object receiver) {
        return this.permits(field.getDeclaringClass()) || this.delegate.permitsFieldGet(field, receiver);
    }

    public boolean permitsFieldSet(Field field, Object receiver, Object value) {
        return this.permits(field.getDeclaringClass()) || this.delegate.permitsFieldSet(field, receiver, value);
    }

    public boolean permitsStaticFieldGet(Field field) {
        return this.permits(field.getDeclaringClass()) || this.delegate.permitsStaticFieldGet(field);
    }

    public boolean permitsStaticFieldSet(Field field, Object value) {
        return this.permits(field.getDeclaringClass()) || this.delegate.permitsStaticFieldSet(field, value);
    }
}

