/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.workflow.cps;

import hudson.Extension;
import hudson.model.ParameterDefinition;
import hudson.model.ParameterValue;
import hudson.model.ParametersAction;
import hudson.model.ParametersDefinitionProperty;
import hudson.model.Run;
import java.io.Serializable;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jenkinsci.plugins.workflow.cps.CpsScript;
import org.jenkinsci.plugins.workflow.cps.GlobalVariable;
import org.jenkinsci.plugins.workflow.pickles.PickleFactory;

@Extension
public class ParamsVariable
extends GlobalVariable {
    @Override
    public String getName() {
        return "params";
    }

    @Override
    public Object getValue(CpsScript script) throws Exception {
        ParametersDefinitionProperty prop;
        Run<?, ?> b = script.$build();
        if (b == null) {
            throw new IllegalStateException("cannot find owning build");
        }
        HashMap<String, Object> values = new HashMap<String, Object>();
        ParametersAction action = (ParametersAction)b.getAction(ParametersAction.class);
        if (action != null) {
            List parameterValues;
            try {
                parameterValues = (List)ParametersAction.class.getMethod("getAllParameters", new Class[0]).invoke((Object)action, new Object[0]);
            }
            catch (NoSuchMethodException x) {
                parameterValues = action.getParameters();
            }
            for (ParameterValue parameterValue : parameterValues) {
                ParamsVariable.addValue(values, parameterValue);
            }
        }
        if ((prop = (ParametersDefinitionProperty)b.getParent().getProperty(ParametersDefinitionProperty.class)) != null) {
            for (ParameterDefinition param : prop.getParameterDefinitions()) {
                ParameterValue defaultParameterValue;
                if (values.containsKey(param.getName()) || (defaultParameterValue = param.getDefaultParameterValue()) == null) continue;
                ParamsVariable.addValue(values, defaultParameterValue);
            }
        }
        return Collections.unmodifiableMap(values);
    }

    private static void addValue(Map<String, Object> values, ParameterValue parameterValue) {
        Object value = parameterValue.getValue();
        if (value != null && !(value instanceof Serializable)) {
            boolean canPickle = false;
            for (PickleFactory pf : PickleFactory.all()) {
                if (pf.writeReplace(value) == null) continue;
                canPickle = true;
                break;
            }
            if (!canPickle) {
                return;
            }
        }
        values.put(parameterValue.getName(), value);
    }
}

