/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.workflow.cps;

import com.cloudbees.groovy.cps.Continuable;
import com.cloudbees.groovy.cps.Outcome;
import groovy.lang.GroovyShell;
import hudson.Extension;
import hudson.MarkupText;
import hudson.console.ConsoleAnnotationDescriptor;
import hudson.console.ConsoleAnnotator;
import hudson.console.ConsoleNote;
import java.io.IOException;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.CheckForNull;
import jenkins.model.Jenkins;
import org.jenkinsci.Symbol;
import org.jenkinsci.plugins.scriptsecurity.sandbox.RejectedAccessException;
import org.jenkinsci.plugins.scriptsecurity.sandbox.Whitelist;
import org.jenkinsci.plugins.scriptsecurity.sandbox.groovy.GroovySandbox;
import org.jenkinsci.plugins.scriptsecurity.scripts.ApprovalContext;
import org.jenkinsci.plugins.scriptsecurity.scripts.ScriptApproval;
import org.jenkinsci.plugins.workflow.cps.CpsFlowExecution;
import org.jenkinsci.plugins.workflow.cps.CpsThread;
import org.jenkinsci.plugins.workflow.cps.CpsWhitelist;
import org.jenkinsci.plugins.workflow.cps.GroovyClassLoaderWhitelist;
import org.jenkinsci.plugins.workflow.cps.Messages;
import org.kohsuke.stapler.Stapler;
import org.kohsuke.stapler.StaplerRequest;

class SandboxContinuable
extends Continuable {
    private final CpsThread thread;
    private static final Logger LOGGER = Logger.getLogger(SandboxContinuable.class.getName());

    SandboxContinuable(Continuable src, CpsThread thread) {
        super(src);
        this.thread = thread;
    }

    public Outcome run0(Outcome cn, List<Class> categories) {
        try {
            CpsFlowExecution e = this.thread.group.getExecution();
            if (e == null) {
                throw new IllegalStateException("JENKINS-50407: no loaded execution");
            }
            GroovyShell shell = e.getShell();
            if (shell == null) {
                throw new IllegalStateException("JENKINS-50407: no loaded shell in " + (Object)((Object)e));
            }
            GroovyShell trustedShell = e.getTrustedShell();
            if (trustedShell == null) {
                throw new IllegalStateException("JENKINS-50407: no loaded trustedShell in " + (Object)((Object)e));
            }
            return (Outcome)GroovySandbox.runInSandbox(() -> {
                Outcome outcome = SandboxContinuable.super.run0(cn, categories);
                RejectedAccessException x = SandboxContinuable.findRejectedAccessException(outcome.getAbnormal());
                if (x != null) {
                    ScriptApproval.get().accessRejected(x, ApprovalContext.create());
                    try {
                        e.getOwner().getListener().getLogger().println(x.getMessage() + ". " + ScriptApprovalNote.encodeTo(Messages.SandboxContinuable_ScriptApprovalLink()));
                    }
                    catch (IOException ex) {
                        LOGGER.log(Level.WARNING, null, ex);
                    }
                }
                return outcome;
            }, (Whitelist)new GroovyClassLoaderWhitelist(CpsWhitelist.get(), trustedShell.getClassLoader(), shell.getClassLoader()));
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new AssertionError((Object)e);
        }
    }

    @CheckForNull
    private static RejectedAccessException findRejectedAccessException(@CheckForNull Throwable t) {
        if (t == null) {
            return null;
        }
        if (t instanceof RejectedAccessException) {
            return (RejectedAccessException)t;
        }
        return SandboxContinuable.findRejectedAccessException(t.getCause());
    }

    public static final class ScriptApprovalNote
    extends ConsoleNote {
        private int length;

        public ScriptApprovalNote(int length) {
            this.length = length;
        }

        public ConsoleAnnotator annotate(Object context, MarkupText text, int charPos) {
            if (Jenkins.getActiveInstance().hasPermission(Jenkins.RUN_SCRIPTS)) {
                String url = "/" + ScriptApproval.get().getUrlName();
                StaplerRequest req = Stapler.getCurrentRequest();
                url = req != null ? req.getContextPath() + url : Jenkins.getInstance().getRootUrl() + url.substring(1);
                text.addMarkup(charPos, charPos + this.length, "<a href='" + url + "'>", "</a>");
            }
            return null;
        }

        public static String encodeTo(String text) {
            try {
                return new ScriptApprovalNote(text.length()).encode() + text;
            }
            catch (IOException e) {
                LOGGER.log(Level.WARNING, "Failed to serialize " + ScriptApprovalNote.class, e);
                return text;
            }
        }

        @Extension
        @Symbol(value={"scriptApprovalLink"})
        public static class DescriptorImpl
        extends ConsoleAnnotationDescriptor {
            public String getDisplayName() {
                return "Script Approval Link";
            }
        }
    }
}

