/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.workflow.cps;

import hudson.Extension;
import hudson.ExtensionPoint;
import hudson.model.Item;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.Nonnull;
import org.jenkinsci.plugins.workflow.cps.Messages;
import org.kohsuke.stapler.Stapler;
import org.kohsuke.stapler.StaplerRequest;

public abstract class SnippetizerLink
implements ExtensionPoint {
    private static final Logger LOGGER = Logger.getLogger(SnippetizerLink.class.getName());

    @Nonnull
    public abstract String getUrl();

    @Nonnull
    public final String getDisplayUrl() {
        String u = this.getUrl();
        try {
            if (new URI(u).isAbsolute()) {
                return u;
            }
        }
        catch (URISyntaxException e) {
            LOGGER.log(Level.WARNING, "Failed to parse URL for " + u, e);
            return "";
        }
        StaplerRequest req = Stapler.getCurrentRequest();
        if (req == null) {
            return u;
        }
        Item i = (Item)req.findAncestorObject(Item.class);
        StringBuilder toAppend = new StringBuilder();
        toAppend.append(req.getContextPath());
        if (!req.getContextPath().endsWith("/")) {
            toAppend.append("/");
        }
        if (i == null) {
            toAppend.append(u);
        } else {
            toAppend.append(i.getUrl());
            if (!i.getUrl().endsWith("/")) {
                toAppend.append("/");
            }
            toAppend.append(u);
        }
        return toAppend.toString();
    }

    @Nonnull
    public String getIcon() {
        return "icon-help icon-md";
    }

    @Nonnull
    public abstract String getDisplayName();

    public boolean inNewWindow() {
        return false;
    }

    @Extension(ordinal=600.0)
    public static class GDSLLink
    extends SnippetizerLink {
        @Override
        @Nonnull
        public String getUrl() {
            return "pipeline-syntax/gdsl";
        }

        @Override
        @Nonnull
        public String getDisplayName() {
            return Messages.SnippetizerLink_GDSLLink_displayName();
        }

        @Override
        public boolean inNewWindow() {
            return true;
        }
    }

    @Extension(ordinal=700.0)
    public static class OnlineDocsLink
    extends SnippetizerLink {
        @Override
        @Nonnull
        public String getUrl() {
            return "https://jenkins.io/doc/pipeline/";
        }

        @Override
        @Nonnull
        public String getDisplayName() {
            return Messages.SnippetizerLink_OnlineDocsLink_displayName();
        }

        @Override
        public boolean inNewWindow() {
            return true;
        }
    }

    @Extension(ordinal=800.0)
    public static class GlobalsReferenceLink
    extends SnippetizerLink {
        @Override
        @Nonnull
        public String getUrl() {
            return "pipeline-syntax/globals";
        }

        @Override
        @Nonnull
        public String getDisplayName() {
            return Messages.SnippetizerLink_GlobalsReferenceLink_displayName();
        }
    }

    @Extension(ordinal=900.0)
    public static class StepReferenceLink
    extends SnippetizerLink {
        @Override
        @Nonnull
        public String getUrl() {
            return "pipeline-syntax/html";
        }

        @Override
        @Nonnull
        public String getDisplayName() {
            return Messages.SnippetizerLink_StepReferenceLink_displayName();
        }
    }

    @Extension(ordinal=1000.0)
    public static class GeneratorLink
    extends SnippetizerLink {
        @Override
        @Nonnull
        public String getUrl() {
            return "pipeline-syntax";
        }

        @Override
        @Nonnull
        public String getIcon() {
            return "icon-gear2 icon-md";
        }

        @Override
        @Nonnull
        public String getDisplayName() {
            return Messages.SnippetizerLink_GeneratorLink_displayName();
        }
    }
}

