/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.workflow.cps.nodes;

import hudson.model.Describable;
import hudson.model.Descriptor;
import java.io.ObjectStreamException;
import java.util.Collections;
import java.util.Set;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import jenkins.model.Jenkins;
import org.jenkinsci.plugins.structs.SymbolLookup;
import org.jenkinsci.plugins.structs.describable.DescribableModel;
import org.jenkinsci.plugins.structs.describable.DescribableParameter;
import org.jenkinsci.plugins.structs.describable.UninstantiatedDescribable;
import org.jenkinsci.plugins.workflow.actions.ArgumentsAction;
import org.jenkinsci.plugins.workflow.cps.CpsFlowExecution;
import org.jenkinsci.plugins.workflow.cps.nodes.StepDescriptorCache;
import org.jenkinsci.plugins.workflow.cps.nodes.StepNode;
import org.jenkinsci.plugins.workflow.flow.FlowExecution;
import org.jenkinsci.plugins.workflow.graph.AtomNode;
import org.jenkinsci.plugins.workflow.graph.FlowNode;
import org.jenkinsci.plugins.workflow.steps.StepDescriptor;

public class StepAtomNode
extends AtomNode
implements StepNode {
    private String descriptorId;
    private transient StepDescriptor descriptor;

    public StepAtomNode(CpsFlowExecution exec, StepDescriptor d, FlowNode parent) {
        super((FlowExecution)exec, exec.iotaStr(), new FlowNode[]{parent});
        this.descriptorId = d != null ? d.getId().intern() : null;
        this.setActions(Collections.emptyList());
    }

    public StepDescriptor getDescriptor() {
        if (this.descriptor == null && this.descriptorId != null) {
            this.descriptor = StepDescriptorCache.getPublicCache().getDescriptor(this.descriptorId);
        }
        return this.descriptor;
    }

    protected Object readResolve() throws ObjectStreamException {
        if (this.descriptorId != null) {
            this.descriptorId = this.descriptorId.intern();
        }
        return super.readResolve();
    }

    @CheckForNull
    static String effectiveDisplayName(@Nonnull org.jenkinsci.plugins.workflow.graph.StepNode node) {
        Descriptor descriptor;
        StepDescriptor d = node.getDescriptor();
        if (d == null) {
            return null;
        }
        Class<?> delegateType = StepAtomNode.getDelegateType((FlowNode)node, d);
        if (delegateType != null && Describable.class.isAssignableFrom(delegateType) && (descriptor = Jenkins.getInstance().getDescriptor(delegateType.asSubclass(Describable.class))) != null) {
            return descriptor.getDisplayName();
        }
        return d.getDisplayName();
    }

    protected String getTypeDisplayName() {
        String n = StepAtomNode.effectiveDisplayName(this);
        return n != null ? n : this.descriptorId;
    }

    @CheckForNull
    static String effectiveFunctionName(@Nonnull org.jenkinsci.plugins.workflow.graph.StepNode node) {
        Set symbols;
        StepDescriptor d = node.getDescriptor();
        if (d == null) {
            return null;
        }
        Class<?> delegateType = StepAtomNode.getDelegateType((FlowNode)node, d);
        if (delegateType != null && !(symbols = SymbolLookup.getSymbolValue(delegateType)).isEmpty()) {
            return (String)symbols.iterator().next();
        }
        return d.getFunctionName();
    }

    protected String getTypeFunctionName() {
        String fn = StepAtomNode.effectiveFunctionName(this);
        return fn != null ? fn : this.descriptorId;
    }

    @CheckForNull
    private static Class<?> getDelegateType(@Nonnull FlowNode node, @Nonnull StepDescriptor d) {
        DescribableModel delegateModel;
        Object arg;
        DescribableParameter p;
        if (d.isMetaStep() && (p = DescribableModel.of((Class)d.clazz).getFirstRequiredParameter()) != null && (arg = ArgumentsAction.getResolvedArguments((FlowNode)node).get(p.getName())) instanceof UninstantiatedDescribable && (delegateModel = ((UninstantiatedDescribable)arg).getModel()) != null) {
            return delegateModel.getType();
        }
        return null;
    }
}

