/*
 * Decompiled with CFR 0.152.
 */
package jenkins.plugins.publish_over_ssh;

import hudson.Util;
import hudson.model.Describable;
import jenkins.model.Jenkins;
import jenkins.plugins.publish_over.BPTransfer;
import jenkins.plugins.publish_over_ssh.descriptor.BapSshTransferDescriptor;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.apache.commons.lang.builder.ToStringStyle;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;

public class BapSshTransfer
extends BPTransfer
implements Describable<BapSshTransfer> {
    private static final long serialVersionUID = 1L;
    private String execCommand;
    private int execTimeout;
    private boolean usePty;
    private boolean useAgentForwarding;

    BapSshTransfer(String sourceFiles, String remoteDirectory, String removePrefix, boolean remoteDirectorySDF, boolean flatten, String execCommand, int execTimeout) {
        this(sourceFiles, null, remoteDirectory, removePrefix, remoteDirectorySDF, flatten, execCommand, execTimeout, false, false, false, null);
    }

    @DataBoundConstructor
    public BapSshTransfer(String sourceFiles, String excludes, String remoteDirectory, String removePrefix, boolean remoteDirectorySDF, boolean flatten, String execCommand, int execTimeout, boolean usePty, boolean noDefaultExcludes, boolean makeEmptyDirs, String patternSeparator) {
        super(sourceFiles, excludes, remoteDirectory, removePrefix, remoteDirectorySDF, flatten, false, noDefaultExcludes, makeEmptyDirs, patternSeparator);
        this.execCommand = execCommand;
        this.execTimeout = execTimeout;
        this.usePty = usePty;
        this.useAgentForwarding = false;
    }

    public String getExecCommand() {
        return this.execCommand;
    }

    @DataBoundSetter
    public void setExecCommand(String execCommand) {
        this.execCommand = execCommand;
    }

    public int getExecTimeout() {
        return this.execTimeout;
    }

    @DataBoundSetter
    public void setExecTimeout(int execTimeout) {
        this.execTimeout = execTimeout;
    }

    public boolean hasExecCommand() {
        return Util.fixEmptyAndTrim((String)this.getExecCommand()) != null;
    }

    public boolean isUsePty() {
        return this.usePty;
    }

    @DataBoundSetter
    public void setUsePty(boolean usePty) {
        this.usePty = usePty;
    }

    public boolean isUseAgentForwarding() {
        return this.useAgentForwarding;
    }

    @DataBoundSetter
    public void setUseAgentForwarding(boolean value) {
        this.useAgentForwarding = value;
    }

    public BapSshTransferDescriptor getDescriptor() {
        return (BapSshTransferDescriptor)Jenkins.getActiveInstance().getDescriptorByType(BapSshTransferDescriptor.class);
    }

    protected HashCodeBuilder addToHashCode(HashCodeBuilder builder) {
        return super.addToHashCode(builder).append((Object)this.execCommand).append(this.execTimeout).append(this.usePty).append(this.useAgentForwarding);
    }

    protected EqualsBuilder addToEquals(EqualsBuilder builder, BapSshTransfer that) {
        return super.addToEquals(builder, (BPTransfer)that).append((Object)this.execCommand, (Object)that.execCommand).append(this.execTimeout, that.execTimeout).append(this.usePty, that.usePty).append(this.useAgentForwarding, that.useAgentForwarding);
    }

    protected ToStringBuilder addToToString(ToStringBuilder builder) {
        return super.addToToString(builder).append("execCommand", (Object)this.execCommand).append("execTimeout", this.execTimeout).append("pseudoTty", this.usePty).append("agentForwarding", this.useAgentForwarding);
    }

    public boolean equals(Object that) {
        if (this == that) {
            return true;
        }
        if (that == null || ((Object)((Object)this)).getClass() != that.getClass()) {
            return false;
        }
        return this.addToEquals(new EqualsBuilder(), (BapSshTransfer)((Object)that)).isEquals();
    }

    public int hashCode() {
        return this.addToHashCode(new HashCodeBuilder()).toHashCode();
    }

    public String toString() {
        return this.addToToString(new ToStringBuilder((Object)this, ToStringStyle.SHORT_PREFIX_STYLE)).toString();
    }
}

