/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.tasks;

import hudson.plugins.tasks.Messages;
import hudson.plugins.tasks.TasksResult;

public final class ResultSummary {
    public static String createSummary(TasksResult result) {
        StringBuilder summary = ResultSummary.createBuilder();
        int tasks = result.getNumberOfAnnotations();
        summary.append(Messages.Tasks_ResultAction_Summary());
        summary.append(' ');
        if (tasks > 0) {
            summary.append("<a href=\"tasksResult\">");
        }
        if (tasks == 1) {
            summary.append(Messages.Tasks_ResultAction_OneWarning());
        } else {
            summary.append(Messages.Tasks_ResultAction_MultipleWarnings(tasks));
        }
        if (tasks > 0) {
            summary.append("</a>");
        }
        summary.append(' ');
        if (result.getNumberOfFiles() > 1) {
            summary.append(Messages.Tasks_ResultAction_MultipleFiles(result.getNumberOfFiles()));
        } else {
            summary.append(Messages.Tasks_ResultAction_OneFile());
        }
        summary.append('.');
        return summary.toString();
    }

    private static StringBuilder createBuilder() {
        return new StringBuilder(512);
    }

    public static String createDeltaMessage(TasksResult result) {
        StringBuilder summary = ResultSummary.createBuilder();
        if (result.getNumberOfNewWarnings() > 0) {
            summary.append("<li><a href=\"tasksResult/new\">");
            if (result.getNumberOfNewWarnings() == 1) {
                summary.append(Messages.Tasks_ResultAction_OneNewWarning());
            } else {
                summary.append(Messages.Tasks_ResultAction_MultipleNewWarnings(result.getNumberOfNewWarnings()));
            }
            summary.append("</a></li>");
        }
        if (result.getNumberOfFixedWarnings() > 0) {
            summary.append("<li><a href=\"tasksResult/fixed\">");
            if (result.getNumberOfFixedWarnings() == 1) {
                summary.append(Messages.Tasks_ResultAction_OneFixedWarning());
            } else {
                summary.append(Messages.Tasks_ResultAction_MultipleFixedWarnings(result.getNumberOfFixedWarnings()));
            }
            summary.append("</a></li>");
        }
        return summary.toString();
    }

    private ResultSummary() {
    }
}

