/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.tasks;

import hudson.Launcher;
import hudson.matrix.MatrixAggregator;
import hudson.matrix.MatrixBuild;
import hudson.matrix.MatrixRun;
import hudson.model.Action;
import hudson.model.BuildListener;
import hudson.model.Run;
import hudson.plugins.analysis.core.HealthDescriptor;
import hudson.plugins.analysis.util.model.Priority;
import hudson.plugins.tasks.TasksResult;
import hudson.plugins.tasks.TasksResultAction;
import hudson.plugins.tasks.parser.TasksParserResult;
import java.io.IOException;

public class TasksAnnotationsAggregator
extends MatrixAggregator {
    private final TasksParserResult totals = new TasksParserResult();
    private final HealthDescriptor healthDescriptor;
    private final String defaultEncoding;
    private String highTags = "";
    private String normalTags = "";
    private String lowTags = "";
    private final boolean usePreviousBuildAsReference;
    private final boolean useStableBuildAsReference;

    public TasksAnnotationsAggregator(MatrixBuild build, Launcher launcher, BuildListener listener, HealthDescriptor healthDescriptor, String defaultEncoding, boolean usePreviousBuildAsReference, boolean useStableBuildAsReference) {
        super(build, launcher, listener);
        this.healthDescriptor = healthDescriptor;
        this.defaultEncoding = defaultEncoding;
        this.usePreviousBuildAsReference = usePreviousBuildAsReference;
        this.useStableBuildAsReference = useStableBuildAsReference;
    }

    public boolean endRun(MatrixRun run) throws InterruptedException, IOException {
        TasksResultAction action;
        if (this.totals.hasNoAnnotations() && (action = (TasksResultAction)run.getAction(TasksResultAction.class)) != null) {
            TasksResult result = (TasksResult)action.getResult();
            this.totals.addAnnotations(result.getAnnotations());
            this.totals.addScannedFiles(result.getNumberOfFiles());
            this.highTags = result.getTags(Priority.HIGH);
            this.normalTags = result.getTags(Priority.NORMAL);
            this.lowTags = result.getTags(Priority.LOW);
        }
        return true;
    }

    public boolean endBuild() throws InterruptedException, IOException {
        TasksResult result = new TasksResult((Run<?, ?>)this.build, this.defaultEncoding, this.totals, this.usePreviousBuildAsReference, this.useStableBuildAsReference, this.highTags, this.normalTags, this.lowTags);
        this.build.addAction((Action)new TasksResultAction((Run<?, ?>)this.build, this.healthDescriptor, result));
        return true;
    }
}

