/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.tasks;

import hudson.Extension;
import hudson.plugins.analysis.core.PluginDescriptor;
import hudson.plugins.tasks.Messages;
import hudson.plugins.tasks.TasksPublisher;
import hudson.plugins.tasks.parser.Task;
import hudson.plugins.tasks.parser.TaskScanner;
import hudson.util.FormValidation;
import java.io.IOException;
import java.io.StringReader;
import java.util.Collection;
import org.apache.commons.lang3.StringUtils;
import org.jenkinsci.Symbol;
import org.kohsuke.stapler.QueryParameter;

@Extension(ordinal=100.0)
@Symbol(value={"openTasks"})
public final class TasksDescriptor
extends PluginDescriptor {
    private static final String ICONS_PREFIX = "/plugin/tasks/icons/";
    static final String PLUGIN_ID = "tasks";
    static final String RESULT_URL = PluginDescriptor.createResultUrlName((String)"tasks");
    static final String ICON_URL = "/plugin/tasks/icons/tasks-24x24.png";

    public TasksDescriptor() {
        super(TasksPublisher.class);
    }

    public String getDisplayName() {
        return Messages.Tasks_Publisher_Name();
    }

    public String getPluginName() {
        return PLUGIN_ID;
    }

    public String getIconUrl() {
        return ICON_URL;
    }

    public String getSummaryIconUrl() {
        return "/plugin/tasks/icons/tasks-48x48.png";
    }

    public FormValidation doCheckExample(@QueryParameter String example, @QueryParameter String high, @QueryParameter String normal, @QueryParameter String low, @QueryParameter boolean ignoreCase, @QueryParameter boolean asRegexp) throws IOException {
        if (StringUtils.isEmpty((CharSequence)example)) {
            return FormValidation.ok();
        }
        TaskScanner scanner = new TaskScanner(high, normal, low, ignoreCase, asRegexp);
        if (scanner.isInvalidPattern()) {
            return FormValidation.error((String)scanner.getErrorMessage());
        }
        Collection<Task> tasks = scanner.scan(new StringReader(example));
        if (tasks.isEmpty()) {
            return FormValidation.warning((String)Messages.Validation_NoTask());
        }
        if (tasks.size() != 1) {
            return FormValidation.warning((String)Messages.Validation_MultipleTasks(tasks.size()));
        }
        Task task = tasks.iterator().next();
        return FormValidation.ok((String)Messages.Validation_OneTask(task.getType(), task.getDetailMessage()));
    }
}

