/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.tasks;

import com.google.common.collect.Lists;
import hudson.maven.MavenAggregatedReport;
import hudson.maven.MavenBuild;
import hudson.maven.MavenModule;
import hudson.maven.MavenModuleSet;
import hudson.maven.MavenModuleSetBuild;
import hudson.model.AbstractBuild;
import hudson.model.Action;
import hudson.model.Job;
import hudson.model.Run;
import hudson.plugins.analysis.core.AbstractResultAction;
import hudson.plugins.analysis.core.HealthDescriptor;
import hudson.plugins.analysis.core.MavenResultAction;
import hudson.plugins.analysis.core.ResultAction;
import hudson.plugins.tasks.TasksProjectAction;
import hudson.plugins.tasks.TasksReporterResult;
import hudson.plugins.tasks.TasksResult;
import hudson.plugins.tasks.TasksResultAction;
import hudson.plugins.tasks.parser.TasksParserResult;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class TasksMavenResultAction
extends MavenResultAction<TasksResult> {
    private String high;
    private String normal;
    private String low;

    public TasksMavenResultAction(AbstractBuild<?, ?> owner, HealthDescriptor healthDescriptor, String defaultEncoding, String high, String normal, String low, TasksResult result) {
        super((AbstractResultAction)new TasksResultAction((Run<?, ?>)owner, healthDescriptor, result), defaultEncoding, "TASKS");
        this.initializeFields(high, normal, low);
    }

    private void initializeFields(String high, String normal, String low) {
        this.high = high;
        this.normal = normal;
        this.low = low;
    }

    public MavenAggregatedReport createAggregatedAction(MavenModuleSetBuild build, Map<MavenModule, List<MavenBuild>> moduleBuilds) {
        return new TasksMavenResultAction((AbstractBuild<?, ?>)build, (HealthDescriptor)this.getHealthDescriptor(), this.getDefaultEncoding(), this.high, this.normal, this.low, new TasksResult((Run<?, ?>)build, this.high, new TasksParserResult(), this.usePreviousBuildAsStable(), this.useOnlyStableBuildsAsReference(), this.high, this.normal, this.low));
    }

    public Action getProjectAction(MavenModuleSet moduleSet) {
        return new TasksProjectAction((Job<?, ?>)moduleSet, (Class<? extends ResultAction<TasksResult>>)TasksMavenResultAction.class);
    }

    public Class<? extends MavenResultAction<TasksResult>> getIndividualActionType() {
        return TasksMavenResultAction.class;
    }

    protected TasksResult createResult(TasksResult existingResult, TasksResult additionalResult) {
        return new TasksReporterResult(this.getOwner(), additionalResult.getDefaultEncoding(), this.aggregate(existingResult, additionalResult), existingResult.usePreviousBuildAsStable(), existingResult.useOnlyStableBuildsAsReference(), this.high, this.normal, this.low);
    }

    protected TasksParserResult aggregate(TasksResult existingResult, TasksResult additionalResult) {
        TasksParserResult aggregatedAnnotations = new TasksParserResult();
        ArrayList results = Lists.newArrayList();
        if (existingResult != null) {
            results.add(existingResult);
        }
        results.add(additionalResult);
        for (TasksResult result : results) {
            aggregatedAnnotations.addAnnotations(result.getAnnotations());
            aggregatedAnnotations.addModules(result.getModules());
            aggregatedAnnotations.addErrors(result.getErrors());
            aggregatedAnnotations.addScannedFiles(result.getNumberOfFiles());
        }
        return aggregatedAnnotations;
    }
}

