/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.tasks;

import hudson.FilePath;
import hudson.Launcher;
import hudson.matrix.MatrixAggregator;
import hudson.matrix.MatrixBuild;
import hudson.model.Action;
import hudson.model.BuildListener;
import hudson.model.Run;
import hudson.plugins.analysis.core.BuildResult;
import hudson.plugins.analysis.core.HealthAwarePublisher;
import hudson.plugins.analysis.core.HealthDescriptor;
import hudson.plugins.analysis.util.PluginLogger;
import hudson.plugins.tasks.TasksAnnotationsAggregator;
import hudson.plugins.tasks.TasksDescriptor;
import hudson.plugins.tasks.TasksResult;
import hudson.plugins.tasks.TasksResultAction;
import hudson.plugins.tasks.parser.TasksParserResult;
import hudson.plugins.tasks.parser.WorkspaceScanner;
import java.io.IOException;
import org.apache.commons.lang.StringUtils;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;

public class TasksPublisher
extends HealthAwarePublisher {
    private static final long serialVersionUID = 3787892530045641806L;
    private static final String DEFAULT_PATTERN = "**/*.java";
    private String high;
    private String normal;
    private String low;
    private boolean ignoreCase;
    private boolean asRegexp;
    private String pattern;
    private String excludePattern;
    private static final String PLUGIN_NAME = "TASKS";

    @DataBoundConstructor
    public TasksPublisher() {
        super(PLUGIN_NAME);
    }

    public String getPattern() {
        return this.pattern;
    }

    @DataBoundSetter
    public void setPattern(String pattern) {
        this.pattern = pattern;
    }

    public String getExcludePattern() {
        return this.excludePattern;
    }

    @DataBoundSetter
    public void setExcludePattern(String excludePattern) {
        this.excludePattern = excludePattern;
    }

    public String getHigh() {
        return this.high;
    }

    @DataBoundSetter
    public void setHigh(String high) {
        this.high = high;
    }

    public String getNormal() {
        return this.normal;
    }

    @DataBoundSetter
    public void setNormal(String normal) {
        this.normal = normal;
    }

    public String getLow() {
        return this.low;
    }

    @DataBoundSetter
    public void setLow(String low) {
        this.low = low;
    }

    public boolean getIgnoreCase() {
        return this.ignoreCase;
    }

    @DataBoundSetter
    public void setIgnoreCase(boolean ignoreCase) {
        this.ignoreCase = ignoreCase;
    }

    public boolean getAsRegexp() {
        return this.asRegexp;
    }

    @DataBoundSetter
    public void setAsRegexp(boolean asRegexp) {
        this.asRegexp = asRegexp;
    }

    protected BuildResult perform(Run<?, ?> build, FilePath workspace, PluginLogger logger) throws InterruptedException, IOException {
        WorkspaceScanner scanner = new WorkspaceScanner(StringUtils.defaultIfEmpty((String)this.getPattern(), (String)DEFAULT_PATTERN), this.getExcludePattern(), this.getDefaultEncoding(), this.high, this.normal, this.low, this.ignoreCase, this.shouldDetectModules(), this.asRegexp);
        TasksParserResult project = (TasksParserResult)((Object)workspace.act((FilePath.FileCallable)scanner));
        logger.logLines(project.getLogMessages());
        logger.log(String.format("Found %d open tasks.", project.getNumberOfAnnotations()));
        this.blame(project.getAnnotations(), build, workspace);
        TasksResult result = new TasksResult(build, this.getDefaultEncoding(), project, this.usePreviousBuildAsReference(), this.useOnlyStableBuildsAsReference(), this.high, this.normal, this.low);
        build.addAction((Action)new TasksResultAction(build, (HealthDescriptor)this, result));
        return result;
    }

    public TasksDescriptor getDescriptor() {
        return (TasksDescriptor)super.getDescriptor();
    }

    public MatrixAggregator createAggregator(MatrixBuild build, Launcher launcher, BuildListener listener) {
        return new TasksAnnotationsAggregator(build, launcher, listener, (HealthDescriptor)this, this.getDefaultEncoding(), this.usePreviousBuildAsReference(), this.useOnlyStableBuildsAsReference());
    }
}

