/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.tasks;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import hudson.FilePath;
import hudson.maven.MavenAggregatedReport;
import hudson.maven.MavenBuild;
import hudson.maven.MavenBuildProxy;
import hudson.maven.MavenModule;
import hudson.maven.MojoInfo;
import hudson.model.AbstractBuild;
import hudson.model.Job;
import hudson.model.Run;
import hudson.plugins.analysis.core.HealthAwareReporter;
import hudson.plugins.analysis.core.HealthDescriptor;
import hudson.plugins.analysis.core.ParserResult;
import hudson.plugins.analysis.core.ResultAction;
import hudson.plugins.analysis.util.PluginLogger;
import hudson.plugins.tasks.TasksMavenResultAction;
import hudson.plugins.tasks.TasksProjectAction;
import hudson.plugins.tasks.TasksReporterResult;
import hudson.plugins.tasks.TasksResult;
import hudson.plugins.tasks.parser.TasksParserResult;
import hudson.plugins.tasks.parser.WorkspaceScanner;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.apache.maven.project.MavenProject;
import org.kohsuke.stapler.DataBoundConstructor;

public class TasksReporter
extends HealthAwareReporter<TasksResult> {
    private static final long serialVersionUID = -4159947472293502606L;
    private static final String DEFAULT_PATTERN = "**/*.java";
    private final String pattern;
    private final String excludePattern;
    private final String high;
    private final String normal;
    private final String low;
    private final boolean ignoreCase;
    private final boolean asRegexp;
    @Deprecated
    @SuppressFBWarnings(value={""})
    private transient boolean isThresholdEnabled;
    @Deprecated
    @SuppressFBWarnings(value={""})
    private transient boolean isHealthyReportEnabled;
    @Deprecated
    @SuppressFBWarnings(value={""})
    private transient int healthyTasks;
    @Deprecated
    @SuppressFBWarnings(value={""})
    private transient int unHealthyTasks;
    @Deprecated
    @SuppressFBWarnings(value={""})
    private transient int minimumTasks;
    @Deprecated
    @SuppressFBWarnings(value={""})
    private transient String height;

    @DataBoundConstructor
    public TasksReporter(String pattern, String excludePattern, String healthy, String unHealthy, String thresholdLimit, boolean useDeltaValues, String unstableTotalAll, String unstableTotalHigh, String unstableTotalNormal, String unstableTotalLow, String unstableNewAll, String unstableNewHigh, String unstableNewNormal, String unstableNewLow, String failedTotalAll, String failedTotalHigh, String failedTotalNormal, String failedTotalLow, String failedNewAll, String failedNewHigh, String failedNewNormal, String failedNewLow, String high, String normal, String low, boolean ignoreCase, boolean asRegexp, boolean canRunOnFailed, boolean usePreviousBuildAsReference, boolean useStableBuildAsReference, boolean canComputeNew) {
        super(healthy, unHealthy, thresholdLimit, useDeltaValues, unstableTotalAll, unstableTotalHigh, unstableTotalNormal, unstableTotalLow, unstableNewAll, unstableNewHigh, unstableNewNormal, unstableNewLow, failedTotalAll, failedTotalHigh, failedTotalNormal, failedTotalLow, failedNewAll, failedNewHigh, failedNewNormal, failedNewLow, canRunOnFailed, usePreviousBuildAsReference, useStableBuildAsReference, canComputeNew, "TASKS");
        this.pattern = pattern;
        this.excludePattern = excludePattern;
        this.high = high;
        this.normal = normal;
        this.low = low;
        this.ignoreCase = ignoreCase;
        this.asRegexp = asRegexp;
    }

    public String getPattern() {
        return this.pattern;
    }

    public String getExcludePattern() {
        return this.excludePattern;
    }

    public String getHigh() {
        return this.high;
    }

    public String getNormal() {
        return this.normal;
    }

    public String getLow() {
        return this.low;
    }

    public boolean getIgnoreCase() {
        return this.ignoreCase;
    }

    public boolean getAsRegexp() {
        return this.asRegexp;
    }

    protected boolean acceptGoal(String goal) {
        return true;
    }

    public TasksParserResult perform(MavenBuildProxy build, MavenProject pom, MojoInfo mojo, PluginLogger logger) throws InterruptedException, IOException {
        FilePath basedir = new FilePath(pom.getBasedir());
        WorkspaceScanner workspaceScanner = new WorkspaceScanner(StringUtils.defaultIfEmpty((String)this.pattern, (String)DEFAULT_PATTERN), this.excludePattern, this.getDefaultEncoding(), this.high, this.normal, this.low, this.ignoreCase, pom.getName(), pom.getModules(), this.asRegexp);
        TasksParserResult project = (TasksParserResult)((Object)basedir.act((FilePath.FileCallable)workspaceScanner));
        project.setLog(project.getLogMessages() + String.format("Found %d open tasks.%n", project.getNumberOfAnnotations()));
        return project;
    }

    @SuppressFBWarnings(value={"BC"})
    protected TasksResult createResult(MavenBuild build, ParserResult project) {
        return new TasksReporterResult((Run<?, ?>)build, this.getDefaultEncoding(), (TasksParserResult)project, this.usePreviousBuildAsReference(), this.useOnlyStableBuildsAsReference(), this.high, this.normal, this.low);
    }

    protected MavenAggregatedReport createMavenAggregatedReport(MavenBuild build, TasksResult result) {
        return new TasksMavenResultAction((AbstractBuild<?, ?>)build, (HealthDescriptor)this, this.getDefaultEncoding(), this.high, this.normal, this.low, result);
    }

    public List<TasksProjectAction> getProjectActions(MavenModule module) {
        return Collections.singletonList(new TasksProjectAction((Job<?, ?>)module, (Class<? extends ResultAction<TasksResult>>)this.getResultActionClass()));
    }

    protected Class<TasksMavenResultAction> getResultActionClass() {
        return TasksMavenResultAction.class;
    }
}

