/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.tasks;

import com.thoughtworks.xstream.XStream;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import hudson.model.Run;
import hudson.plugins.analysis.core.BuildHistory;
import hudson.plugins.analysis.core.BuildResult;
import hudson.plugins.analysis.core.ParserResult;
import hudson.plugins.analysis.core.ResultAction;
import hudson.plugins.analysis.util.model.AnnotationContainer;
import hudson.plugins.analysis.util.model.AnnotationsLabelProvider;
import hudson.plugins.analysis.util.model.FileAnnotation;
import hudson.plugins.analysis.util.model.Priority;
import hudson.plugins.tasks.Messages;
import hudson.plugins.tasks.ResultSummary;
import hudson.plugins.tasks.TaskAnnotationsLabelProvider;
import hudson.plugins.tasks.TasksResultAction;
import hudson.plugins.tasks.parser.Task;
import hudson.plugins.tasks.parser.TasksParserResult;
import java.util.ArrayList;
import org.apache.commons.lang.StringUtils;

public class TasksResult
extends BuildResult {
    private static final long serialVersionUID = -344808345805935004L;
    private final String highTags;
    private final String normalTags;
    private final String lowTags;
    private final int numberOfFiles;
    @Deprecated
    @SuppressFBWarnings(value={"SE"})
    private transient int numberOfTasks;
    @Deprecated
    @SuppressFBWarnings(value={"SE"})
    private transient int highPriorityTasks;
    @Deprecated
    @SuppressFBWarnings(value={"SE"})
    private transient int lowPriorityTasks;
    @Deprecated
    @SuppressFBWarnings(value={"SE"})
    private transient int normalPriorityTasks;

    public TasksResult(Run<?, ?> build, String defaultEncoding, TasksParserResult result, boolean usePreviousBuildAsReference, boolean useStableBuildAsReference, String highTags, String normalTags, String lowTags) {
        this(build, defaultEncoding, result, usePreviousBuildAsReference, useStableBuildAsReference, highTags, normalTags, lowTags, TasksResultAction.class);
    }

    protected TasksResult(Run<?, ?> build, String defaultEncoding, TasksParserResult result, boolean usePreviousBuildAsReference, boolean useStableBuildAsReference, String highTags, String normalTags, String lowTags, Class<? extends ResultAction<TasksResult>> actionType) {
        super(build, new BuildHistory(build, actionType, usePreviousBuildAsReference, useStableBuildAsReference), (ParserResult)result, defaultEncoding);
        this.highTags = highTags;
        this.normalTags = normalTags;
        this.lowTags = lowTags;
        this.numberOfFiles = result.getNumberOfScannedFiles();
        this.serializeAnnotations(result.getAnnotations());
    }

    protected void attachLabelProvider(AnnotationContainer container) {
        container.setLabelProvider((AnnotationsLabelProvider)new TaskAnnotationsLabelProvider(container.getPackageCategoryTitle()));
    }

    protected void configure(XStream xstream) {
        xstream.alias("task", Task.class);
    }

    public String getSummary() {
        return ResultSummary.createSummary(this);
    }

    protected String createDeltaMessage() {
        return ResultSummary.createDeltaMessage(this);
    }

    public int getNumberOfFiles() {
        return this.numberOfFiles;
    }

    public String getDisplayName() {
        return Messages.Tasks_ProjectAction_Name();
    }

    protected String getSerializationFileName() {
        return "open-tasks.xml";
    }

    public Priority[] getPriorities() {
        ArrayList<Priority> priorities = new ArrayList<Priority>();
        if (StringUtils.isNotEmpty((String)this.highTags)) {
            priorities.add(Priority.HIGH);
        }
        if (StringUtils.isNotEmpty((String)this.normalTags)) {
            priorities.add(Priority.NORMAL);
        }
        if (StringUtils.isNotEmpty((String)this.lowTags)) {
            priorities.add(Priority.LOW);
        }
        return priorities.toArray(new Priority[priorities.size()]);
    }

    public final String getTags(Priority priority) {
        if (priority == Priority.HIGH) {
            return this.highTags;
        }
        if (priority == Priority.NORMAL) {
            return this.normalTags;
        }
        return this.lowTags;
    }

    public String getPackageCategoryName() {
        String fileName;
        if (this.hasAnnotations() && (fileName = ((FileAnnotation)this.getAnnotations().iterator().next()).getFileName()).endsWith(".cs")) {
            return Messages.Tasks_NamespaceDetail();
        }
        return Messages.Tasks_PackageDetail();
    }

    protected Class<? extends ResultAction<? extends BuildResult>> getResultActionType() {
        return TasksResultAction.class;
    }
}

