/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.tasks.parser;

import hudson.FilePath;
import hudson.plugins.analysis.util.ContextHashCode;
import hudson.plugins.analysis.util.EncodingValidator;
import hudson.plugins.analysis.util.ModuleDetector;
import hudson.plugins.analysis.util.NullModuleDetector;
import hudson.plugins.analysis.util.PackageDetectors;
import hudson.plugins.analysis.util.StringPluginLogger;
import hudson.plugins.tasks.parser.Task;
import hudson.plugins.tasks.parser.TaskScanner;
import hudson.plugins.tasks.parser.TasksParserResult;
import hudson.remoting.VirtualChannel;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.Collection;
import java.util.List;
import jenkins.MasterToSlaveFileCallable;
import org.apache.commons.lang.StringUtils;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.types.FileSet;

public class WorkspaceScanner
extends MasterToSlaveFileCallable<TasksParserResult> {
    private static final long serialVersionUID = -4355362392102020724L;
    private final String filePattern;
    private String excludeFilePattern;
    private String moduleName;
    private final String high;
    private final String normal;
    private final String low;
    private final boolean ignoreCase;
    private String prefix;
    private final String defaultEncoding;
    private final boolean shouldDetectModules;
    private final boolean asRegexp;
    private transient StringPluginLogger stringLogger;

    public WorkspaceScanner(String filePattern, String excludeFilePattern, String defaultEncoding, String high, String normal, String low, boolean ignoreCase, boolean shouldDetectModules, boolean asRegexp) {
        this.filePattern = filePattern;
        this.excludeFilePattern = excludeFilePattern;
        this.defaultEncoding = defaultEncoding;
        this.high = high;
        this.normal = normal;
        this.low = low;
        this.ignoreCase = ignoreCase;
        this.shouldDetectModules = shouldDetectModules;
        this.asRegexp = asRegexp;
    }

    protected void log(String message) {
        if (this.stringLogger == null) {
            this.stringLogger = new StringPluginLogger("TASKS");
        }
        this.stringLogger.log(message);
    }

    public WorkspaceScanner(String filePattern, String excludeFilePattern, String defaultEncoding, String high, String normal, String low, boolean caseSensitive, String moduleName, boolean asRegexp) {
        this(filePattern, excludeFilePattern, defaultEncoding, high, normal, low, caseSensitive, false, asRegexp);
        this.moduleName = moduleName;
    }

    public WorkspaceScanner(String filePattern, String excludeFilePattern, String defaultEncoding, String high, String normal, String low, boolean caseSensitive, String moduleName, List<String> modules, boolean asRegexp) {
        this(filePattern, excludeFilePattern, defaultEncoding, high, normal, low, caseSensitive, moduleName, asRegexp);
        StringBuilder excludes = new StringBuilder(excludeFilePattern);
        for (String folder : modules) {
            if (StringUtils.isNotBlank((String)excludes.toString())) {
                excludes.append(", ");
            }
            excludes.append(folder);
            excludes.append("/**/*");
        }
        this.excludeFilePattern = excludes.toString();
    }

    public void setPrefix(String prefix) {
        this.prefix = prefix + "/";
    }

    public String getPrefix() {
        return StringUtils.defaultIfEmpty((String)this.prefix, (String)"");
    }

    public TasksParserResult invoke(File workspace, VirtualChannel channel) throws IOException, InterruptedException {
        String[] files = this.findFiles(workspace);
        TaskScanner taskScanner = new TaskScanner(this.high, this.normal, this.low, this.ignoreCase, this.asRegexp);
        TasksParserResult result = new TasksParserResult(files.length);
        ModuleDetector moduleDetector = this.createModuleDetector(workspace);
        this.log("Found " + files.length + " files to scan for tasks");
        for (String fileName : files) {
            try {
                File originalFile = new File(workspace, fileName);
                Collection<Task> tasks = taskScanner.scan(this.readFile(originalFile));
                if (!tasks.isEmpty()) {
                    String absolutePath = originalFile.getAbsolutePath();
                    String packageName = PackageDetectors.detectPackageName((String)absolutePath);
                    String guessedModule = moduleDetector.guessModuleName(absolutePath);
                    String actualModule = StringUtils.defaultIfEmpty((String)this.moduleName, (String)guessedModule);
                    for (Task task : tasks) {
                        task.setFileName(absolutePath);
                        task.setPackageName(packageName);
                        task.setModuleName(actualModule);
                        task.setPathName(workspace.getPath());
                        ContextHashCode hashCode = new ContextHashCode();
                        task.setContextHashCode(hashCode.create(absolutePath, task.getPrimaryLineNumber(), this.defaultEncoding));
                    }
                    result.addAnnotations(tasks);
                }
            }
            catch (IOException exception) {
                // empty catch block
            }
            if (!Thread.interrupted()) continue;
            throw new InterruptedException("Canceling scanning since build has been aborted.");
        }
        result.addModule(this.moduleName);
        if (this.stringLogger != null) {
            result.setLog(this.stringLogger.toString());
        }
        return result;
    }

    private InputStreamReader readFile(File originalFile) throws IOException, InterruptedException {
        return new InputStreamReader(new FilePath(originalFile).read(), EncodingValidator.defaultCharset((String)this.defaultEncoding));
    }

    private ModuleDetector createModuleDetector(File workspace) {
        if (this.shouldDetectModules) {
            return new ModuleDetector(workspace);
        }
        return new NullModuleDetector();
    }

    private String[] findFiles(File workspaceRoot) {
        FileSet fileSet = new FileSet();
        Project project = new Project();
        fileSet.setProject(project);
        fileSet.setDir(workspaceRoot);
        fileSet.setIncludes(this.filePattern);
        if (StringUtils.isNotBlank((String)this.excludeFilePattern)) {
            fileSet.setExcludes(this.excludeFilePattern);
        }
        this.log("Scanning folder '" + workspaceRoot + "' for files matching the pattern '" + this.filePattern + "' - excludes: " + this.excludeFilePattern);
        return fileSet.getDirectoryScanner(project).getIncludedFiles();
    }
}

